/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean;

import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserRecord
implements Serializable {
    private static final long serialVersionUID = -6661580072748171679L;
    private final Map<String, Object> propertyMap;
    private final String distinctId;
    private final Boolean isLoginId;
    private final Integer trackId;

    private UserRecord(Map<String, Object> propertyMap, String distinctId, Boolean isLoginId, Integer trackId) {
        this.propertyMap = propertyMap;
        if (isLoginId.booleanValue()) {
            propertyMap.put("$is_login_id", true);
        }
        this.distinctId = distinctId;
        this.isLoginId = isLoginId;
        this.trackId = trackId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public Boolean getIsLoginId() {
        return this.isLoginId;
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public Integer getTrackId() {
        return this.trackId;
    }

    public static class Builder {
        private final Map<String, Object> propertyMap = new HashMap<String, Object>();
        private String distinctId;
        private Boolean isLoginId;
        private Integer trackId;

        private Builder() {
        }

        public UserRecord build() throws InvalidArgumentException {
            if (this.distinctId == null) {
                throw new InvalidArgumentException("The distinctId is empty.");
            }
            if (this.isLoginId == null) {
                throw new InvalidArgumentException("The isLoginId is empty.");
            }
            SensorsAnalyticsUtil.assertValue("distinct_id", this.distinctId);
            String message = String.format("[distinct_id=%s,target_table=user]", this.distinctId);
            this.trackId = SensorsAnalyticsUtil.getTrackId(this.propertyMap, message);
            return new UserRecord(this.propertyMap, this.distinctId, this.isLoginId, this.trackId);
        }

        public Builder setDistinctId(String distinctId) {
            this.distinctId = distinctId;
            return this;
        }

        public Builder isLoginId(Boolean loginId) {
            this.isLoginId = loginId;
            return this;
        }

        public Builder addProperties(Map<String, Object> properties) {
            if (properties != null) {
                this.propertyMap.putAll(properties);
            }
            return this;
        }

        public Builder addProperty(String key, String property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, boolean property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Number property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Date property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, List<String> property) {
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(String key, Object property) {
            if (key != null) {
                this.propertyMap.put(key, property);
            }
        }
    }
}

