/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean;

import com.sensorsdata.analytics.javasdk.common.Pair;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class IDMEventRecord {
    private String eventName;
    private String distinctId;
    private Map<String, Object> propertyMap;
    private Integer trackId;
    private Map<String, Object> identityMap;

    protected IDMEventRecord(Map<String, Object> identityMap, String eventName, String distinctId, Map<String, Object> propertyMap, Integer trackId) {
        this.identityMap = identityMap;
        this.eventName = eventName;
        this.distinctId = distinctId;
        this.propertyMap = propertyMap;
        this.trackId = trackId;
    }

    public static IDMBuilder starter() {
        return new IDMBuilder();
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public Integer getTrackId() {
        return this.trackId;
    }

    public Map<String, Object> getIdentityMap() {
        return this.identityMap;
    }

    public static class IDMBuilder {
        private final Map<String, Object> idMap = new LinkedHashMap<String, Object>();
        private final Map<String, Object> propertyMap = new HashMap<String, Object>();
        private String eventName;
        private String distinctId;
        private Integer trackId;

        public IDMEventRecord build() throws InvalidArgumentException {
            SensorsAnalyticsUtil.assertKey("event_name", this.eventName);
            if (this.propertyMap.size() != 0) {
                SensorsAnalyticsUtil.assertProperties("track", this.propertyMap);
            }
            if (this.idMap.size() < 1) {
                throw new InvalidArgumentException("The identity is empty.");
            }
            Pair<String, Boolean> resPair = SensorsAnalyticsUtil.checkIdentitiesAndGenerateDistinctId(this.distinctId, this.idMap);
            if (resPair.getValue().booleanValue()) {
                this.propertyMap.put("$is_login_id", true);
            }
            String message = String.format("[distinct_id=%s,event_name=%s]", this.distinctId, this.eventName);
            this.trackId = SensorsAnalyticsUtil.getTrackId(this.propertyMap, message);
            return new IDMEventRecord(this.idMap, this.eventName, resPair.getKey(), this.propertyMap, this.trackId);
        }

        public IDMBuilder identityMap(Map<String, String> identityMap) {
            if (identityMap != null) {
                this.idMap.putAll(identityMap);
            }
            return this;
        }

        public IDMBuilder addIdentityProperty(String key, String value) {
            this.idMap.put(key, value);
            return this;
        }

        public IDMBuilder setEventName(@NonNull String eventName) {
            if (eventName == null) {
                throw new NullPointerException("eventName is marked non-null but is null");
            }
            this.eventName = eventName;
            return this;
        }

        public IDMBuilder setDistinctId(@NonNull String distinctId) {
            if (distinctId == null) {
                throw new NullPointerException("distinctId is marked non-null but is null");
            }
            this.distinctId = distinctId;
            return this;
        }

        public IDMBuilder addProperties(Map<String, Object> properties) {
            if (properties != null) {
                this.propertyMap.putAll(properties);
            }
            return this;
        }

        public IDMBuilder addProperty(String key, String property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public IDMBuilder addProperty(String key, boolean property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public IDMBuilder addProperty(String key, Number property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public IDMBuilder addProperty(String key, Date property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public IDMBuilder addProperty(String key, List<String> property) {
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(String key, Object property) {
            if (key != null) {
                this.propertyMap.put(key, property);
            }
        }

        private IDMBuilder() {
        }
    }
}

