/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk.bean;

import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventRecord
implements Serializable {
    private static final long serialVersionUID = -2327319579147636283L;
    private final Map<String, Object> propertyMap;
    private final String eventName;
    private final String distinctId;
    private final Boolean isLoginId;
    private final Integer trackId;
    private final String originalId;

    private EventRecord(String eventName, String distinctId, Boolean isLoginId, Map<String, Object> propertyMap, Integer trackId, String originalId) {
        this.eventName = eventName;
        this.distinctId = distinctId;
        this.isLoginId = isLoginId;
        if (isLoginId.booleanValue()) {
            propertyMap.put("$is_login_id", true);
        }
        this.propertyMap = propertyMap;
        this.trackId = trackId;
        this.originalId = originalId;
    }

    public String toString() {
        return "EventRecord{propertyMap=" + this.propertyMap + ", eventName='" + this.eventName + '\'' + ", distinctId='" + this.distinctId + '\'' + ", isLoginId='" + this.isLoginId + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public Map<String, Object> getPropertyMap() {
        return this.propertyMap;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public Boolean getIsLoginId() {
        return this.isLoginId;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public Integer getTrackId() {
        return this.trackId;
    }

    public static class Builder {
        private final Map<String, Object> propertyMap = new HashMap<String, Object>();
        private String eventName;
        private String distinctId;
        private Boolean isLoginId;
        private Integer trackId;
        private String originalId;

        private Builder() {
        }

        public EventRecord build() throws InvalidArgumentException {
            if (this.eventName == null) {
                throw new InvalidArgumentException("The eventName is empty.");
            }
            if (this.distinctId == null) {
                throw new InvalidArgumentException("The distinctId is empty.");
            }
            if (this.isLoginId == null) {
                throw new InvalidArgumentException("The isLoginId is empty.");
            }
            SensorsAnalyticsUtil.assertKey("event_name", this.eventName);
            SensorsAnalyticsUtil.assertProperties("property", this.propertyMap);
            SensorsAnalyticsUtil.assertValue("distinct_id", this.distinctId);
            String message = String.format("[distinct_id=%s,event_name=%s,is_login_id=%s]", this.distinctId, this.eventName, this.isLoginId);
            this.trackId = SensorsAnalyticsUtil.getTrackId(this.propertyMap, message);
            return new EventRecord(this.eventName, this.distinctId, this.isLoginId, this.propertyMap, this.trackId, this.originalId);
        }

        public Builder setOriginalId(String originalId) {
            this.originalId = originalId;
            return this;
        }

        public Builder setEventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public Builder setDistinctId(String distinctId) {
            this.distinctId = distinctId;
            return this;
        }

        public Builder isLoginId(Boolean loginId) {
            this.isLoginId = loginId;
            return this;
        }

        public Builder addProperties(Map<String, Object> properties) {
            if (properties != null) {
                this.propertyMap.putAll(properties);
            }
            return this;
        }

        public Builder addProperty(String key, String property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, boolean property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Number property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, Date property) {
            this.addPropertyObject(key, property);
            return this;
        }

        public Builder addProperty(String key, List<String> property) {
            this.addPropertyObject(key, property);
            return this;
        }

        private void addPropertyObject(String key, Object property) {
            if (key != null) {
                this.propertyMap.put(key, property);
            }
        }
    }
}

