/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk;

import com.sensorsdata.analytics.javasdk.SensorsData;
import com.sensorsdata.analytics.javasdk.bean.schema.DetailSchema;
import com.sensorsdata.analytics.javasdk.bean.schema.ItemEventSchema;
import com.sensorsdata.analytics.javasdk.bean.schema.ItemSchema;
import com.sensorsdata.analytics.javasdk.bean.schema.UserEventSchema;
import com.sensorsdata.analytics.javasdk.bean.schema.UserSchema;
import com.sensorsdata.analytics.javasdk.common.Pair;
import com.sensorsdata.analytics.javasdk.common.SchemaTypeEnum;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SensorsSchemaData
extends SensorsData {
    private static final Logger log = LoggerFactory.getLogger(SensorsSchemaData.class);
    private String version = "2.0";
    private String schema;
    private Long userId;
    private String detailId;
    private Pair<String, String> itemEventPair;
    private SchemaTypeEnum schemaTypeEnum;

    protected SensorsSchemaData(UserEventSchema userEventSchema, String actionType) {
        super(userEventSchema.getDistinctId(), null, userEventSchema.getIdentityMap(), actionType, userEventSchema.getEventName(), userEventSchema.getPropertyMap(), null, null, userEventSchema.getTrackId());
        this.schema = "events";
        this.userId = userEventSchema.getUserId();
        this.schemaTypeEnum = SchemaTypeEnum.USER_EVENT;
    }

    protected SensorsSchemaData(ItemSchema itemSchema, String actionType) {
        super(itemSchema.getTrackId(), null, null, itemSchema.getItemId(), actionType, null, itemSchema.getProperties());
        this.schema = itemSchema.getSchema();
        this.schemaTypeEnum = SchemaTypeEnum.ITEM;
    }

    protected SensorsSchemaData(ItemEventSchema itemEventSchema, String actionType) {
        super(itemEventSchema.getTrackId(), null, null, null, actionType, itemEventSchema.getEventName(), itemEventSchema.getProperties());
        this.schema = itemEventSchema.getSchema();
        this.itemEventPair = itemEventSchema.getItemPair();
        this.schemaTypeEnum = SchemaTypeEnum.ITEM_EVENT;
    }

    protected SensorsSchemaData(UserSchema userSchema, String actionType) {
        super(userSchema.getDistinctId(), actionType, userSchema.getIdentityMap(), userSchema.getPropertyMap(), userSchema.getTrackId());
        this.schema = "users";
        this.userId = userSchema.getUserId();
        this.schemaTypeEnum = SchemaTypeEnum.USER;
    }

    protected SensorsSchemaData(DetailSchema detailSchema, String actionType) {
        super(detailSchema.getTrackId(), detailSchema.getDistinctId(), detailSchema.getIdentities(), null, actionType, null, detailSchema.getProperties());
        this.schema = detailSchema.getSchema();
        this.itemEventPair = detailSchema.getItemPair();
        this.detailId = detailSchema.getDetailId();
        this.schemaTypeEnum = SchemaTypeEnum.DETAIL;
    }

    public Map<String, Object> generateData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("_track_id", this.getTrackId());
        data.put("version", this.version);
        data.put("type", this.getType());
        data.put("schema", this.schema);
        data.put("lib", this.getLib());
        data.put("time", this.getTime().getTime());
        if (this.getProject() != null && !"".equals(this.getProject())) {
            data.put("project", this.getProject());
        }
        if (this.getToken() != null && !"".equals(this.getToken())) {
            data.put("token", this.getToken());
        }
        switch (this.schemaTypeEnum) {
            case ITEM: {
                data.put("id", this.getItemId());
                break;
            }
            case ITEM_EVENT: {
                this.getProperties().put(this.itemEventPair.getKey(), this.itemEventPair.getValue());
                this.addTimeFree(data);
                data.put("event", this.getEvent());
                break;
            }
            case USER: {
                this.checkUserIdAndAddUser(data, "id");
                break;
            }
            case USER_EVENT: {
                this.addTimeFree(data);
                data.put("event", this.getEvent());
                this.checkUserIdAndAddUser(this.getProperties(), "user_id");
                break;
            }
            case USER_ITEM: {
                data.put("id", this.getItemId());
                this.checkUserIdAndAddUser(this.getProperties(), "user_id");
                break;
            }
            case DETAIL: {
                data.put("id", this.detailId);
                if (this.itemEventPair != null) {
                    this.getProperties().put(this.itemEventPair.getKey(), this.itemEventPair.getValue());
                }
                if (this.getIdentities().isEmpty()) break;
                this.checkUserIdAndAddUser(this.getProperties(), "user_id");
            }
        }
        data.put("properties", this.getProperties());
        return data;
    }

    public boolean isEventSchemaData() {
        return SchemaTypeEnum.ITEM_EVENT.equals((Object)this.schemaTypeEnum) || SchemaTypeEnum.USER_EVENT.equals((Object)this.schemaTypeEnum);
    }

    public String getVersion() {
        return this.version;
    }

    public String getSchema() {
        return this.schema;
    }

    public Long getUserId() {
        return this.userId;
    }

    public SchemaTypeEnum getSchemaTypeEnum() {
        return this.schemaTypeEnum;
    }

    private void addTimeFree(Map<String, Object> data) {
        if (this.isTimeFree() && ("track".equals(this.getType()) || "track_signup".equals(this.getType()) || "track_id_bind".equals(this.getType()) || "track_id_unbind".equals(this.getType()))) {
            data.put("time_free", true);
        }
    }

    private void checkUserIdAndAddUser(Map<String, Object> data, String key) {
        if (null != this.getUserId()) {
            data.put(key, this.getUserId());
        } else if (null != this.getIdentities() && !this.getIdentities().isEmpty()) {
            data.put("identities", this.getIdentities());
        }
        if (null != this.getDistinctId()) {
            data.put("distinct_id", this.getDistinctId());
        }
    }
}

