/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk;

import com.sensorsdata.analytics.javasdk.bean.EventRecord;
import com.sensorsdata.analytics.javasdk.bean.IDMEventRecord;
import com.sensorsdata.analytics.javasdk.bean.IDMUserRecord;
import com.sensorsdata.analytics.javasdk.bean.ItemRecord;
import com.sensorsdata.analytics.javasdk.bean.UserRecord;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

class SensorsData {
    private Integer trackId;
    private String distinctId;
    private String originalId;
    private Map<String, Object> identities;
    private String type;
    private String event;
    private Map<String, String> lib;
    private Date time;
    private Map<String, Object> properties;
    private String project;
    private String token;
    private String itemType;
    private String itemId;
    private boolean timeFree = false;

    protected SensorsData() {
    }

    protected SensorsData(EventRecord eventRecord, String actionType) {
        this(eventRecord.getDistinctId(), eventRecord.getOriginalId(), null, actionType, eventRecord.getEventName(), eventRecord.getPropertyMap(), null, null, eventRecord.getTrackId());
    }

    protected SensorsData(ItemRecord itemRecord, String actionType) {
        this(null, null, null, actionType, null, itemRecord.getPropertyMap(), itemRecord.getItemType(), itemRecord.getItemId(), itemRecord.getTrackId());
    }

    protected SensorsData(UserRecord userRecord, String actionType) {
        this(userRecord.getDistinctId(), actionType, null, userRecord.getPropertyMap(), userRecord.getTrackId());
    }

    protected <T extends IDMUserRecord> SensorsData(T userRecord, String actionType) {
        this(userRecord.getDistinctId(), actionType, userRecord.getIdentityMap(), userRecord.getPropertyMap(), userRecord.getTrackId());
    }

    protected <T extends IDMEventRecord> SensorsData(T eventRecord) {
        this(eventRecord.getDistinctId(), eventRecord.getIdentityMap(), eventRecord.getEventName(), eventRecord.getPropertyMap(), eventRecord.getTrackId());
    }

    protected <T extends IDMEventRecord> SensorsData(T eventRecord, String actionType) {
        this(eventRecord.getDistinctId(), null, eventRecord.getIdentityMap(), actionType, eventRecord.getEventName(), eventRecord.getPropertyMap(), null, null, eventRecord.getTrackId());
    }

    protected SensorsData(String distinctId, String type, Map<String, Object> identities, Map<String, Object> properties, Integer trackId) {
        this(distinctId, null, identities, type, null, properties, null, null, trackId);
    }

    protected SensorsData(String distinctId, Map<String, Object> identities, String event, Map<String, Object> properties, Integer trackId) {
        this(distinctId, null, identities, "track", event, properties, null, null, trackId);
    }

    protected SensorsData(Integer trackId, String distinctId, Map<String, Object> identities, String itemId, String type, String event, Map<String, Object> properties) {
        this(distinctId, null, identities, type, event, properties, null, itemId, trackId);
    }

    protected SensorsData(String distinctId, String originalId, Map<String, Object> identities, String type, String event, Map<String, Object> properties, String itemType, String itemId, Integer trackId) {
        this.trackId = trackId;
        this.distinctId = distinctId;
        this.originalId = originalId;
        this.identities = identities;
        this.type = type;
        this.event = event;
        this.time = properties.containsKey("$time") ? (Date)properties.remove("$time") : new Date();
        this.properties = properties;
        this.itemType = itemType;
        this.itemId = itemId;
        this.project = properties.get("$project") == null ? null : String.valueOf(properties.remove("$project"));
        this.token = properties.get("$token") == null ? null : String.valueOf(properties.remove("$token"));
        this.timeFree = properties.containsKey("$time_free") && Boolean.parseBoolean(properties.remove("$time_free").toString());
    }

    protected static Map<String, Object> generateData(SensorsData sensorsData) {
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        if (sensorsData.getTrackId() != null) {
            eventMap.put("_track_id", sensorsData.getTrackId());
        }
        if (sensorsData.getDistinctId() != null) {
            eventMap.put("distinct_id", sensorsData.getDistinctId());
        }
        if (sensorsData.getOriginalId() != null) {
            eventMap.put("original_id", sensorsData.getOriginalId());
        }
        if (sensorsData.getIdentities() != null) {
            eventMap.put("identities", sensorsData.getIdentities());
        }
        if (sensorsData.getType() != null) {
            eventMap.put("type", sensorsData.getType());
        }
        if (sensorsData.getEvent() != null) {
            eventMap.put("event", sensorsData.getEvent());
        }
        eventMap.put("time", sensorsData.getTime().getTime());
        if (sensorsData.getProject() != null) {
            eventMap.put("project", sensorsData.getProject());
        }
        if (sensorsData.getToken() != null) {
            eventMap.put("token", sensorsData.getToken());
        }
        if (sensorsData.getItemId() != null) {
            eventMap.put("item_id", sensorsData.getItemId());
        }
        if (sensorsData.getItemType() != null) {
            eventMap.put("item_type", sensorsData.getItemType());
        }
        if (sensorsData.getProperties() != null) {
            eventMap.put("properties", sensorsData.getProperties());
        }
        if (sensorsData.isTimeFree() && ("track".equals(sensorsData.getType()) || "track_signup".equals(sensorsData.getType()) || "track_id_bind".equals(sensorsData.getType()) || "track_id_unbind".equals(sensorsData.getType()))) {
            eventMap.put("time_free", true);
        }
        return eventMap;
    }

    public Integer getTrackId() {
        return this.trackId;
    }

    public String getDistinctId() {
        return this.distinctId;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public Map<String, Object> getIdentities() {
        return this.identities;
    }

    public String getType() {
        return this.type;
    }

    public String getEvent() {
        return this.event;
    }

    public Map<String, String> getLib() {
        return this.lib;
    }

    public Date getTime() {
        return this.time;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public String getProject() {
        return this.project;
    }

    public String getToken() {
        return this.token;
    }

    public String getItemType() {
        return this.itemType;
    }

    public String getItemId() {
        return this.itemId;
    }

    public boolean isTimeFree() {
        return this.timeFree;
    }

    public void setTrackId(Integer trackId) {
        this.trackId = trackId;
    }

    public void setDistinctId(String distinctId) {
        this.distinctId = distinctId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public void setIdentities(Map<String, Object> identities) {
        this.identities = identities;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setLib(Map<String, String> lib) {
        this.lib = lib;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public void setTimeFree(boolean timeFree) {
        this.timeFree = timeFree;
    }
}

