/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk;

import com.sensorsdata.analytics.javasdk.SensorsData;
import com.sensorsdata.analytics.javasdk.SensorsSchemaData;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SensorsAnalyticsWorker {
    private static final Logger log = LoggerFactory.getLogger(SensorsAnalyticsWorker.class);
    private final Consumer consumer;
    private boolean timeFree = false;
    private boolean enableCollectMethodStack = true;

    public SensorsAnalyticsWorker(Consumer consumer) {
        this.consumer = consumer;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                log.info("Triggered flush when the program is closed.");
                SensorsAnalyticsWorker.this.flush();
            }
        }));
    }

    void doAddData(@NonNull SensorsData sensorsData) {
        if (sensorsData == null) {
            throw new NullPointerException("sensorsData is marked non-null but is null");
        }
        Map<String, Object> data = SensorsData.generateData(sensorsData);
        data.put("lib", this.generateLibInfo());
        if (this.timeFree && ("track".equals(sensorsData.getType()) || "track_signup".equals(sensorsData.getType())) || "track_id_bind".equals(sensorsData.getType()) || "track_id_unbind".equals(sensorsData.getType())) {
            data.put("time_free", true);
        }
        this.consumer.send(data);
    }

    void flush() {
        this.consumer.flush();
    }

    void shutdown() {
        this.consumer.close();
    }

    public void doSchemaData(@NonNull SensorsSchemaData schemaData) {
        if (schemaData == null) {
            throw new NullPointerException("schemaData is marked non-null but is null");
        }
        Map<String, Object> sensorsData = schemaData.generateData();
        sensorsData.put("lib", this.generateLibInfo());
        if (this.timeFree && ("track".equals(schemaData.getType()) || "track_signup".equals(schemaData.getType()) || "track_id_bind".equals(schemaData.getType()) || "track_id_unbind".equals(schemaData.getType()))) {
            sensorsData.put("time_free", true);
        }
        this.consumer.send(sensorsData);
    }

    public void setEnableTimeFree(boolean enableTimeFree) {
        this.timeFree = enableTimeFree;
    }

    public void setEnableCollectMethodStack(boolean enableCollectMethodStack) {
        this.enableCollectMethodStack = enableCollectMethodStack;
    }

    public Map<String, String> generateLibInfo() {
        HashMap<String, String> libProperties = new HashMap<String, String>();
        libProperties.put("$lib", "Java");
        libProperties.put("$lib_version", "3.6.9");
        libProperties.put("$lib_method", "code");
        if (this.enableCollectMethodStack) {
            StackTraceElement[] trace = new Exception().getStackTrace();
            if (trace.length > 3) {
                StackTraceElement traceElement = trace[3];
                libProperties.put("$lib_detail", String.format("%s##%s##%s##%s", traceElement.getClassName(), traceElement.getMethodName(), traceElement.getFileName(), traceElement.getLineNumber()));
            }
        } else {
            libProperties.put("$lib_detail", "JavaSDK##generateLibInfo");
        }
        return libProperties;
    }
}

