/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk;

import com.sensorsdata.analytics.javasdk.ISensorsAnalytics;
import com.sensorsdata.analytics.javasdk.SensorsAnalyticsWorker;
import com.sensorsdata.analytics.javasdk.SensorsData;
import com.sensorsdata.analytics.javasdk.SensorsSchemaData;
import com.sensorsdata.analytics.javasdk.bean.EventRecord;
import com.sensorsdata.analytics.javasdk.bean.IDMEventRecord;
import com.sensorsdata.analytics.javasdk.bean.IDMUserRecord;
import com.sensorsdata.analytics.javasdk.bean.ItemRecord;
import com.sensorsdata.analytics.javasdk.bean.SensorsAnalyticsIdentity;
import com.sensorsdata.analytics.javasdk.bean.SuperPropertiesRecord;
import com.sensorsdata.analytics.javasdk.bean.UserRecord;
import com.sensorsdata.analytics.javasdk.bean.schema.DetailSchema;
import com.sensorsdata.analytics.javasdk.bean.schema.IdentitySchema;
import com.sensorsdata.analytics.javasdk.bean.schema.ItemEventSchema;
import com.sensorsdata.analytics.javasdk.bean.schema.ItemSchema;
import com.sensorsdata.analytics.javasdk.bean.schema.UserEventSchema;
import com.sensorsdata.analytics.javasdk.bean.schema.UserSchema;
import com.sensorsdata.analytics.javasdk.consumer.Consumer;
import com.sensorsdata.analytics.javasdk.exceptions.InvalidArgumentException;
import com.sensorsdata.analytics.javasdk.util.SensorsAnalyticsUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorsAnalytics
implements ISensorsAnalytics {
    private static final Logger log = LoggerFactory.getLogger(SensorsAnalytics.class);
    private final SensorsAnalyticsWorker worker;
    private static final String DISTINCT_ID = "distinct_id";
    private static final String EVENT_NAME = "event name";
    private static final String ORIGINAL_DISTINCT_ID = "Original Distinct Id";
    private final Map<String, Object> superProperties = new ConcurrentHashMap<String, Object>();

    void setSuperProperties(Map<String, Object> superProperties) {
        for (Map.Entry<String, Object> entry : superProperties.entrySet()) {
            if (!SensorsAnalyticsUtil.KEY_PATTERN.matcher(entry.getKey()).matches() || "$track_id".equals(entry.getKey())) continue;
            this.superProperties.put(entry.getKey(), entry.getValue());
        }
    }

    void clearSuperProper() {
        this.superProperties.clear();
        this.superProperties.put("$lib", "Java");
        this.superProperties.put("$lib_version", "3.6.9");
        log.info("Call clearSuperProperties method.");
    }

    @Override
    public void setGlobalEnableCollectMethodStack(boolean enableCollectLibDetail) {
        this.worker.setEnableCollectMethodStack(enableCollectLibDetail);
    }

    public SensorsAnalytics(Consumer consumer) {
        this.clearSuperProper();
        this.worker = new SensorsAnalyticsWorker(consumer);
    }

    @Override
    public void setEnableTimeFree(@NonNull boolean enableTimeFree) {
        this.worker.setEnableTimeFree(enableTimeFree);
    }

    @Override
    public void registerSuperProperties(@NonNull SuperPropertiesRecord propertiesRecord) {
        if (propertiesRecord == null) {
            throw new NullPointerException("propertiesRecord is marked non-null but is null");
        }
        this.setSuperProperties(propertiesRecord.getPropertyMap());
    }

    @Override
    public void registerSuperProperties(@NonNull Map<String, Object> superPropertiesMap) {
        if (superPropertiesMap == null) {
            throw new NullPointerException("superPropertiesMap is marked non-null but is null");
        }
        this.setSuperProperties(superPropertiesMap);
    }

    @Override
    public void clearSuperProperties() {
        this.clearSuperProper();
    }

    @Override
    public void track(@NonNull EventRecord eventRecord) throws InvalidArgumentException {
        if (eventRecord == null) {
            throw new NullPointerException("eventRecord is marked non-null but is null");
        }
        eventRecord.getPropertyMap().putAll(this.putAllSuperPro(eventRecord.getPropertyMap(), this.superProperties));
        this.worker.doAddData(new SensorsData(eventRecord, "track"));
    }

    @Override
    public void profileSet(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_set");
    }

    @Override
    public void profileSetOnce(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_set_once");
    }

    @Override
    public void profileAppend(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_append");
    }

    @Override
    public void profileIncrement(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_increment");
    }

    @Override
    public void profileUnset(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        if (userRecord.getPropertyMap() == null) {
            return;
        }
        for (Map.Entry<String, Object> property : userRecord.getPropertyMap().entrySet()) {
            boolean value;
            if ("$project".equals(property.getKey()) || property.getValue() instanceof Boolean && (value = ((Boolean)property.getValue()).booleanValue())) continue;
            throw new InvalidArgumentException("The property value of " + property.getKey() + " should be true.");
        }
        this.dealProfile(userRecord, "profile_unset");
    }

    @Override
    public void profileDelete(@NonNull UserRecord userRecord) throws InvalidArgumentException {
        if (userRecord == null) {
            throw new NullPointerException("userRecord is marked non-null but is null");
        }
        this.dealProfile(userRecord, "profile_delete");
    }

    @Override
    public void itemSet(@NonNull ItemRecord itemRecord) throws InvalidArgumentException {
        if (itemRecord == null) {
            throw new NullPointerException("itemRecord is marked non-null but is null");
        }
        this.addItem(itemRecord.getItemType(), itemRecord.getItemId(), "item_set", itemRecord.getPropertyMap());
    }

    @Override
    public void itemDelete(@NonNull ItemRecord itemRecord) throws InvalidArgumentException {
        if (itemRecord == null) {
            throw new NullPointerException("itemRecord is marked non-null but is null");
        }
        this.addItem(itemRecord.getItemType(), itemRecord.getItemId(), "item_delete", itemRecord.getPropertyMap());
    }

    @Override
    public void track(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String eventName) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        this.addEvent(distinctId, isLoginId, null, "track", eventName, null);
    }

    @Override
    public void track(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        this.addEvent(distinctId, isLoginId, null, "track", eventName, properties);
    }

    @Override
    public void trackSignUp(@NonNull String loginId, @NonNull String anonymousId) throws InvalidArgumentException {
        if (loginId == null) {
            throw new NullPointerException("loginId is marked non-null but is null");
        }
        if (anonymousId == null) {
            throw new NullPointerException("anonymousId is marked non-null but is null");
        }
        this.addEvent(loginId, false, anonymousId, "track_signup", "$SignUp", null);
    }

    @Override
    public void trackSignUp(@NonNull String loginId, @NonNull String anonymousId, Map<String, Object> properties) throws InvalidArgumentException {
        if (loginId == null) {
            throw new NullPointerException("loginId is marked non-null but is null");
        }
        if (anonymousId == null) {
            throw new NullPointerException("anonymousId is marked non-null but is null");
        }
        this.addEvent(loginId, false, anonymousId, "track_signup", "$SignUp", properties);
    }

    @Override
    public void profileSet(@NonNull String distinctId, @NonNull boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        this.dealProfile(distinctId, isLoginId, properties, "profile_set");
    }

    @Override
    public void profileSet(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String property, @NonNull Object value) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.dealProfile(distinctId, isLoginId, properties, "profile_set");
    }

    @Override
    public void profileSetOnce(@NonNull String distinctId, @NonNull boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        this.dealProfile(distinctId, isLoginId, properties, "profile_set_once");
    }

    @Override
    public void profileSetOnce(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String property, @NonNull Object value) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.dealProfile(distinctId, isLoginId, properties, "profile_set_once");
    }

    @Override
    public void profileIncrement(@NonNull String distinctId, @NonNull boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        this.dealProfile(distinctId, isLoginId, properties, "profile_increment");
    }

    @Override
    public void profileIncrement(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String property, @NonNull long value) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.dealProfile(distinctId, isLoginId, properties, "profile_increment");
    }

    @Override
    public void profileAppend(@NonNull String distinctId, @NonNull boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        this.dealProfile(distinctId, isLoginId, properties, "profile_append");
    }

    @Override
    public void profileAppend(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String property, @NonNull String value) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, values);
        this.dealProfile(distinctId, isLoginId, properties, "profile_append");
    }

    @Override
    public void profileUnset(@NonNull String distinctId, @NonNull boolean isLoginId, @NonNull String property) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, true);
        this.dealProfile(distinctId, isLoginId, properties, "profile_unset");
    }

    @Override
    public void profileUnset(@NonNull String distinctId, @NonNull boolean isLoginId, Map<String, Object> properties) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            boolean value;
            if ("$project".equals(property.getKey()) || property.getValue() instanceof Boolean && (value = ((Boolean)property.getValue()).booleanValue())) continue;
            throw new InvalidArgumentException("The property value of " + property.getKey() + " should be true.");
        }
        this.dealProfile(distinctId, isLoginId, properties, "profile_unset");
    }

    @Override
    public void profileDelete(@NonNull String distinctId, @NonNull boolean isLoginId) throws InvalidArgumentException {
        if (distinctId == null) {
            throw new NullPointerException("distinctId is marked non-null but is null");
        }
        this.dealProfile(distinctId, isLoginId, null, "profile_delete");
    }

    @Override
    public void itemSet(@NonNull String itemType, @NonNull String itemId, Map<String, Object> properties) throws InvalidArgumentException {
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        if (itemId == null) {
            throw new NullPointerException("itemId is marked non-null but is null");
        }
        this.addItem(itemType, itemId, "item_set", properties);
    }

    @Override
    public void itemDelete(@NonNull String itemType, @NonNull String itemId, Map<String, Object> properties) throws InvalidArgumentException {
        if (itemType == null) {
            throw new NullPointerException("itemType is marked non-null but is null");
        }
        if (itemId == null) {
            throw new NullPointerException("itemId is marked non-null but is null");
        }
        this.addItem(itemType, itemId, "item_delete", properties);
    }

    @Override
    public void bind(SensorsAnalyticsIdentity ... identities) throws InvalidArgumentException {
        if (identities == null) {
            throw new NullPointerException("identities is marked non-null but is null");
        }
        this.bind((Map<String, Object>)null, identities);
    }

    @Override
    public void unbind(@NonNull SensorsAnalyticsIdentity analyticsIdentity) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (analyticsIdentity.getIdentityMap().size() != 1) {
            throw new InvalidArgumentException("unbind user operation cannot input multiple or none identifiers.");
        }
        this.addEventIdentity(analyticsIdentity.getIdentityMap(), null, "track_id_unbind", "$UnbindID");
    }

    @Override
    public void unbind(@NonNull String key, @NonNull String value) throws InvalidArgumentException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        SensorsAnalyticsIdentity identity = SensorsAnalyticsIdentity.builder().addIdentityProperty(key, value).build();
        this.addEventIdentity(identity.getIdentityMap(), null, "track_id_unbind", "$UnbindID");
    }

    @Override
    public void bind(Map<String, Object> properties, SensorsAnalyticsIdentity ... analyticsIdentity) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        HashMap<String, String> identityMap = new HashMap<String, String>();
        for (SensorsAnalyticsIdentity identity : analyticsIdentity) {
            identityMap.putAll(identity.getIdentityMap());
        }
        if (identityMap.size() < 2) {
            throw new InvalidArgumentException("The identities is invalid\uff0cyou should have at least two identities.");
        }
        this.addEventIdentity(identityMap, properties, "track_id_bind", "$BindID");
    }

    @Override
    public void unbind(@NonNull String key, @NonNull String value, Map<String, Object> properties) throws InvalidArgumentException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        SensorsAnalyticsIdentity identity = SensorsAnalyticsIdentity.builder().addIdentityProperty(key, value).build();
        this.addEventIdentity(identity.getIdentityMap(), properties, "track_id_unbind", "$UnbindID");
    }

    @Override
    public void trackById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, @NonNull String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (eventName == null) {
            throw new NullPointerException("eventName is marked non-null but is null");
        }
        if (properties == null) {
            properties = new HashMap<String, Object>();
        }
        properties.putAll(this.superProperties);
        IDMEventRecord eventRecord = IDMEventRecord.starter().identityMap(analyticsIdentity.getIdentityMap()).setEventName(eventName).addProperties(properties).build();
        this.worker.doAddData(new SensorsData(eventRecord));
    }

    @Override
    public void profileSetById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        this.addProfileIdentity(analyticsIdentity, "profile_set", properties);
    }

    @Override
    public void profileSetById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, @NonNull String property, @NonNull Object value) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addProfileIdentity(analyticsIdentity, "profile_set", properties);
    }

    @Override
    public void profileSetOnceById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        this.addProfileIdentity(analyticsIdentity, "profile_set_once", properties);
    }

    @Override
    public void profileSetOnceById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, @NonNull String property, @NonNull Object value) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addProfileIdentity(analyticsIdentity, "profile_set_once", properties);
    }

    @Override
    public void profileIncrementById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        this.addProfileIdentity(analyticsIdentity, "profile_increment", properties);
    }

    @Override
    public void profileIncrementById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, String property, long value) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, value);
        this.addProfileIdentity(analyticsIdentity, "profile_increment", properties);
    }

    @Override
    public void profileAppendById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        this.addProfileIdentity(analyticsIdentity, "profile_append", properties);
    }

    @Override
    public void profileAppendById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, @NonNull String property, @NonNull String value) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, values);
        this.addProfileIdentity(analyticsIdentity, "profile_append", properties);
    }

    @Override
    public void profileUnsetById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            boolean value;
            if ("$project".equals(property.getKey()) || property.getValue() instanceof Boolean && (value = ((Boolean)property.getValue()).booleanValue())) continue;
            throw new InvalidArgumentException("The property value of [" + property.getKey() + "] should be true.");
        }
        this.addProfileIdentity(analyticsIdentity, "profile_unset", properties);
    }

    @Override
    public void profileUnsetById(@NonNull SensorsAnalyticsIdentity analyticsIdentity, @NonNull String property) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(property, true);
        this.addProfileIdentity(analyticsIdentity, "profile_unset", properties);
    }

    @Override
    public void profileDeleteById(@NonNull SensorsAnalyticsIdentity analyticsIdentity) throws InvalidArgumentException {
        if (analyticsIdentity == null) {
            throw new NullPointerException("analyticsIdentity is marked non-null but is null");
        }
        if (analyticsIdentity.getIdentityMap().size() != 1) {
            throw new InvalidArgumentException("delete user operation cannot input multiple or none identifiers.");
        }
        this.addProfileIdentity(analyticsIdentity, "profile_delete", null);
    }

    @Override
    public void profileDeleteById(@NonNull String key, @NonNull String value) throws InvalidArgumentException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        SensorsAnalyticsIdentity analyticsIdentity = SensorsAnalyticsIdentity.builder().addIdentityProperty(key, value).build();
        this.addProfileIdentity(analyticsIdentity, "profile_delete", null);
    }

    @Override
    public void trackById(@NonNull IDMEventRecord idmEventRecord) throws InvalidArgumentException {
        if (idmEventRecord == null) {
            throw new NullPointerException("idmEventRecord is marked non-null but is null");
        }
        idmEventRecord.getPropertyMap().putAll(this.putAllSuperPro(idmEventRecord.getPropertyMap(), this.superProperties));
        this.worker.doAddData(new SensorsData(idmEventRecord));
    }

    @Override
    public void profileSetById(@NonNull IDMUserRecord idmUserRecord) throws InvalidArgumentException {
        if (idmUserRecord == null) {
            throw new NullPointerException("idmUserRecord is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertProperties("profile_set", idmUserRecord.getPropertyMap());
        this.worker.doAddData(new SensorsData(idmUserRecord, "profile_set"));
    }

    @Override
    public void profileSetOnceById(@NonNull IDMUserRecord idmUserRecord) throws InvalidArgumentException {
        if (idmUserRecord == null) {
            throw new NullPointerException("idmUserRecord is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertProperties("profile_set_once", idmUserRecord.getPropertyMap());
        this.worker.doAddData(new SensorsData(idmUserRecord, "profile_set_once"));
    }

    @Override
    public void profileIncrementById(@NonNull IDMUserRecord idmUserRecord) throws InvalidArgumentException {
        if (idmUserRecord == null) {
            throw new NullPointerException("idmUserRecord is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertProperties("profile_increment", idmUserRecord.getPropertyMap());
        this.worker.doAddData(new SensorsData(idmUserRecord, "profile_increment"));
    }

    @Override
    public void profileAppendById(@NonNull IDMUserRecord idmUserRecord) throws InvalidArgumentException {
        if (idmUserRecord == null) {
            throw new NullPointerException("idmUserRecord is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertProperties("profile_append", idmUserRecord.getPropertyMap());
        this.worker.doAddData(new SensorsData(idmUserRecord, "profile_append"));
    }

    @Override
    public void profileUnsetById(@NonNull IDMUserRecord idmUserRecord) throws InvalidArgumentException {
        if (idmUserRecord == null) {
            throw new NullPointerException("idmUserRecord is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertProperties("profile_unset", idmUserRecord.getPropertyMap());
        if (idmUserRecord.getPropertyMap() == null) {
            return;
        }
        for (Map.Entry<String, Object> property : idmUserRecord.getPropertyMap().entrySet()) {
            boolean value;
            if ("$project".equals(property.getKey()) || property.getValue() instanceof Boolean && (value = ((Boolean)property.getValue()).booleanValue())) continue;
            throw new InvalidArgumentException("The property value of " + property.getKey() + " should be true.");
        }
        this.worker.doAddData(new SensorsData(idmUserRecord, "profile_unset"));
    }

    @Override
    public void track(@NonNull UserEventSchema userEventSchema) throws InvalidArgumentException {
        if (userEventSchema == null) {
            throw new NullPointerException("userEventSchema is marked non-null but is null");
        }
        userEventSchema.getPropertyMap().putAll(this.putAllSuperPro(userEventSchema.getPropertyMap(), this.superProperties));
        this.worker.doSchemaData(new SensorsSchemaData(userEventSchema, "track"));
    }

    @Override
    public void track(@NonNull ItemEventSchema itemEventSchema) throws InvalidArgumentException {
        if (itemEventSchema == null) {
            throw new NullPointerException("itemEventSchema is marked non-null but is null");
        }
        itemEventSchema.getProperties().putAll(this.putAllSuperPro(itemEventSchema.getProperties(), this.superProperties));
        this.worker.doSchemaData(new SensorsSchemaData(itemEventSchema, "track"));
    }

    @Override
    public void bind(@NonNull IdentitySchema identitySchema) throws InvalidArgumentException {
        if (identitySchema == null) {
            throw new NullPointerException("identitySchema is marked non-null but is null");
        }
        if (identitySchema.getIdMap().size() < 2) {
            throw new InvalidArgumentException("The identities is invalid\uff0cyou should have at least two identities.");
        }
        UserEventSchema userEventSchema = UserEventSchema.init().setEventName("$BindID").identityMap(identitySchema.getIdMap()).addProperties(this.putAllSuperPro(identitySchema.getProperties(), this.superProperties)).start();
        this.worker.doSchemaData(new SensorsSchemaData(userEventSchema, "track_id_bind"));
    }

    @Override
    public void unbind(@NonNull IdentitySchema identitySchema) throws InvalidArgumentException {
        if (identitySchema == null) {
            throw new NullPointerException("identitySchema is marked non-null but is null");
        }
        if (identitySchema.getIdMap().size() != 1) {
            throw new InvalidArgumentException("unbind user operation cannot input multiple or none identifiers.");
        }
        UserEventSchema userEventSchema = UserEventSchema.init().setEventName("$UnbindID").identityMap(identitySchema.getIdMap()).addProperties(this.putAllSuperPro(identitySchema.getProperties(), this.superProperties)).start();
        this.worker.doSchemaData(new SensorsSchemaData(userEventSchema, "track_id_unbind"));
    }

    @Override
    public void profileSet(@NonNull UserSchema userSchema) throws InvalidArgumentException {
        if (userSchema == null) {
            throw new NullPointerException("userSchema is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertSchemaProperties(userSchema.getPropertyMap(), "profile_set");
        this.worker.doSchemaData(new SensorsSchemaData(userSchema, "profile_set"));
    }

    @Override
    public void profileSetOnce(@NonNull UserSchema userSchema) throws InvalidArgumentException {
        if (userSchema == null) {
            throw new NullPointerException("userSchema is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertSchemaProperties(userSchema.getPropertyMap(), "profile_set_once");
        this.worker.doSchemaData(new SensorsSchemaData(userSchema, "profile_set_once"));
    }

    @Override
    public void profileIncrement(@NonNull UserSchema userSchema) throws InvalidArgumentException {
        if (userSchema == null) {
            throw new NullPointerException("userSchema is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertSchemaProperties(userSchema.getPropertyMap(), "profile_increment");
        this.worker.doSchemaData(new SensorsSchemaData(userSchema, "profile_increment"));
    }

    @Override
    public void profileAppend(@NonNull UserSchema userSchema) throws InvalidArgumentException {
        if (userSchema == null) {
            throw new NullPointerException("userSchema is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertSchemaProperties(userSchema.getPropertyMap(), "profile_append");
        this.worker.doSchemaData(new SensorsSchemaData(userSchema, "profile_append"));
    }

    @Override
    public void profileUnset(@NonNull UserSchema userSchema) throws InvalidArgumentException {
        if (userSchema == null) {
            throw new NullPointerException("userSchema is marked non-null but is null");
        }
        SensorsAnalyticsUtil.assertSchemaProperties(userSchema.getPropertyMap(), "profile_unset");
        this.worker.doSchemaData(new SensorsSchemaData(userSchema, "profile_unset"));
    }

    @Override
    public void profileDelete(@NonNull String key, @NonNull String value) throws InvalidArgumentException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        UserSchema userSchema = UserSchema.init().addIdentityProperty(key, value).start();
        this.worker.doSchemaData(new SensorsSchemaData(userSchema, "profile_delete"));
    }

    @Override
    public void profileDelete(@NonNull Long userId) throws InvalidArgumentException {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        UserSchema userSchema = UserSchema.init().setUserId(userId).start();
        this.worker.doSchemaData(new SensorsSchemaData(userSchema, "profile_delete"));
    }

    @Override
    public void itemSet(@NonNull ItemSchema itemSchema) throws InvalidArgumentException {
        if (itemSchema == null) {
            throw new NullPointerException("itemSchema is marked non-null but is null");
        }
        this.worker.doSchemaData(new SensorsSchemaData(itemSchema, "item_set"));
    }

    @Override
    public void itemDelete(@NonNull ItemSchema itemSchema) throws InvalidArgumentException {
        if (itemSchema == null) {
            throw new NullPointerException("itemSchema is marked non-null but is null");
        }
        this.worker.doSchemaData(new SensorsSchemaData(itemSchema, "item_delete"));
    }

    @Override
    public void detailSet(@NonNull DetailSchema detailSchema) throws InvalidArgumentException {
        if (detailSchema == null) {
            throw new NullPointerException("detailSchema is marked non-null but is null");
        }
        this.worker.doSchemaData(new SensorsSchemaData(detailSchema, "detail_set"));
    }

    @Override
    public void detailDelete(@NonNull DetailSchema detailSchema) throws InvalidArgumentException {
        if (detailSchema == null) {
            throw new NullPointerException("detailSchema is marked non-null but is null");
        }
        this.worker.doSchemaData(new SensorsSchemaData(detailSchema, "detail_delete"));
    }

    @Override
    public void flush() {
        this.worker.flush();
    }

    @Override
    public void shutdown() {
        this.worker.shutdown();
    }

    private void dealProfile(String distinctId, Boolean isLoginId, Map<String, Object> properties, String actionType) throws InvalidArgumentException {
        SensorsAnalyticsUtil.assertProperties(actionType, properties);
        UserRecord userRecord = UserRecord.builder().setDistinctId(distinctId).isLoginId(isLoginId).addProperties(properties).build();
        this.worker.doAddData(new SensorsData(userRecord, actionType));
    }

    private void dealProfile(UserRecord userRecord, String actionType) throws InvalidArgumentException {
        SensorsAnalyticsUtil.assertProperties(actionType, userRecord.getPropertyMap());
        this.worker.doAddData(new SensorsData(userRecord, actionType));
    }

    private void addItem(String itemType, String itemId, String actionType, Map<String, Object> properties) throws InvalidArgumentException {
        SensorsAnalyticsUtil.assertProperties(actionType, properties);
        ItemRecord itemRecord = ItemRecord.builder().setItemId(itemId).setItemType(itemType).addProperties(properties).build();
        this.worker.doAddData(new SensorsData(itemRecord, actionType));
    }

    private void addEvent(String distinctId, boolean isLoginId, String originDistinctId, String actionType, String eventName, Map<String, Object> properties) throws InvalidArgumentException {
        SensorsAnalyticsUtil.assertProperties(actionType, properties);
        if (actionType.equals("track_signup")) {
            SensorsAnalyticsUtil.assertValue(ORIGINAL_DISTINCT_ID, originDistinctId);
        }
        EventRecord eventRecord = EventRecord.builder().setEventName(eventName).setDistinctId(distinctId).isLoginId(isLoginId).addProperties(this.putAllSuperPro(properties, this.superProperties)).build();
        SensorsData sensorsData = new SensorsData(eventRecord, actionType);
        sensorsData.setOriginalId(originDistinctId);
        this.worker.doAddData(sensorsData);
    }

    private void addProfileIdentity(SensorsAnalyticsIdentity analyticsIdentity, String actionType, Map<String, Object> properties) throws InvalidArgumentException {
        if (analyticsIdentity.getIdentityMap().isEmpty()) {
            throw new InvalidArgumentException("The identity is empty.");
        }
        this.assertIdentityMap(actionType, analyticsIdentity.getIdentityMap());
        SensorsAnalyticsUtil.assertProperties(actionType, properties);
        IDMUserRecord idmUserRecord = IDMUserRecord.starter().identityMap(analyticsIdentity.getIdentityMap()).addProperties(properties).build();
        this.worker.doAddData(new SensorsData(idmUserRecord, actionType));
    }

    private void addEventIdentity(Map<String, String> identityMap, Map<String, Object> properties, String actionType, String eventName) throws InvalidArgumentException {
        if (identityMap.isEmpty()) {
            throw new InvalidArgumentException("The identity is empty.");
        }
        this.assertIdentityMap(actionType, identityMap);
        SensorsAnalyticsUtil.assertProperties(actionType, properties);
        IDMEventRecord idmEventRecord = IDMEventRecord.starter().setEventName(eventName).identityMap(identityMap).addProperties(this.putAllSuperPro(properties, this.superProperties)).build();
        this.worker.doAddData(new SensorsData(idmEventRecord, actionType));
    }

    private void assertIdentityMap(String actionType, Map<String, String> identityMap) throws InvalidArgumentException {
        for (Map.Entry<String, String> entry : identityMap.entrySet()) {
            SensorsAnalyticsUtil.assertKey(actionType, entry.getKey());
            SensorsAnalyticsUtil.assertValue(actionType, entry.getValue());
        }
    }

    private Map<String, Object> putAllSuperPro(Map<String, Object> pro, Map<String, Object> superPro) {
        if (pro == null) {
            pro = new HashMap<String, Object>();
        }
        for (Map.Entry<String, Object> entry : superPro.entrySet()) {
            if (pro.containsKey(entry.getKey())) continue;
            pro.put(entry.getKey(), entry.getValue());
        }
        return pro;
    }
}

