/*
 * Decompiled with CFR 0.152.
 */
package com.sensorsdata.analytics.javasdk;

import com.sensorsdata.analytics.javasdk.SensorsAnalytics;
import com.sensorsdata.analytics.javasdk.bean.EventRecord;
import com.sensorsdata.analytics.javasdk.bean.ItemRecord;
import com.sensorsdata.analytics.javasdk.bean.SensorsAnalyticsIdentity;
import com.sensorsdata.analytics.javasdk.bean.SuperPropertiesRecord;
import com.sensorsdata.analytics.javasdk.bean.UserRecord;
import com.sensorsdata.analytics.javasdk.consumer.ConcurrentLoggingConsumer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class HelloSensorsAnalytics {
    public static void main(String[] args) throws Exception {
        SensorsAnalytics sa = new SensorsAnalytics(new ConcurrentLoggingConsumer("file.log"));
        SuperPropertiesRecord propertiesRecord = SuperPropertiesRecord.builder().addProperty("$os", "Windows").addProperty("$os_version", "8.1").addProperty("$ip", "123.123.123.123").build();
        sa.registerSuperProperties(propertiesRecord);
        String cookieId = "ABCDEF123456789";
        EventRecord firstRecord = EventRecord.builder().setDistinctId(cookieId).isLoginId(Boolean.FALSE).setEventName("track").addProperty("$time", Calendar.getInstance().getTime()).addProperty("Channel", "baidu").addProperty("$project", "abc").addProperty("$token", "123").build();
        sa.track(firstRecord);
        EventRecord searchRecord = EventRecord.builder().setDistinctId(cookieId).isLoginId(Boolean.FALSE).setEventName("SearchProduct").addProperty("KeyWord", "XX\u624b\u673a").build();
        sa.track(searchRecord);
        EventRecord lookRecord = EventRecord.builder().setDistinctId(cookieId).isLoginId(Boolean.FALSE).setEventName("ViewProduct").addProperty("ProductName", "XX\u624b\u673a").addProperty("ProductType", "\u667a\u80fd\u624b\u673a").addProperty("ShopName", "XX\u5b98\u65b9\u65d7\u8230\u5e97").build();
        sa.track(lookRecord);
        String registerId = "123456";
        sa.trackSignUp(registerId, cookieId);
        ArrayList<String> interests = new ArrayList<String>();
        interests.add("movie");
        interests.add("swim");
        UserRecord userRecord = UserRecord.builder().setDistinctId(registerId).isLoginId(Boolean.TRUE).addProperty("$city", "\u6b66\u6c49").addProperty("$province", "\u6e56\u5317").addProperty("$name", "\u6635\u79f0123").addProperty("$signup_time", Calendar.getInstance().getTime()).addProperty("Gender", "male").addProperty("age", 20).addProperty("interest", interests).build();
        sa.profileSet(userRecord);
        UserRecord firstVisitRecord = UserRecord.builder().setDistinctId(registerId).isLoginId(Boolean.TRUE).addProperty("$first_visit_time", Calendar.getInstance().getTime()).build();
        sa.profileSetOnce(firstVisitRecord);
        ArrayList<String> newInterest = new ArrayList<String>();
        newInterest.add("ball");
        UserRecord appendRecord = UserRecord.builder().setDistinctId(registerId).isLoginId(Boolean.TRUE).addProperty("interest", newInterest).build();
        sa.profileAppend(appendRecord);
        UserRecord incrementRecord = UserRecord.builder().setDistinctId(registerId).isLoginId(Boolean.TRUE).addProperty("age", 2).build();
        sa.profileIncrement(incrementRecord);
        UserRecord unsetRecord = UserRecord.builder().setDistinctId(registerId).isLoginId(Boolean.TRUE).addProperty("age", true).build();
        sa.profileUnset(unsetRecord);
        EventRecord orderRecord = EventRecord.builder().setDistinctId(registerId).isLoginId(Boolean.TRUE).setEventName("SubmitOrder").addProperty("OrderId", "SN_123_AB_TEST").build();
        sa.track(orderRecord);
        EventRecord payRecord = EventRecord.builder().setDistinctId(registerId).isLoginId(Boolean.TRUE).setEventName("PayOrder").addProperty("PaymentMethod", "AliPay").addProperty("AllowanceAmount", 30.0).addProperty("PaymentAmount", 1204.0).build();
        sa.track(payRecord);
        String itemId = "product001";
        String itemType = "mobile";
        ItemRecord addRecord = ItemRecord.builder().setItemId(itemId).setItemType(itemType).addProperty("color", "white").build();
        sa.itemSet(addRecord);
        ItemRecord deleteRecord = ItemRecord.builder().setItemId(itemId).setItemType(itemType).build();
        sa.itemDelete(deleteRecord);
        SensorsAnalyticsIdentity identity = SensorsAnalyticsIdentity.builder().addIdentityProperty("email", "fz@163.com").build();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("Channel", "baidu");
        sa.trackById(identity, "test", properties);
        SensorsAnalyticsIdentity identity1 = SensorsAnalyticsIdentity.builder().addIdentityProperty("login_id", "fz123").build();
        sa.bind(identity, identity1);
        sa.profileSetById(identity, "age", 15);
        ArrayList<String> sports = new ArrayList<String>();
        sports.add("swim");
        sports.add("run");
        HashMap<String, Object> hh = new HashMap<String, Object>();
        hh.put("sport", sports);
        sa.profileSetById(identity, hh);
        sa.profileIncrementById(identity, "age", 1L);
        sa.profileAppendById(identity, "sport", "ball");
        sa.profileUnsetById(identity, "sport");
    }
}

