/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.trace;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.APIMetrics;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.ParseID;
import com.sap.db.jdbc.ParseInfo;
import com.sap.db.jdbc.PreparedStatementSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.TraceListener;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.PacketAnalyzer;
import com.sap.db.jdbc.packet.PartKind;
import com.sap.db.jdbc.trace.TraceConfiguration;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Dbg;
import com.sap.db.util.FileUtils;
import com.sap.db.util.HexUtils;
import com.sap.db.util.PlatformUtils;
import com.sap.db.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;

@ThreadSafe
public class Tracer {
    private static final Tracer SETTINGS_FILE_TRACER = new Tracer(Type.SETTINGS_FILE, null, null, null, null, null);
    private static final Tracer ENVIRONMENT_VARIABLE_TRACER;
    private static final Map<String, Tracer> PER_APPLICATION_USER_TRACERS;
    private static final String CURRENT_WRITE_POSITION = "<CURRENT WRITE POSITION>";
    private static final ThreadLocal<DecimalFormat> DECIMAL_FORMAT;
    private static final ThreadLocal<DateFormat> DATE_FORMAT;
    @GuardedBy(value="Tracer.class")
    private static ConsoleTraceListener _stdoutTraceListener;
    @GuardedBy(value="Tracer.class")
    private static ConsoleTraceListener _stderrTraceListener;
    private final Type _type;
    private final String _connectionHashCode;
    private final String _applicationUser;
    private final String _traceListenerClassName;
    private final TraceControl _traceControl;
    private final AtomicBoolean _isTraceOn;
    private final AtomicBoolean _isTraceSuspended;
    private final AtomicBoolean _isPerformanceTraceOn;
    @GuardedBy(value="this")
    private final PacketAnalyzer _packetAnalyzer;
    @GuardedBy(value="this")
    private final TraceConfiguration _traceConfiguration;
    @GuardedBy(value="this")
    private WeakReference<ConnectionSapDB> _connection;
    @GuardedBy(value="this")
    private String _traceFileName;
    @GuardedBy(value="this")
    private long _traceSize;
    @GuardedBy(value="this")
    private boolean _isWritingHeader;
    @GuardedBy(value="this")
    private TraceListener _traceListener;
    @GuardedBy(value="this")
    private Thread _lastThread;
    @GuardedBy(value="this")
    private int _anchorConnectionID;

    public static Tracer getDummyTracer() {
        return DummyTracer.INSTANCE;
    }

    public static Tracer getSettingsFileTracer() {
        return SETTINGS_FILE_TRACER;
    }

    public static Tracer getEnvironmentVariableTracer() {
        return ENVIRONMENT_VARIABLE_TRACER;
    }

    public static Tracer newLegacyTracer() {
        return new Tracer(Type.LEGACY_CONNECTION_SPECIFIC, null, null, null, null, null);
    }

    public static Tracer newConnectionPropertiesTracer(String connectionHashCode, String applicationUser, String traceListener, String traceFile, String traceOptions) {
        return new Tracer(Type.CONNECTION_PROPERTIES, connectionHashCode, applicationUser, traceListener, traceFile, traceOptions);
    }

    public static Tracer newEnvironmentVariablePerConnectionTracer(String connectionHashCode, String applicationUser) {
        TraceConfiguration traceConfiguration = ENVIRONMENT_VARIABLE_TRACER.getTraceConfiguration();
        String traceFile = traceConfiguration.getTraceFileName();
        String traceOptions = traceConfiguration.getTraceOptions();
        return new Tracer(Type.ENVIRONMENT_VARIABLE_PER_CONNECTION, connectionHashCode, applicationUser, null, traceFile, traceOptions);
    }

    public static Tracer getEnvironmentVariablePerApplicationUserTracer(String applicationUser) {
        TraceConfiguration traceConfiguration = ENVIRONMENT_VARIABLE_TRACER.getTraceConfiguration();
        String traceFile = traceConfiguration.getTraceFileName();
        String traceOptions = traceConfiguration.getTraceOptions();
        Tracer tracer = PER_APPLICATION_USER_TRACERS.get(applicationUser);
        if (tracer == null) {
            tracer = new Tracer(Type.ENVIRONMENT_VARIABLE_PER_APPLICATION_USER, null, applicationUser, null, traceFile, traceOptions);
            PER_APPLICATION_USER_TRACERS.put(applicationUser, tracer);
        }
        return tracer;
    }

    public static Tracer newSettingsFilePerConnectionTracer(String connectionHashCode, String applicationUser) {
        TraceConfiguration traceConfiguration = SETTINGS_FILE_TRACER.getTraceConfiguration();
        String traceFile = traceConfiguration.getTraceFileName();
        String traceOptions = traceConfiguration.getTraceOptions();
        return new Tracer(Type.SETTINGS_FILE_PER_CONNECTION, connectionHashCode, applicationUser, null, traceFile, traceOptions);
    }

    public static Tracer getSettingsFilePerApplicationUserTracer(String applicationUser) {
        TraceConfiguration traceConfiguration = SETTINGS_FILE_TRACER.getTraceConfiguration();
        String traceFile = traceConfiguration.getTraceFileName();
        String traceOptions = traceConfiguration.getTraceOptions();
        Tracer tracer = PER_APPLICATION_USER_TRACERS.get(applicationUser);
        if (tracer == null) {
            tracer = new Tracer(Type.SETTINGS_FILE_PER_APPLICATION_USER, null, applicationUser, null, traceFile, traceOptions);
            PER_APPLICATION_USER_TRACERS.put(applicationUser, tracer);
        }
        return tracer;
    }

    public static boolean isSplitPerConnection(String traceFileName) {
        return traceFileName != null && traceFileName.contains("%c");
    }

    public static boolean isSplitPerApplicationUser(String traceFileName) {
        if (Tracer.isSplitPerConnection(traceFileName)) {
            return false;
        }
        return traceFileName != null && traceFileName.contains("%a");
    }

    private Tracer(Type type, String connectionHashCode, String applicationUser, String traceListenerClassName, String traceFileName, String traceOptions) {
        this._type = type;
        this._connectionHashCode = connectionHashCode;
        this._applicationUser = applicationUser;
        this._traceListenerClassName = traceListenerClassName;
        if (type == Type.DUMMY) {
            this._traceControl = null;
            this._isTraceOn = null;
            this._isTraceSuspended = null;
            this._isPerformanceTraceOn = null;
            this._packetAnalyzer = null;
            this._traceConfiguration = null;
        } else {
            this._traceControl = new TraceControl(this);
            this._isTraceOn = new AtomicBoolean(false);
            this._isTraceSuspended = new AtomicBoolean(false);
            this._isPerformanceTraceOn = new AtomicBoolean(false);
            this._packetAnalyzer = new PacketAnalyzer();
            TraceConfiguration traceConfiguration = null;
            boolean usesTraceFile = true;
            if (traceOptions != null) {
                if (traceListenerClassName != null) {
                    traceConfiguration = new TraceConfiguration(null, traceOptions);
                    usesTraceFile = false;
                } else if (traceFileName != null) {
                    traceConfiguration = new TraceConfiguration(traceFileName, traceOptions);
                }
            }
            if (traceConfiguration == null) {
                traceConfiguration = new TraceConfiguration();
            }
            this._traceConfiguration = traceConfiguration;
            if (usesTraceFile) {
                this.setTraceFileName(this._traceConfiguration.getTraceFileName());
                this._setTraceSize(this._traceConfiguration.getTraceSize());
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + HexUtils.toHexString(this.hashCode());
    }

    public Type getType() {
        return this._type;
    }

    public TraceControl getTraceControl() {
        return this._traceControl;
    }

    public boolean on() {
        return this._isTraceOn.get();
    }

    public boolean isTraceSuspended() {
        return this._isTraceSuspended.get();
    }

    public boolean pon() {
        return this._isPerformanceTraceOn.get();
    }

    public TraceConfiguration getTraceConfiguration() {
        return this._traceConfiguration;
    }

    public synchronized ConnectionSapDB getConnection() {
        return this._connection != null ? (ConnectionSapDB)this._connection.get() : null;
    }

    public synchronized void setConnection(ConnectionSapDB connection) {
        this._connection = connection != null ? new WeakReference<ConnectionSapDB>(connection) : null;
    }

    public synchronized boolean setTraceFileName(String traceFileName) {
        boolean wasNameChanged;
        boolean bl = wasNameChanged = !traceFileName.equals(this._traceFileName);
        if (!wasNameChanged) {
            return false;
        }
        this._traceFileName = traceFileName;
        return true;
    }

    public synchronized boolean setTraceSize(String traceSize) {
        try {
            return this._setTraceSize(Long.parseLong(traceSize));
        }
        catch (NumberFormatException e) {
            return this._setTraceSize(Long.MAX_VALUE);
        }
    }

    public synchronized TraceListener getTraceListener() {
        return this._traceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTraceOn() {
        if (this._isTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceOn.set(true);
            this._traceConfiguration.setTraceEnabled(true);
            this._open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchTraceOff() {
        if (!this._isTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceOn.set(false);
            this._traceConfiguration.setTraceEnabled(false);
            this._close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTrace() {
        if (!this._isTraceOn.get() || this._isTraceSuspended.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceSuspended.set(true);
            this._writelnWithTimestamp("Tracing suspended");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTrace() {
        if (!this._isTraceOn.get() || !this._isTraceSuspended.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isTraceSuspended.set(false);
            this._writelnWithTimestamp("Tracing resumed");
            try {
                this._isWritingHeader = true;
                this._writeObjectTrees();
            }
            finally {
                this._isWritingHeader = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPerformanceTraceOn() {
        if (this._isPerformanceTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isPerformanceTraceOn.set(true);
            this._traceConfiguration.setPerformanceTraceEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void switchPerformanceTraceOff() {
        if (!this._isPerformanceTraceOn.get()) {
            return;
        }
        Tracer tracer = this;
        synchronized (tracer) {
            this._isPerformanceTraceOn.set(false);
            this._traceConfiguration.setPerformanceTraceEnabled(false);
            TraceRecordPublisher.getInstance().close();
        }
    }

    public synchronized void checkTraceSettings() {
        if (!this._traceConfiguration.hasTraceSettingsChanged()) {
            return;
        }
        this._traceConfiguration.loadTraceSettings();
        boolean wasTraceFileNameChanged = this.setTraceFileName(this._traceConfiguration.getTraceFileName());
        boolean wasTraceSizeChanged = this._setTraceSize(this._traceConfiguration.getTraceSize());
        if (this._traceConfiguration.isTraceEnabled()) {
            if (wasTraceFileNameChanged || wasTraceSizeChanged) {
                this.switchTraceOff();
            } else if (this._isTraceOn.get()) {
                this._writeTraceConfiguration();
            }
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
        if (this._traceConfiguration.isPerformanceTraceEnabled()) {
            this.switchPerformanceTraceOn();
        } else {
            this.switchPerformanceTraceOff();
        }
    }

    public synchronized void refreshTraceSettings() {
        if (this._traceConfiguration.isTraceEnabled()) {
            this.switchTraceOn();
        } else {
            this.switchTraceOff();
        }
        if (this._traceConfiguration.isPerformanceTraceEnabled()) {
            this.switchPerformanceTraceOn();
        } else {
            this.switchPerformanceTraceOff();
        }
    }

    public synchronized void handleAnchorConnectionIDChanged(int newAnchorConnectionID) {
        if (Tracer.isSplitPerConnection(this.getTraceConfiguration().getTraceFileName()) && this._connectionHashCode != null && !this._connectionHashCode.isEmpty()) {
            if (newAnchorConnectionID == this._anchorConnectionID) {
                return;
            }
            this._anchorConnectionID = newAnchorConnectionID;
            if (this._traceConfiguration.isTraceEnabled()) {
                this.switchTraceOff();
                this.switchTraceOn();
            }
        }
    }

    public synchronized void printCurrentStackTrace(String message, Throwable t) {
        if (this._traceListener == null || this._isTraceSuspended.get()) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(message);
        this._writelnWithIndent(this._getStackTraceString(t));
    }

    public synchronized void printConnectionOpening(ConnectionSapDB connection, String ... indentedMessages) {
        this._printConnectionTrace(connection, false, connection.isReconnecting() ? "reconnecting" : "opening", null, indentedMessages);
    }

    public synchronized void printConnectionOpened(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, true, connection.isReconnecting() ? "reconnected" : "opened", null, new String[0]);
    }

    public synchronized void printConnectionMessage(ConnectionSapDB connection, String message, String ... indentedMessages) {
        this._printConnectionTrace(connection, false, "message", message, indentedMessages);
    }

    public synchronized void printConnectionClosing(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, true, "closing", null, new String[0]);
    }

    public synchronized void printConnectionClosed(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, false, "closed", null, new String[0]);
    }

    public synchronized void printConnectionReattaching(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, true, "reattaching", null, new String[0]);
    }

    public synchronized void printConnectionReattached(ConnectionSapDB connection) {
        this._printConnectionTrace(connection, true, "reattached", null, new String[0]);
    }

    public synchronized void printSessionOpening(Session session, int timeoutMilliseconds) {
        this._printSessionTrace(session, false, false, "opening", "timeout=" + timeoutMilliseconds + " ms", new String[0]);
    }

    public synchronized void printSessionOpened(Session session, int timeoutMilliseconds) {
        this._printSessionTrace(session, true, false, "opened", "timeout=" + timeoutMilliseconds + " ms", new String[0]);
    }

    public synchronized void printSessionMessage(Session session, String message, String ... indentedMessages) {
        this._printSessionTrace(session, false, false, "message", message, indentedMessages);
    }

    public synchronized void printSessionClosing(Session session) {
        this._printSessionTrace(session, true, false, "closing", null, new String[0]);
    }

    public synchronized void printSessionClosed(Session session) {
        this._printSessionTrace(session, false, false, "closed", null, new String[0]);
    }

    public synchronized void printSessionRequestingReattach(Session session) {
        this._printSessionTrace(session, true, false, "requesting reattach", null, new String[0]);
    }

    public synchronized void printSessionRequestedReattach(Session session) {
        this._printSessionTrace(session, false, false, "requested reattach", null, new String[0]);
    }

    public synchronized void printSessionAttaching(Session session, int timeoutMilliseconds) {
        this._printSessionTrace(session, false, false, "attaching", "timeout=" + timeoutMilliseconds + " ms", new String[0]);
    }

    public synchronized void printSessionAttached(Session session, int timeoutMilliseconds) {
        this._printSessionTrace(session, true, false, "attached", "timeout=" + timeoutMilliseconds + " ms", new String[0]);
    }

    public synchronized void printSessionDetaching(Session session) {
        this._printSessionTrace(session, true, true, "detaching", null, new String[0]);
    }

    public synchronized void printSessionDetached(Session session) {
        this._printSessionTrace(session, false, true, "detached", null, new String[0]);
    }

    public synchronized void printSessionRestoring(Session session) {
        this._printSessionTrace(session, true, true, "restoring", null, new String[0]);
    }

    public synchronized void printSessionRestored(Session session, int timeoutMilliseconds) {
        this._printSessionTrace(session, false, true, "restored", "timeout=" + timeoutMilliseconds + " ms", new String[0]);
    }

    private void _printConnectionTrace(ConnectionSapDB connection, boolean isFullTraceString, String messageType, String message, String ... indentedMessages) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CONNECTIONS)) {
            return;
        }
        String text = "Connection " + messageType + ": " + connection.getTraceString(isFullTraceString) + (message != null ? " " + message : "");
        this._checkThreadChange();
        this._writelnWithTimestamp(text);
        if (indentedMessages != null) {
            for (String s : indentedMessages) {
                this._writelnWithIndent(s);
            }
        }
    }

    private void _printSessionTrace(Session session, boolean isFullTraceString, boolean forDetach, String messageType, String message, String ... indentedMessages) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CONNECTIONS)) {
            return;
        }
        String text = "Session " + messageType + ": " + session.getTraceString(isFullTraceString, true, forDetach) + (message != null ? " " + message : "");
        this._checkThreadChange();
        this._writelnWithTimestamp(text);
        if (indentedMessages != null) {
            for (String s : indentedMessages) {
                this._writelnWithIndent(s);
            }
        }
    }

    public synchronized void printCall(Class<?> clas, String name, Object ... arguments) {
        this.printCall(clas.getCanonicalName(), name, arguments);
    }

    public synchronized void printCall(Object caller, String name, Object ... arguments) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(caller + "." + name + "(" + this._getArgumentsString(arguments) + ")");
    }

    public synchronized void printResult(Object result) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("=> " + this._getValueAsString(result), true);
    }

    public synchronized void printVoidResult() {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("=> void", true);
    }

    public synchronized void printException(Throwable e) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(this._getStackTraceString(e), true);
        this._checkStopOnError(e);
    }

    public synchronized void printStatementCached(ParseInfo parseInfo) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement cached: " + parseInfo.toString());
    }

    public synchronized void printStatementReused(ParseInfo parseInfo) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement reused: " + parseInfo.toString());
    }

    public synchronized void printStatementEvicted(ParseInfo parseInfo, String reason) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement evicted (" + reason + "): " + parseInfo.toString());
    }

    public synchronized void printStatementQueuedForLazyDrop(ParseID parseID) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement queued for lazy drop: " + parseID);
    }

    public synchronized void printStatementsDequeuedForLazyDrop(List<ParseID> parseIDs) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statements dequeued for lazy drop: " + Arrays.toString(parseIDs.toArray()));
    }

    public synchronized void printStatementQueuedForPendingClose(PreparedStatementSapDB statement) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement queued for pending close: " + statement);
    }

    public synchronized void printStatementDequeuedForPendingClose(PreparedStatementSapDB statement) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Statement dequeued for pending close: " + statement);
    }

    public synchronized void printResultSetQueuedForPendingClose(ResultSetSapDB resultSet) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Result set queued for pending close: " + resultSet);
    }

    public synchronized void printResultSetDequeuedForPendingClose(ResultSetSapDB resultSet) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Result set dequeued for pending close: " + resultSet);
    }

    public synchronized void printReadNextChunk(Object caller) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API) || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.PACKET)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(caller + ".read()");
    }

    public synchronized void printRawPacket(String description, byte[] packet, int off, int len) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.PACKET)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("<Packet " + description + ">");
        if (len > 0) {
            this._writePartDataAsHexDump(packet, off, len);
        }
        this._writeln("</Packet>");
    }

    public synchronized void printPacket(byte[] packet, EngineFeatures engineFeatures) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.PACKET)) {
            return;
        }
        this._checkThreadChange();
        this._packetAnalyzer.parse(packet);
        this._writelnWithTimestamp("<Packet " + this._packetAnalyzer.getDisplayPacketHeader() + ">");
        while (this._packetAnalyzer.nextSegment()) {
            this._writeln("  <Segment " + this._packetAnalyzer.getDisplaySegmentHeader() + ">");
            while (this._packetAnalyzer.nextPart()) {
                this._writeln("    <Part " + this._packetAnalyzer.getDisplayPartHeader() + ">");
                this._writeln("      <PartBuffer>");
                int partLength = this._packetAnalyzer.getPartLength();
                if (partLength > 0) {
                    PartKind partKind = PartKind.decode(ByteUtils.getByte(packet, this._packetAnalyzer.getPartOffset() + 0));
                    this._writePartDataAsHexDump(partKind, packet, this._packetAnalyzer.getPartOffset() + 16, partLength);
                    String displayPartData = this._packetAnalyzer.getDisplayPartData(engineFeatures);
                    if (displayPartData != null) {
                        this._writeln("        " + displayPartData);
                    }
                }
                this._writeln("      </PartBuffer>");
                this._writeln("    </Part>");
            }
            this._writeln("  </Segment>");
        }
        this._writeln("</Packet>");
        this._packetAnalyzer.clear();
    }

    public synchronized void printPacketElapsedSendTime(long elapsedTime) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.PACKET)) {
            return;
        }
        if (!this._traceConfiguration.isShowElapsedTimesEnabled()) {
            return;
        }
        this._checkThreadChange();
        this._writeln("Send time: " + this._getDisplayElapsedTime(elapsedTime));
    }

    public synchronized void printPacketElapsedReceiveTime(long elapsedTime, long pingPacketCount) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.PACKET)) {
            return;
        }
        if (!this._traceConfiguration.isShowElapsedTimesEnabled()) {
            return;
        }
        this._checkThreadChange();
        this._writeln("Receive time: " + this._getDisplayElapsedTime(elapsedTime) + (pingPacketCount > 0L ? " (includes " + pingPacketCount + " ping packets)" : ""));
    }

    public synchronized void printDistribution(ConnectionSapDB connection, String message) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.DISTRIBUTION)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Distribution: " + (connection != null ? connection.getTraceString(true) + " " : "") + message);
    }

    public synchronized void printDistributionState(ConnectionSapDB connection, String message) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.DISTRIBUTION)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Distribution: " + (connection != null ? connection.getTraceString(true) + " " : "") + message);
        for (Session session : connection.getSessionPool().getSessions().values()) {
            this._writelnWithIndent(session.getTraceString(true, false));
        }
    }

    public synchronized void printConnectionStatistics(ConnectionSapDB connection) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.STATISTICS)) {
            return;
        }
        if (!connection.isPreparedStatementCacheEnabled()) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Connection statistics: " + connection.getTraceString(true));
        this._writelnWithIndent("PreparedStatementCurrentCacheSize:         " + connection.getPreparedStatementCurrentCacheSize());
        this._writelnWithIndent("PreparedStatementCurrentTrackSize:         " + connection.getPreparedStatementCurrentTrackSize());
        this._writelnWithIndent("PreparedStatementCount:                    " + connection.getPreparedStatementCount());
        this._writelnWithIndent("PreparedStatementCacheHitCount:            " + connection.getPreparedStatementCacheHitCount());
        this._writelnWithIndent("PreparedStatementExecuteCount:             " + connection.getPreparedStatementExecuteCount());
        this._writelnWithIndent("PreparedStatementDropCount:                " + connection.getPreparedStatementDropCount());
        this._writelnWithIndent("PreparedStatementApproxUniqueSQLTextCount: " + connection.getPreparedStatementApproxUniqueSQLTextCount());
        this._writelnWithIndent("PreparedStatementCacheRejectedFullCount:   " + connection.getPreparedStatementCacheRejectedFullCount());
        this._writelnWithIndent("PreparedStatementCacheEvictedFullCount:    " + connection.getPreparedStatementCacheEvictedFullCount());
        this._writelnWithIndent("PreparedStatementCacheEvictedColdCount:    " + connection.getPreparedStatementCacheEvictedColdCount());
        this._writelnWithIndent("PreparedStatementTrackEvictedFullCount:    " + connection.getPreparedStatementTrackEvictedFullCount());
        this._writelnWithIndent("PreparedStatementTrackEvictedColdCount:    " + connection.getPreparedStatementTrackEvictedColdCount());
    }

    public synchronized void printSessionStatistics(Session session) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.STATISTICS)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("Session statistics: " + session.getTraceString(true, true));
        this._writelnWithIndent("Duration:            " + this._getDisplayDuration(System.currentTimeMillis() - session.getInstantiationTime()));
        this._writelnWithIndent("SentPacketCount:     " + session.getSentPacketCount() + " TotalTime: " + this._getDisplayNanoseconds(session.getTotalSendTime()));
        this._writelnWithIndent("ReceivedPacketCount: " + session.getReceivedPacketCount() + " TotalTime: " + this._getDisplayNanoseconds(session.getTotalReceiveTime()));
        this._writelnWithIndent("SentByteCount:       " + this._getDisplayByteCount(session.getSentByteCount()) + " Uncompressed: " + this._getDisplayByteCount(session.getUncompressedSentByteCount()) + " CompressionRatio: " + this._getDisplayCompressionRatio(session.getSentCompressionRatio()));
        this._writelnWithIndent("ReceivedByteCount:   " + this._getDisplayByteCount(session.getReceivedByteCount()) + " Uncompressed: " + this._getDisplayByteCount(session.getUncompressedReceivedByteCount()) + " CompressionRatio: " + this._getDisplayCompressionRatio(session.getReceivedCompressionRatio()));
    }

    public synchronized void printCleaning(String caller) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(caller + ".clean()");
    }

    public synchronized void printCleaned() {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("=> void", true);
    }

    public synchronized void printFinalizing(String caller) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(caller + ".finalize()");
    }

    public synchronized void printFinalized() {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("=> void", true);
    }

    public synchronized void printDebugMessage(String message) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.DEBUG)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(message);
    }

    public synchronized void printDebugThrowable(Throwable t, String message) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.DEBUG)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(message);
        this._writelnWithIndent(this._getStackTraceString(t));
        this._checkStopOnError(t);
    }

    public synchronized void printSSLMessage(String message) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.SSL)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp(message);
    }

    public synchronized void printSSLPacket(String description, byte[] packet, int off, int len) {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.SSL)) {
            return;
        }
        this._checkThreadChange();
        this._writelnWithTimestamp("<Packet " + description + ">");
        if (len > 0) {
            this._writePartDataAsHexDump(packet, off, len);
        }
        this._writeln("</Packet>");
    }

    public synchronized void handleTraceFailure(String message) {
        if (this._traceListener == null || this._isTraceSuspended.get()) {
            return;
        }
        switch (this._traceConfiguration.getTraceFailureAction()) {
            case IGNORE: {
                return;
            }
            case STDOUT: {
                System.out.println("[" + this + "] " + message);
                break;
            }
            case STDERR: {
                System.err.println("[" + this + "] " + message);
                break;
            }
            case EXCEPTION: {
                throw new RuntimeException("[" + this + "] " + message);
            }
            default: {
                throw new AssertionError((Object)("Unexpected trace failure action: " + (Object)((Object)this._traceConfiguration.getTraceFailureAction())));
            }
        }
    }

    public synchronized boolean aon() {
        if (this._traceListener == null || this._isTraceSuspended.get() || !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.API) && !this._traceConfiguration.hasTraceLevel(TraceConfiguration.TraceLevel.CLEANERS)) {
            return false;
        }
        return this._traceConfiguration.isShowElapsedTimesEnabled();
    }

    private static synchronized ConsoleTraceListener _getStdoutTraceListener() {
        if (_stdoutTraceListener != null) {
            return _stdoutTraceListener;
        }
        _stdoutTraceListener = new ConsoleTraceListener(false);
        return _stdoutTraceListener;
    }

    private static synchronized ConsoleTraceListener _getStderrTraceListener() {
        if (_stderrTraceListener != null) {
            return _stderrTraceListener;
        }
        _stderrTraceListener = new ConsoleTraceListener(true);
        return _stderrTraceListener;
    }

    private void _open() {
        if (this._traceListenerClassName != null) {
            try {
                Class<?> clas = Class.forName(this._traceListenerClassName);
                Object obj = clas.newInstance();
                if (obj instanceof TraceListener) {
                    this._traceListener = (TraceListener)obj;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                System.err.println(e.getMessage());
            }
        } else {
            this._traceListener = this._isStdout() ? Tracer._getStdoutTraceListener() : (this._isStderr() ? Tracer._getStderrTraceListener() : new FileTraceListener());
        }
        this._traceListener.traceStarted(this);
        this._writeHeader(0);
    }

    private boolean _isStdout() {
        if (PlatformUtils.isWindows()) {
            return this._traceFileName.equalsIgnoreCase("stdout") || this._traceFileName.equalsIgnoreCase("CON");
        }
        if (PlatformUtils.isLinux() || PlatformUtils.isAIX() || PlatformUtils.isMacOS()) {
            return this._traceFileName.equalsIgnoreCase("stdout") || this._traceFileName.equals("/dev/stdout") || this._traceFileName.equals("/proc/self/fd/0");
        }
        return false;
    }

    private boolean _isStderr() {
        if (PlatformUtils.isWindows()) {
            return this._traceFileName.equalsIgnoreCase("stderr");
        }
        if (PlatformUtils.isLinux() || PlatformUtils.isAIX() || PlatformUtils.isMacOS()) {
            return this._traceFileName.equalsIgnoreCase("stderr") || this._traceFileName.equals("/dev/stderr") || this._traceFileName.equals("/proc/self/fd/1");
        }
        return false;
    }

    private void _close() {
        if (this._traceListener == null) {
            return;
        }
        this._traceListener.traceStopped(this);
        this._traceListener = null;
    }

    private boolean _setTraceSize(long traceSize) {
        if (traceSize < 8192L) {
            traceSize = 8192L;
        }
        if (traceSize == this._traceSize) {
            return false;
        }
        this._traceSize = traceSize;
        return true;
    }

    private void _writeln() {
        this._writeln(null);
    }

    private void _writeln(String text) {
        if (this._traceListener == null) {
            return;
        }
        this._traceListener.traceReceived(this, text != null ? text : "");
    }

    private void _writelnWithTimestamp(String text) {
        this._writelnWithTimestamp(text, false);
    }

    private void _writelnWithTimestamp(String text, boolean includeMetrics) {
        String metricsText;
        String displayText;
        String timestamp = this._traceConfiguration.isShowTimestampsEnabled() ? DATE_FORMAT.get().format(new Timestamp(System.currentTimeMillis())) + ": " : "";
        String string = displayText = text != null ? text : "";
        if (includeMetrics && this._traceConfiguration.isShowElapsedTimesEnabled()) {
            APIMetrics metrics = APIMetrics.getInstance();
            if (metrics.isValid()) {
                long apiTime = metrics.getElapsedAPITime();
                long networkTime = metrics.getElapsedNetworkTime();
                long totalTime = metrics.getElapsedTotalTime();
                long serverProcessingTime = metrics.getServerProcessingTime();
                long serverCPUTime = metrics.getServerCPUTime();
                long serverMemoryUsage = metrics.getServerMemoryUsage();
                metricsText = " (Client - API: " + this._getDisplayElapsedTime(apiTime) + ", Network: " + this._getDisplayElapsedTime(networkTime) + ", Total: " + this._getDisplayElapsedTime(totalTime) + "; Server - Processing time: " + this._getDisplayServerTime(serverProcessingTime) + ", CPU time: " + this._getDisplayServerTime(serverCPUTime) + ", Memory usage: " + this._getDisplayServerMemory(serverMemoryUsage) + ")";
            } else {
                metricsText = metrics.isNested() ? " (nested)" : "";
            }
        } else {
            metricsText = "";
        }
        this._writeln(timestamp + displayText + metricsText);
    }

    private void _writelnWithIndent(String text) {
        this._writeln("  " + (text != null ? text : ""));
    }

    private void _writeHeader(int wrapCount) {
        try {
            this._isWritingHeader = true;
            this._writeln("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body><PRE><PLAINTEXT>");
            this._writeln("Java version:   " + Driver.getJavaVersion());
            this._writeln("ClassLoader:    " + Tracer.class.getClassLoader());
            this._writeln("Process ID:     " + Driver.getProcessID());
            this._writeln("Driver version: " + Driver.getVersionInfo().toString());
            this._writeln("Timestamp:      " + DATE_FORMAT.get().format(new Timestamp(System.currentTimeMillis())));
            this._writeln();
            this._writeTraceConfiguration();
            this._writeln();
            this._writeHostProperties();
            this._writeln();
            this._writeSystemProperties();
            this._writeln();
            if (wrapCount > 0) {
                this._writeln("Warning: Trace wrapped around " + wrapCount + " times.");
                this._writeln();
            }
            this._writeObjectTrees();
        }
        finally {
            this._isWritingHeader = false;
        }
    }

    private void _writeObjectTrees() {
        Set<ConnectionSapDB> connections;
        if (this._type.isPerConnection()) {
            ConnectionSapDB conn = this.getConnection();
            connections = conn != null ? Collections.singleton(conn) : Collections.emptySet();
        } else if (this._type.isPerApplicationUser()) {
            connections = new HashSet<ConnectionSapDB>();
            for (ConnectionSapDB connection : Driver.getConnections()) {
                String applicationUser = connection.getConnectionProperty(ConnectionProperty.APPLICATIONUSER);
                if (applicationUser == null || applicationUser.isEmpty() || !applicationUser.equals(this._applicationUser)) continue;
                connections.add(connection);
            }
        } else {
            connections = Driver.getConnections();
        }
        if (!connections.isEmpty()) {
            this._writeln("Object tree begin:");
            for (ConnectionSapDB connection : connections) {
                this._writeln(connection.toString() + " Properties: " + Driver.getDisplayProperties(connection.getConnectionProperties()));
                for (StatementSapDB statement : connection.getStatements()) {
                    this._writelnWithIndent(statement.toString());
                    for (ResultSetSapDB resultSet : statement.getResultSets()) {
                        this._writelnWithIndent("  " + resultSet.toString());
                    }
                }
            }
            this._writeln("Object tree end:");
        }
    }

    private void _writeTraceConfiguration() {
        StringBuilder builder = new StringBuilder(64);
        this._writeln("Trace configuration:");
        for (TraceConfiguration.TraceLevel traceLevel : TraceConfiguration.TraceLevel.values()) {
            if (!this._traceConfiguration.hasTraceLevel(traceLevel)) continue;
            if (builder.length() > 0) {
                builder.append(',');
            }
            builder.append((Object)traceLevel);
        }
        this._writeln("  Levels:                                       " + builder);
        this._writeln("  Show plain-text client-side encrypted values: " + (this._traceConfiguration.isShowPlainTextCSEEnabled() ? "Enabled" : "Disabled"));
        this._writeln("  Show timestamps:                              " + (this._traceConfiguration.isShowTimestampsEnabled() ? "Enabled" : "Disabled"));
        this._writeln("  Show elapsed times:                           " + (this._traceConfiguration.isShowElapsedTimesEnabled() ? "Enabled" : "Disabled"));
        this._writeln("  Trace file size:                              " + this._traceConfiguration.getDisplayTraceSize() + " " + this._traceConfiguration.getDisplayTraceSizeUnits());
        int stopOnError = this._traceConfiguration.getStopOnError();
        this._writeln("  Stop on error:                                " + (stopOnError == 0 ? "Disabled" : String.valueOf(stopOnError)));
    }

    private void _writeHostProperties() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            this._writeln("Host properties:");
            this._writeProperty("Host name", localHost.getHostName());
            this._writeProperty("Canonical host name", localHost.getCanonicalHostName());
            this._writeProperty("Host address", localHost.getHostAddress());
        }
        catch (Throwable t) {
            this._writeln("Can't get host properties: " + t.getMessage());
        }
    }

    private void _writeSystemProperties() {
        try {
            TreeMap<Object, Object> systemProperties = new TreeMap<Object, Object>(System.getProperties());
            this._writeln("System properties:");
            for (Map.Entry entry : systemProperties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (key.equalsIgnoreCase("line.separator")) {
                    value = value.replace("\r", "\\r").replace("\n", "\\n");
                }
                this._writeProperty(key, value);
            }
        }
        catch (Throwable t) {
            this._writeln("Can't get system properties: " + t.getMessage());
        }
    }

    private void _writeProperty(String key, String value) {
        this._writeln(String.format("  %-33s %s", key + ':', value));
    }

    private void _writePartDataAsHexDump(PartKind partKind, byte[] bytes, int off, int len) {
        switch (partKind) {
            case Authentication: 
            case SessionCookie: {
                this._writeln("        *hidden*");
                break;
            }
            default: {
                this._writePartDataAsHexDump(bytes, off, len);
            }
        }
    }

    private void _writePartDataAsHexDump(byte[] bytes, int off, int len) {
        if (bytes == null || len == 0) {
            return;
        }
        char[] line = new char[79];
        int pos = 15;
        Arrays.fill(line, ' ');
        line[9] = 124;
        line[59] = 124;
        line[78] = 124;
        int i = off;
        int j = 0;
        int n = off + len;
        while (i < n) {
            pos = j % 16;
            byte b = bytes[i];
            line[3 * pos + 11] = HexUtils.HEXARRAY_LOWER[b >>> 4 & 0xF];
            line[3 * pos + 12] = HexUtils.HEXARRAY_LOWER[b & 0xF];
            line[pos + 61] = b >= 32 && b < 127 ? (int)b : 46;
            switch (pos) {
                case 0: {
                    boolean isLeadingZero = true;
                    int idx = 0;
                    int shift = 28;
                    while (idx < 8) {
                        int c = HexUtils.HEXARRAY_LOWER[j >>> shift & 0xF];
                        if (isLeadingZero && c != 48) {
                            isLeadingZero = false;
                        }
                        line[idx] = isLeadingZero && idx < 7 ? 32 : c;
                        ++idx;
                        shift -= 4;
                    }
                    break;
                }
                case 15: {
                    this._writeln(String.valueOf(line));
                }
            }
            ++i;
            ++j;
        }
        if (pos < 15) {
            Arrays.fill(line, 3 * (pos + 1) + 11, 58, ' ');
            Arrays.fill(line, pos + 62, 77, ' ');
            this._writeln(String.valueOf(line));
        }
    }

    private void _checkThreadChange() {
        Thread thread = Thread.currentThread();
        if (thread == this._lastThread) {
            return;
        }
        this._lastThread = thread;
        this._writelnWithTimestamp("---- Thread " + HexUtils.toHexString(thread.hashCode()) + " " + thread.getName());
    }

    private void _checkStopOnError(Throwable t) {
        int stopOnError = this._traceConfiguration.getStopOnError();
        if (stopOnError != 0 && t instanceof SQLException && ((SQLException)t).getErrorCode() == stopOnError) {
            this._close();
        }
    }

    private String _getStackTraceString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        t.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    private String _getArgumentsString(Object[] arguments) {
        switch (arguments.length) {
            case 0: {
                return "";
            }
            case 1: {
                return this._getValueAsString(arguments[0]);
            }
        }
        StringBuilder builder = new StringBuilder(64);
        for (Object arg : arguments) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(this._getValueAsString(arg));
        }
        return builder.toString();
    }

    private String _getValueAsString(Object object) {
        return object instanceof String ? StringUtils.quote(object.toString(), '\"', '\u0000', true, true) : String.valueOf(object);
    }

    private String _getDisplayDuration(long milliseconds) {
        long s = milliseconds / 1000L;
        return String.format("%d hours %d minutes %d seconds", s / 3600L, s % 3600L / 60L, s % 60L);
    }

    private String _getDisplayNanoseconds(long nanoseconds) {
        return nanoseconds / 1000000L + " ms";
    }

    private String _getDisplayByteCount(long byteCount) {
        return DECIMAL_FORMAT.get().format((double)byteCount / 1048576.0) + " MB";
    }

    private String _getDisplayCompressionRatio(double ratio) {
        return DECIMAL_FORMAT.get().format(ratio);
    }

    private String _getDisplayElapsedTime(long elapsedTime) {
        return elapsedTime / 1000L + " \u03bcs";
    }

    private String _getDisplayServerTime(long serverTime) {
        return serverTime + " \u03bcs";
    }

    private String _getDisplayServerMemory(long memoryUsage) {
        return memoryUsage + " bytes";
    }

    public static Tracer newSettingsFileTracer() {
        return new Tracer(Type.SETTINGS_FILE, null, null, null, null, null);
    }

    public synchronized File getTraceFile() {
        return ((FileTraceListener)this._traceListener)._getTraceFile(this);
    }

    public synchronized String getTraceTempFileName() {
        return ((FileTraceListener)this._traceListener)._file.getName();
    }

    static {
        String traceOptions = System.getenv("HDB_JDBC_TRACEOPTIONS");
        Tracer environmentVariableTracer = null;
        if (traceOptions != null && !traceOptions.isEmpty()) {
            String traceListener = System.getenv("HDB_JDBC_TRACELISTENER");
            if (traceListener != null && !traceListener.isEmpty()) {
                environmentVariableTracer = new Tracer(Type.ENVIRONMENT_VARIABLE, null, null, traceListener, null, traceOptions);
            } else {
                String traceFile = System.getenv("HDB_JDBC_TRACEFILE");
                if (traceFile != null && !traceFile.isEmpty()) {
                    environmentVariableTracer = new Tracer(Type.ENVIRONMENT_VARIABLE, null, null, null, traceFile, traceOptions);
                }
            }
        }
        ENVIRONMENT_VARIABLE_TRACER = environmentVariableTracer;
        PER_APPLICATION_USER_TRACERS = new HashMap<String, Tracer>();
        DECIMAL_FORMAT = ThreadLocal.withInitial(() -> new DecimalFormat("0.000"));
        DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
    }

    private static class ConsoleTraceListener
    implements TraceListener {
        private final boolean _isStderr;

        private ConsoleTraceListener(boolean isStderr) {
            this._isStderr = isStderr;
        }

        @Override
        public void traceStarted(Tracer tracer) {
            Runtime.getRuntime().addShutdownHook(new Thread(this::_flush));
        }

        @Override
        public void traceReceived(Tracer tracer, String text) {
            String[] lines;
            PrintStream stream = this._getStream();
            for (String line : lines = text.split("\r?\n")) {
                stream.println("[" + tracer.toString() + "] " + line);
            }
        }

        @Override
        public void traceStopped(Tracer tracer) {
            this._flush();
        }

        private PrintStream _getStream() {
            return this._isStderr ? System.err : System.out;
        }

        private void _flush() {
            this._getStream().flush();
        }
    }

    private static class FileTraceListener
    implements TraceListener {
        @GuardedBy(value="this")
        private File _file;
        @GuardedBy(value="this")
        private RandomAccessFile _log;
        @GuardedBy(value="this")
        private int _wrapCount;

        private FileTraceListener() {
        }

        @Override
        public synchronized void traceStarted(Tracer tracer) {
            this._file = this._getTraceFile(tracer);
            if (this._file == null) {
                return;
            }
            this.traceStopped(tracer);
            try {
                if (Dbg.runtimeEnabled) {
                    Dbg.print(tracer + ": Opening file: \"" + this._file + "\" ... ");
                }
                this._log = new RandomAccessFile(this._file, "rw");
                if (Dbg.runtimeEnabled) {
                    Dbg.println("done");
                }
            }
            catch (FileNotFoundException e) {
                String errmsg = "Can't open trace file \"" + this._file + "\": " + e.getMessage();
                tracer.handleTraceFailure(errmsg);
            }
            this._wrapCount = 0;
        }

        @Override
        public synchronized void traceReceived(Tracer tracer, String text) {
            if (this._log == null) {
                return;
            }
            try {
                if (Dbg.runtimeEnabled) {
                    Dbg.print(".");
                }
                if (text != null) {
                    this._log.write(text.getBytes(StandardCharsets.UTF_8));
                }
                this._log.write(10);
                this._checkFileSize(tracer);
            }
            catch (IOException e) {
                String errmsg = "Can't write to trace file \"" + this._file + "\": " + e.getMessage();
                tracer.handleTraceFailure(errmsg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void traceStopped(Tracer tracer) {
            if (this._log == null) {
                return;
            }
            try {
                if (Dbg.runtimeEnabled) {
                    Dbg.print(tracer + ": Closing file: \"" + this._file + "\" ... ");
                }
                this._log.close();
                if (Dbg.runtimeEnabled) {
                    Dbg.println("done");
                }
            }
            catch (IOException e) {
                String errmsg = "Can't close trace file \"" + this._file + "\": " + e.getMessage();
                tracer.handleTraceFailure(errmsg);
            }
            finally {
                this._log = null;
            }
        }

        private File _getTraceFile(Tracer tracer) {
            String traceFileName = tracer._traceFileName;
            if (traceFileName == null || traceFileName.isEmpty()) {
                traceFileName = "jdbctrace.prt";
            }
            String fileName = FileUtils.getFileName(traceFileName);
            String fileExtension = FileUtils.getFileExtension(traceFileName);
            String directoryName = FileUtils.getDirectoryName(traceFileName);
            File directory = FileUtils.createDirectoryIfNecessary(directoryName);
            File traceFile = null;
            if (fileName.contains("%c")) {
                fileName = tracer.getType().isPerConnection() && tracer._connectionHashCode != null && !tracer._connectionHashCode.isEmpty() ? fileName.replaceAll("%c", tracer._connectionHashCode + "_" + (tracer._anchorConnectionID > 0 ? Integer.valueOf(tracer._anchorConnectionID) : "000000")) : fileName.replaceAll("%c", "");
            }
            if (fileName.contains("%a")) {
                Type type = tracer.getType();
                fileName = (type.isPerConnection() || type.isPerApplicationUser()) && tracer._applicationUser != null && !tracer._applicationUser.isEmpty() ? fileName.replaceAll("%a", tracer._applicationUser) : fileName.replaceAll("%a", "");
            }
            if (directory == null) {
                String errmsg = "Can't create trace file directory \"" + directoryName + "\"";
                tracer.handleTraceFailure(errmsg);
                return null;
            }
            try {
                if (Dbg.runtimeEnabled) {
                    Dbg.println(tracer + ": Using args:   \"" + directoryName + "\" \"" + fileName + "\" \"" + fileExtension + "\"");
                }
                traceFile = File.createTempFile(fileName, fileExtension, directory);
                FileUtils.limitAccessToReadWriteByOwner(traceFile);
                if (Dbg.runtimeEnabled) {
                    Dbg.println(tracer + ": Using file:   \"" + traceFile + "\"");
                }
            }
            catch (IOException e) {
                String errmsg = "Can't create trace file \"" + directoryName + fileName + "*" + fileExtension + "\": " + e.getMessage();
                tracer.handleTraceFailure(errmsg);
            }
            return traceFile;
        }

        private void _checkFileSize(Tracer tracer) throws IOException {
            long traceSize = tracer._traceSize;
            if (this._log == null || tracer._isWritingHeader || traceSize == Long.MAX_VALUE) {
                return;
            }
            long offset = this._log.getFilePointer();
            if (offset + (long)Tracer.CURRENT_WRITE_POSITION.length() > traceSize) {
                while (offset < traceSize) {
                    this._log.write(32);
                    ++offset;
                }
                this._log.seek(0L);
                tracer._writeHeader(++this._wrapCount);
                offset = this._log.getFilePointer();
            }
            this._log.writeBytes(Tracer.CURRENT_WRITE_POSITION);
            this._log.seek(offset);
        }
    }

    private static class DummyTracer
    extends Tracer {
        private static final DummyTracer INSTANCE = new DummyTracer();

        private DummyTracer() {
            super(Type.DUMMY, null, null, null, null, null);
        }

        @Override
        public boolean on() {
            return false;
        }

        @Override
        public boolean isTraceSuspended() {
            return false;
        }

        @Override
        public boolean pon() {
            return false;
        }

        @Override
        public void setConnection(ConnectionSapDB connection) {
        }

        @Override
        public File getTraceFile() {
            return null;
        }

        @Override
        public boolean setTraceFileName(String traceFileName) {
            return false;
        }

        @Override
        public boolean setTraceSize(String traceSize) {
            return false;
        }

        @Override
        public void switchTraceOn() {
        }

        @Override
        public void switchTraceOff() {
        }

        @Override
        public void suspendTrace() {
        }

        @Override
        public void resumeTrace() {
        }

        @Override
        public void switchPerformanceTraceOn() {
        }

        @Override
        public void switchPerformanceTraceOff() {
        }

        @Override
        public void checkTraceSettings() {
        }

        @Override
        public void refreshTraceSettings() {
        }
    }

    public static enum Type {
        DUMMY(false, false),
        SETTINGS_FILE(false, false),
        ENVIRONMENT_VARIABLE(false, false),
        LEGACY_CONNECTION_SPECIFIC(true, false),
        CONNECTION_PROPERTIES(true, false),
        SETTINGS_FILE_PER_CONNECTION(true, false),
        SETTINGS_FILE_PER_APPLICATION_USER(false, true),
        ENVIRONMENT_VARIABLE_PER_CONNECTION(true, false),
        ENVIRONMENT_VARIABLE_PER_APPLICATION_USER(false, true);

        private final boolean _isPerConnection;
        private final boolean _isPerApplicationUser;

        private Type(boolean isPerConnection, boolean isPerApplicationUser) {
            this._isPerConnection = isPerConnection;
            this._isPerApplicationUser = isPerApplicationUser;
        }

        public boolean isPerConnection() {
            return this._isPerConnection;
        }

        public boolean isPerApplicationUser() {
            return this._isPerApplicationUser;
        }
    }
}

