/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.HRequestPacket;

@NotThreadSafe
public class HMultiLineOptionsPart
extends HOptionsPart {
    private int _currentLine;
    private int _optionsInLineCount;
    private int _currentOptionInLine;

    public HMultiLineOptionsPart(HRequestPacket requestPacket, int offset) {
        super(requestPacket, offset);
    }

    public HMultiLineOptionsPart(byte[] packet, int offset, int length) {
        super(packet, offset, length);
    }

    @Override
    public void rewind() {
        if (!this._isReadOnly) {
            return;
        }
        if (this._argumentCount == 0) {
            return;
        }
        this._currentOffset = this._includesPartHeader ? 16 : 0;
        this._currentLine = 1;
        this._optionsInLineCount = this.getShort(this._currentOffset);
        this._currentOptionInLine = 1;
        this._currentOffset += 2;
    }

    @Override
    public boolean nextOption() {
        if (this._currentOptionInLine > this._optionsInLineCount) {
            return false;
        }
        if (!this._moveCurrentOffset()) {
            return false;
        }
        ++this._currentOptionInLine;
        return this._currentOptionInLine <= this._optionsInLineCount;
    }

    @Override
    public void addBooleanOption(int option, boolean optionValue) {
        this._addBooleanOpt(option, optionValue);
        ++this._currentOptionInLine;
    }

    @Override
    public void addTinyIntOption(int option, int optionValue) {
        this._addTinyIntOpt(option, optionValue);
        ++this._currentOptionInLine;
    }

    @Override
    public void addIntOption(int option, int optionValue) {
        this._addIntOpt(option, optionValue);
        ++this._currentOptionInLine;
    }

    @Override
    public void addLongOption(int option, long optionValue) {
        this._addLongOpt(option, optionValue);
        ++this._currentOptionInLine;
    }

    @Override
    public void addStringOption(int option, String optionValue) {
        this._addStringOpt(option, optionValue);
        ++this._currentOptionInLine;
    }

    @Override
    public void addBinaryOption(int option, byte[] optionValue) {
        this._addBinaryOpt(option, optionValue);
        ++this._currentOptionInLine;
    }

    public boolean nextLine() {
        if (this._currentLine >= this._argumentCount) {
            return false;
        }
        while (this.nextOption()) {
        }
        ++this._currentLine;
        this._optionsInLineCount = this.getShort(this._currentOffset);
        this._currentOptionInLine = 1;
        this._currentOffset += 2;
        return true;
    }

    public void addLine(int optionsInLineCount) {
        this.putShort(optionsInLineCount, this._currentOffset);
        this._currentOffset += 2;
        ++this._argumentCount;
        ++this._currentLine;
        this._optionsInLineCount = optionsInLineCount;
        this._currentOptionInLine = 0;
    }
}

