/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.HanaClientClob;
import com.sap.db.jdbc.converters.AbstractPutval;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import java.io.Reader;
import java.sql.SQLException;

@NotThreadSafe
class HanaClientPutvalClob
extends AbstractPutval {
    private final HanaClientClob _clob;
    private final boolean _isNClob;
    private Reader _reader;
    private boolean _isEOF;

    protected HanaClientPutvalClob(HanaClientClob clob, int inputFieldPos, boolean isNClob) {
        super(inputFieldPos);
        this._clob = clob;
        this._isNClob = isNClob;
    }

    @Override
    public DataType getDataType() {
        return this._isNClob ? DataType.NCLOB : DataType.CLOB;
    }

    @Override
    public AbstractPutval cloneForBatch() {
        return new HanaClientPutvalClob(this._clob, this._inputFieldPos, this._isNClob);
    }

    @Override
    public void transferData(boolean isExecuteRequest, HDataPart dataPart) throws SQLException {
        boolean isReaderExhausted;
        if (this._reader == null) {
            this._reader = this._clob.getReaderForTransfer();
        }
        if (isReaderExhausted = dataPart.fillWithReader(isExecuteRequest, this._reader, this._descriptorOffset)) {
            this.markEOF();
        }
    }

    @Override
    public boolean isEOF() {
        return this._isEOF;
    }

    @Override
    public void markEOF() {
        this._isEOF = true;
    }

    public String toString() {
        return super.toString() + ":" + this._reader;
    }
}

