/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ClientKeyPair;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.KeyStore;
import com.sap.db.jdbc.ObjectStore;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.PlatformUtils;
import java.nio.file.Paths;
import java.security.Key;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@ThreadSafe
final class KeyCache {
    @GuardedBy(value="KeyCache.class")
    private static final Map<String, ColumnEncryptionKey> COLUMN_ENCRYPTION_KEY_MAP = new HashMap<String, ColumnEncryptionKey>();
    @GuardedBy(value="KeyCache.class")
    private static final Map<String, ClientKeyPair> CLIENT_KEY_PAIR_MAP = new HashMap<String, ClientKeyPair>();
    @GuardedBy(value="KeyCache.class")
    private static KeyStore _keyStore;
    @GuardedBy(value="KeyCache.class")
    private static String _password;
    @GuardedBy(value="KeyCache.class")
    private static ObjectStore _testObjectStore;
    @GuardedBy(value="KeyCache.class")
    private static String _keyStoreFilename;

    private KeyCache() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    static synchronized ColumnEncryptionKey getCachedColumnEncryptionKey(String columnEncryptionKeyId, String password) {
        if (_password == null || !_password.equals(password)) {
            return null;
        }
        return COLUMN_ENCRYPTION_KEY_MAP.get(columnEncryptionKeyId);
    }

    static synchronized void addColumnEncryptionKey(String columnEncryptionKeyId, ColumnEncryptionKey columnEncryptionKey) {
        COLUMN_ENCRYPTION_KEY_MAP.put(columnEncryptionKeyId, columnEncryptionKey);
    }

    static synchronized Key getCachedPublicClientKey(String keyId, String password) throws SQLException {
        KeyCache._ensureKeyStoreOpened(password);
        ClientKeyPair ckp = CLIENT_KEY_PAIR_MAP.get(keyId);
        if (ckp != null) {
            return ckp.getPublicKey();
        }
        ClientKeyPair keyPair = KeyCache._loadKeyPairFromStore(keyId);
        return keyPair.getPublicKey();
    }

    static synchronized Key getCachedPrivateClientKey(String keyId, String password) throws SQLException {
        KeyCache._ensureKeyStoreOpened(password);
        ClientKeyPair ckp = CLIENT_KEY_PAIR_MAP.get(keyId);
        if (ckp != null) {
            return ckp.getPrivateKey();
        }
        ClientKeyPair keyPair = KeyCache._loadKeyPairFromStore(keyId);
        return keyPair.getPrivateKey();
    }

    static synchronized Set<String> getClientKeyPairIds(String password) throws SQLException {
        KeyCache.loadAllClientKeyPairs(null, password);
        return CLIENT_KEY_PAIR_MAP.keySet();
    }

    static synchronized void deleteClientKeyPair(String uuid, String password) throws SQLException {
        KeyCache._ensureKeyStoreOpened(password);
        CLIENT_KEY_PAIR_MAP.remove(uuid);
        try {
            _keyStore.removeKey(UUID.fromString(uuid));
        }
        catch (KeyStore.KSException e) {
            switch (e.getCode()) {
                case KEY_NOT_FOUND: {
                    break;
                }
                default: {
                    KeyCache._defaultKsErrorHandler(e, uuid);
                    break;
                }
            }
        }
        catch (ObjectStore.StException e) {
            KeyCache._defaultStErrorHandler(e);
        }
    }

    static synchronized void storeClientKeyPair(ClientKeyPair clientKeyPair, String password) throws SQLException {
        KeyCache._ensureKeyStoreOpened(password);
        CLIENT_KEY_PAIR_MAP.put(clientKeyPair.getKeyUuid(), clientKeyPair);
        try {
            _keyStore.storeKey(UUID.fromString(clientKeyPair.getKeyUuid()), clientKeyPair.getKeyName(), clientKeyPair.getDatabaseName(), KeyStore.KeyType.KEYPAIR, KeyStore.KeyAlgorithm.RSA2048, clientKeyPair.getPrivateKey().getEncoded(), clientKeyPair.getPublicKey().getEncoded());
        }
        catch (KeyStore.KSException e) {
            KeyCache._defaultKsErrorHandler(e, clientKeyPair.getKeyUuid());
        }
        catch (ObjectStore.StException e) {
            KeyCache._defaultStErrorHandler(e);
        }
    }

    static synchronized void deleteCachedColumnEncryptionKey(String columnEncryptionKeyId, String password) {
        if (_password == null || !_password.equals(password)) {
            return;
        }
        COLUMN_ENCRYPTION_KEY_MAP.remove(columnEncryptionKeyId);
    }

    static synchronized void loadAllClientKeyPairs(String databaseName, String password) throws SQLException {
        KeyCache._ensureKeyStoreOpened(password);
        try {
            UUID[] keys;
            for (UUID key : keys = _keyStore.findKeys(null, databaseName)) {
                if (CLIENT_KEY_PAIR_MAP.containsKey(key.toString())) continue;
                try {
                    KeyCache._loadKeyPairFromStore(key.toString());
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("No client key pair with the given uuid")) continue;
                    throw e;
                }
            }
        }
        catch (KeyStore.KSException e) {
            KeyCache._defaultKsErrorHandler(e, null);
        }
        catch (ObjectStore.StException e) {
            KeyCache._defaultStErrorHandler(e);
        }
    }

    private static void _ensureKeyStoreOpened(String password) throws SQLException {
        if (_password != null && !_password.equals(password)) {
            throw SQLExceptionSapDB.newInstance("error.invalidpassword", new String[0]);
        }
        if (_keyStore == null) {
            KeyStore keyStore = new KeyStore();
            if (_testObjectStore != null) {
                keyStore.setObjectStore(_testObjectStore);
            }
            if (_keyStoreFilename != null) {
                keyStore.setFilename(_keyStoreFilename);
            }
            try {
                keyStore.open(password);
            }
            catch (KeyStore.KSException e) {
                KeyCache._defaultKsErrorHandler(e, null);
            }
            catch (ObjectStore.StException e) {
                KeyCache._defaultStErrorHandler(e);
            }
            _keyStore = keyStore;
            _password = password;
        }
    }

    private static void _defaultKsErrorHandler(KeyStore.KSException e, String keyId) throws SQLException {
        switch (e.getCode()) {
            case KEY_NOT_FOUND: {
                if (keyId == null) {
                    throw SQLExceptionSapDB.newInstance((Throwable)e, "error.invalidclientkeypair", new String[0]);
                }
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.clientkeypairnotfound", keyId);
            }
            case MALFORMED_KEY: 
            case ATTRIBUTE_NOT_FOUND: 
            case MISSING_KEY_ATTRIBUTE: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.invalidclientkeypair", new String[0]);
            }
            case KEY_ALREADY_EXISTS: {
                break;
            }
            case COULD_NOT_OPEN_STORE: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.openfile", _keyStoreFilename != null ? _keyStoreFilename : Paths.get(PlatformUtils.getHdbkeystoreUserProfilePath(), "hdbkeystore.dat").toString());
            }
            case PASSWORD_REQUIRED: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.password.required", new String[0]);
            }
            case INVALID_PARAMETER: 
            case STORE_NOT_OPEN: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.corruptkeystorefile", new String[0]);
            }
        }
    }

    private static void _defaultStErrorHandler(ObjectStore.StException e) throws SQLException {
        switch (e.getCode()) {
            case INVALID_PASSWORD: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.invalidpassword", new String[0]);
            }
            case UNENCRYPTED_STORE: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.invalidpassword", new String[0]);
            }
            case PASSWORD_REQUIRED: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.password.required", new String[0]);
            }
            case INVALID_STORE: 
            case HMAC_CHECK_FAILED: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.corruptkeystorefile", new String[0]);
            }
            case FILE_WRITE_FAILED: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.writefile", _keyStore.getKeyStoreFileName());
            }
            case FILE_READ_FAILED: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.readfile", _keyStore.getKeyStoreFileName());
            }
            case FILE_OPEN_FAILED: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.openfile", _keyStoreFilename != null ? _keyStoreFilename : Paths.get(PlatformUtils.getHdbkeystoreUserProfilePath(), "hdbkeystore.dat").toString());
            }
            case ENCRYPT_FAILED: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", "No additional information");
            }
            case DECRYPT_FAILED: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", "No additional information");
            }
            case UNKNOWN_STORE_VERSION: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.unknown.keystore.version", new String[0]);
            }
            case CRYPTO_EXTENSION_NOT_INSTALLED: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", "No additional information");
            }
            case WEAK_PASSWORD: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.weak.password", new String[0]);
            }
            case STORE_NOT_OPEN: 
            case OBJECT_NOT_FOUND: 
            case OBJECT_ALREADY_EXISTS: 
            case INVALID_PARAMETER: 
            case INVALID_INDEX: {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.corruptkeystorefile", new String[0]);
            }
        }
    }

    private static ClientKeyPair _loadKeyPairFromStore(String keyId) throws SQLException {
        try {
            KeyStore.Key key = _keyStore.getKey(UUID.fromString(keyId));
            ClientKeyPair keyPair = ClientKeyPair.newInstance(key.getPublicValue(), key.getPrivateValue(), key.getDatabaseName(), key.getName(), keyId, key.getAlgorithm().toString());
            CLIENT_KEY_PAIR_MAP.put(keyId, keyPair);
            return keyPair;
        }
        catch (KeyStore.KSException e) {
            KeyCache._defaultKsErrorHandler(e, keyId);
            return null;
        }
        catch (ObjectStore.StException e) {
            KeyCache._defaultStErrorHandler(e);
            return null;
        }
    }

    static synchronized void setKeyStoreFilename(String filename) {
        _keyStoreFilename = filename;
    }

    static synchronized String getColumnEncryptionKeyId(String cekName) {
        for (String cekId : COLUMN_ENCRYPTION_KEY_MAP.keySet()) {
            if (!COLUMN_ENCRYPTION_KEY_MAP.get(cekId).getKeyName().equals(cekName)) continue;
            return cekId;
        }
        return null;
    }

    static synchronized String getClientKeyPairId(String ckpName) {
        for (String ckpId : CLIENT_KEY_PAIR_MAP.keySet()) {
            if (!CLIENT_KEY_PAIR_MAP.get(ckpId).getKeyName().equals(ckpName)) continue;
            return ckpId;
        }
        return null;
    }

    static synchronized ClientKeyPair getClientKeyPair(String keyId) {
        return CLIENT_KEY_PAIR_MAP.get(keyId);
    }

    static synchronized Map<String, ClientKeyPair> getClientKeyPairMap() {
        return new HashMap<String, ClientKeyPair>(CLIENT_KEY_PAIR_MAP);
    }

    static synchronized Map<String, ClientKeyPair> getClientKeyPairMapRefresh(String password) throws SQLException {
        KeyCache.loadAllClientKeyPairs(null, password);
        return new HashMap<String, ClientKeyPair>(CLIENT_KEY_PAIR_MAP);
    }

    static synchronized Map<String, ColumnEncryptionKey> getColumnEncryptionKeyMap() {
        return new HashMap<String, ColumnEncryptionKey>(COLUMN_ENCRYPTION_KEY_MAP);
    }

    static synchronized void clear() {
        COLUMN_ENCRYPTION_KEY_MAP.clear();
        CLIENT_KEY_PAIR_MAP.clear();
    }

    static synchronized void setTestObjectStore(ObjectStore store) {
        _testObjectStore = store;
    }
}

