/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.APIMetrics;
import com.sap.db.jdbc.BasicChannelSession;
import com.sap.db.jdbc.BasicSocketSession;
import com.sap.db.jdbc.BasicWebSession;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.PassportListener;
import com.sap.db.jdbc.PreferredAddress;
import com.sap.db.jdbc.ResultSetMetaDataSapDB;
import com.sap.db.jdbc.ResultSetSapDB;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.SAPPassport;
import com.sap.db.jdbc.SecureChannelSession;
import com.sap.db.jdbc.SecureSocketSession;
import com.sap.db.jdbc.SecureStore;
import com.sap.db.jdbc.SecureStoreLoginInformation;
import com.sap.db.jdbc.SecureWebSession;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.SiteType;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.trace.TraceConfiguration;
import com.sap.db.jdbc.trace.TraceControl;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.jdbc.trace.TraceRecordPublisher;
import com.sap.db.jdbc.trace.TraceTool;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.DriverVersionInfo;
import com.sap.db.util.HexUtils;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.NetworkAddress;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverPropertyInfo;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.security.cert.X509Certificate;

@ThreadSafe
public abstract class DriverSapDB
implements java.sql.Driver {
    protected static final Tracer SETTINGS_FILE_TRACER;
    protected static final Tracer ENVIRONMENT_VARIABLE_TRACER;
    private static final String COMPUTER_NAME;
    private static final String FULL_COMPUTER_NAME;
    private static final int JAVA_VERSION;
    private static final int PROCESS_ID;
    @GuardedBy(value="itself")
    private static final Set<ConnectionSapDB> CONNECTIONS;
    private static final String DATABASE_NAME = "HDB";
    private static final String DRIVER_NAME = "HDB";
    private static final DriverVersionInfo VERSION_INFO;
    private static final int JDBC_MAJOR_VERSION = 4;
    private static final int JDBC_MINOR_VERSION = 3;
    private static final String PROTOCOL_NAME = "jdbc:sap:";
    private static final int PROTOCOL_NAME_LENGTH;
    private static final int DEFAULT_DB_BASE_PORT = 30015;
    private static final int DEFAULT_SYSTEM_DB_BASE_PORT = 30013;
    private static final String OBFUSCATED_PSWD_STRING = "***";
    @GuardedBy(value="Driver.class")
    private static Class<?> _nativeAuthenticationClass;
    @GuardedBy(value="Driver.class")
    private static HostnameVerifier _hostnameVerifier;
    @GuardedBy(value="Driver.class")
    private static Timer _heartbeatTimer;
    @GuardedBy(value="Driver.class")
    private static Set<TimerTask> _heartbeatTasks;

    public static void main(String[] args) {
        boolean isHeadless = GraphicsEnvironment.isHeadless();
        int argCount = args.length;
        if (argCount == 0) {
            DriverSapDB._showTraceSettings(isHeadless);
            return;
        }
        String arg = args[0];
        if (arg.equals("-h") || arg.equals("--help") || arg.equalsIgnoreCase("HELP")) {
            DriverSapDB._printUsage(null);
        } else if (arg.equalsIgnoreCase("-v") || arg.equals("--version") || arg.equalsIgnoreCase("VERSION")) {
            System.out.println(VERSION_INFO);
        } else if (arg.equals("-g") || arg.equals("--gui") || arg.equalsIgnoreCase("GUI")) {
            if (isHeadless) {
                System.err.println("GUI not available.");
            }
            DriverSapDB._showTraceSettings(isHeadless);
        } else if (arg.equalsIgnoreCase("SHOW")) {
            DriverSapDB._showTraceSettings(true);
        } else if (arg.equalsIgnoreCase("TRACE")) {
            if (argCount < 2) {
                DriverSapDB._printUsage("Invalid command, missing argument.");
            }
            TraceConfiguration settings = new TraceConfiguration();
            arg = args[1];
            if (arg.equalsIgnoreCase("ON")) {
                settings.setTraceEnabled(true);
            } else if (arg.equalsIgnoreCase("OFF")) {
                settings.setTraceEnabled(false);
            } else if (arg.equalsIgnoreCase("FILENAME")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                settings.setTraceFileName(args[2]);
            } else if (arg.equalsIgnoreCase("CONNECTIONS")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.CONNECTIONS, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.CONNECTIONS, false);
                } else {
                    DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("API")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.API, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.API, false);
                } else {
                    DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("PACKET")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.PACKET, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.PACKET, false);
                } else {
                    DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("DISTRIBUTION")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.DISTRIBUTION, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.DISTRIBUTION, false);
                } else {
                    DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("STATISTICS")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.STATISTICS, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.STATISTICS, false);
                } else {
                    DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("CLEANERS")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.CLEANERS, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.CLEANERS, false);
                } else {
                    DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("DEBUG")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("ON")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.DEBUG, true);
                } else if (arg.equalsIgnoreCase("OFF")) {
                    settings.setTraceLevel(TraceConfiguration.TraceLevel.DEBUG, false);
                } else {
                    DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("SHOW")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[2]).equalsIgnoreCase("PLAINTEXTCSE")) {
                    if (argCount < 4) {
                        DriverSapDB._printUsage("Invalid command, missing argument.");
                    }
                    if ((arg = args[3]).equalsIgnoreCase("ON")) {
                        settings.setShowPlainTextCSEEnabled(true);
                    } else if (arg.equalsIgnoreCase("OFF")) {
                        settings.setShowPlainTextCSEEnabled(false);
                    } else {
                        DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                    }
                } else if (arg.equalsIgnoreCase("TIMESTAMPS")) {
                    if (argCount < 4) {
                        DriverSapDB._printUsage("Invalid command, missing argument.");
                    }
                    if ((arg = args[3]).equalsIgnoreCase("ON")) {
                        settings.setShowTimestampsEnabled(true);
                    } else if (arg.equalsIgnoreCase("OFF")) {
                        settings.setShowTimestampsEnabled(false);
                    } else {
                        DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                    }
                } else if (arg.equalsIgnoreCase("ELAPSEDTIMES")) {
                    if (argCount < 4) {
                        DriverSapDB._printUsage("Invalid command, missing argument.");
                    }
                    if ((arg = args[3]).equalsIgnoreCase("ON")) {
                        settings.setShowElapsedTimesEnabled(true);
                    } else if (arg.equalsIgnoreCase("OFF")) {
                        settings.setShowElapsedTimesEnabled(false);
                    } else {
                        DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                    }
                } else {
                    DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                }
            } else if (arg.equalsIgnoreCase("SIZE")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                long fileSize = Long.MAX_VALUE;
                String units = "";
                arg = args[2];
                if (!arg.equalsIgnoreCase("UNLIMITED")) {
                    int i;
                    StringBuilder builder = new StringBuilder();
                    for (i = 2; i < argCount; ++i) {
                        builder.append(args[i].toUpperCase(Locale.ENGLISH));
                    }
                    String size = builder.toString();
                    int n = size.length();
                    for (i = 0; i < n; ++i) {
                        if (!Character.isDigit(size.charAt(i))) {
                            if (i == 0) {
                                DriverSapDB._printUsage("Invalid command, invalid size:", args, 2);
                                break;
                            }
                            fileSize = Long.parseLong(size.substring(0, i));
                            switch (size.charAt(i)) {
                                case 'K': {
                                    units = TraceConfiguration.SizeUnits.KILOBYTES.getDisplayString();
                                    break;
                                }
                                case 'M': {
                                    units = TraceConfiguration.SizeUnits.MEGABYTES.getDisplayString();
                                    break;
                                }
                                case 'G': {
                                    units = TraceConfiguration.SizeUnits.GIGABYTES.getDisplayString();
                                    break;
                                }
                                default: {
                                    DriverSapDB._printUsage("Invalid command, invalid size:", args, 2);
                                    break;
                                }
                            }
                            break;
                        }
                        if (i + 1 != n) continue;
                        fileSize = Long.parseLong(size);
                    }
                }
                settings.setTraceSize(fileSize, units);
            } else if (arg.equalsIgnoreCase("STOP")) {
                if (argCount < 4 || !args[2].equalsIgnoreCase("ON") || !args[3].equalsIgnoreCase("ERROR")) {
                    DriverSapDB._printUsage("Invalid command:", args, 0);
                }
                if (argCount < 5) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                int errorNum = 0;
                arg = args[4];
                if (!arg.equalsIgnoreCase("OFF")) {
                    try {
                        errorNum = Integer.parseInt(arg);
                    }
                    catch (NumberFormatException e) {
                        DriverSapDB._printUsage("Invalid command, invalid error number:" + arg);
                    }
                }
                settings.setStopOnError(errorNum);
            } else if (arg.equalsIgnoreCase("FAILURE")) {
                if (argCount < 3 || !args[2].equalsIgnoreCase("ACTION")) {
                    DriverSapDB._printUsage("Invalid command:", args, 0);
                }
                if (argCount < 4) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                if ((arg = args[3]).equalsIgnoreCase("IGNORE")) {
                    settings.setTraceFailureAction(TraceConfiguration.TraceFailureAction.IGNORE);
                } else if (arg.equalsIgnoreCase("STDOUT")) {
                    settings.setTraceFailureAction(TraceConfiguration.TraceFailureAction.STDOUT);
                } else if (arg.equalsIgnoreCase("STDERR")) {
                    settings.setTraceFailureAction(TraceConfiguration.TraceFailureAction.STDERR);
                } else if (arg.equalsIgnoreCase("EXCEPTION")) {
                    settings.setTraceFailureAction(TraceConfiguration.TraceFailureAction.EXCEPTION);
                } else {
                    DriverSapDB._printUsage("Invalid command, invalid argument:", arg);
                }
            } else {
                DriverSapDB._printUsage("Invalid command:", args, 0);
            }
            try {
                settings.saveTraceSettings();
            }
            catch (IOException e) {
                System.err.println("Can't save trace settings: " + e.getMessage());
            }
            settings.setTraceSettingsChanged();
            settings.printTraceSettings();
        } else if (arg.equalsIgnoreCase("PERFORMANCETRACE")) {
            if (argCount < 2) {
                DriverSapDB._printUsage("Invalid command, missing argument.");
            }
            TraceConfiguration settings = new TraceConfiguration();
            arg = args[1];
            if (arg.equalsIgnoreCase("ON")) {
                settings.setPerformanceTraceEnabled(true);
            } else if (arg.equalsIgnoreCase("OFF")) {
                settings.setPerformanceTraceEnabled(false);
            } else if (arg.equalsIgnoreCase("FILENAME")) {
                if (argCount < 3) {
                    DriverSapDB._printUsage("Invalid command, missing argument.");
                }
                settings.setPerformanceTraceFileName(args[2]);
            } else {
                DriverSapDB._printUsage("Invalid command:", args, 0);
            }
            try {
                settings.saveTraceSettings();
            }
            catch (IOException e) {
                System.err.println("Can't save trace settings: " + e.getMessage());
            }
            settings.setTraceSettingsChanged();
            settings.printTraceSettings();
        } else if (arg.equals("-u")) {
            int idx;
            if (argCount < 2) {
                DriverSapDB._printUsage("Missing username and password.");
            }
            if ((idx = (arg = args[1]).indexOf(44)) == -1 || idx == 0 || idx == arg.length() - 1) {
                DriverSapDB._printUsage("Invalid username and password:", arg);
            }
            Properties info = new Properties();
            info.setProperty(ConnectionProperty.USER.getName(), arg.substring(0, idx));
            info.setProperty(ConnectionProperty.PASSWD.getName(), arg.substring(idx + 1));
            DriverSapDB._processRemainingArguments(args, info, false);
        } else if (arg.equals("-k")) {
            if (argCount < 2) {
                DriverSapDB._printUsage("Missing key.");
            }
            arg = args[1];
            Properties info = new Properties();
            info.setProperty(ConnectionProperty.KEY.getName(), arg);
            DriverSapDB._processRemainingArguments(args, info, true);
        } else {
            DriverSapDB._printUsage("Invalid argument:", arg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _processRemainingArguments(String[] args, Properties info, boolean isKeySpecified) {
        int argCount = args.length;
        String address = "localhost:30015";
        String command = "SELECT CURRENT_TIMESTAMP FROM DUMMY";
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        block37: for (int i = 2; i < argCount; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "-n": {
                    if (isKeySpecified) {
                        DriverSapDB._printUsage("Invalid argument:", arg);
                    }
                    if (i == argCount - 1) {
                        DriverSapDB._printUsage("Missing host name.");
                    }
                    address = args[++i];
                    continue block37;
                }
                case "-d": {
                    if (isKeySpecified) {
                        DriverSapDB._printUsage("Invalid argument:", arg);
                    }
                    if (i == argCount - 1) {
                        DriverSapDB._printUsage("Missing database name.");
                    }
                    info.setProperty(ConnectionProperty.DATABASE_NAME.getName(), args[++i]);
                    continue block37;
                }
                case "-i": {
                    if (isKeySpecified) {
                        DriverSapDB._printUsage("Invalid argument:", arg);
                    }
                    if (i == argCount - 1) {
                        DriverSapDB._printUsage("Missing instance number.");
                    }
                    info.setProperty(ConnectionProperty.INSTANCE_NUMBER.getName(), args[++i]);
                    continue block37;
                }
                case "-o": {
                    int idx;
                    if (i == argCount - 1) {
                        DriverSapDB._printUsage("Missing option name and value.");
                    }
                    if ((idx = (arg = args[++i]).indexOf(61)) == -1 || idx == 0 || idx == arg.length() - 1) {
                        DriverSapDB._printUsage("Invalid option name and value:", arg);
                    }
                    info.setProperty(arg.substring(0, idx), arg.substring(idx + 1));
                    continue block37;
                }
                case "-c": {
                    if (i == argCount - 1) {
                        DriverSapDB._printUsage("Missing SQL command.");
                    }
                    command = args[++i];
                    continue block37;
                }
                default: {
                    DriverSapDB._printUsage("Invalid argument:", arg);
                }
            }
        }
        try {
            connection = Driver.getInstance().connect(DriverSapDB.buildURL(address, new ConnectionProperties(info)), info);
            System.out.println("Connected.");
            if (!command.isEmpty()) {
                statement = connection.createStatement();
                if (statement.execute(command)) {
                    resultSet = statement.getResultSet();
                    DriverSapDB.printResultSet(System.out, resultSet);
                } else {
                    System.out.println(statement.getUpdateCount() + " row(s) affected");
                }
            }
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static void suspendTracing(Connection connection) {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        tracer.suspendTrace();
    }

    public static void resumeTracing(Connection connection) {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        tracer.resumeTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static int getAnchorConnectionID(Connection connection) {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getAnchorConnectionID") : null;
        try {
            int result;
            if (on) {
                tracer.printCall(Driver.class, "getAnchorConnectionID", connection);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = DriverSapDB.getAnchorConnID(connection);
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static int getPrimaryConnectionID(Connection connection) {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getPrimaryConnectionID") : null;
        try {
            int result;
            if (on) {
                tracer.printCall(Driver.class, "getPrimaryConnectionID", connection);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = DriverSapDB.getPrimaryConnID(connection);
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static boolean isEmptyDate(Date date) {
        Tracer tracer = DriverSapDB.getTracer();
        tracer.refreshTraceSettings();
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("isEmptyDate") : null;
        try {
            boolean result;
            if (on) {
                tracer.printCall(Driver.class, "isEmptyDate", date);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = date != null && date.getTime() == AbstractConverter.getEmptyDayDateMilliseconds();
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static boolean isEmptyTime(Time time) {
        Tracer tracer = DriverSapDB.getTracer();
        tracer.refreshTraceSettings();
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("isEmptyTime") : null;
        try {
            boolean result;
            if (on) {
                tracer.printCall(Driver.class, "isEmptyTime", time);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = time != null && time.getTime() == AbstractConverter.getEmptySecondTimeMilliseconds();
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static boolean isEmptyTimestamp(Timestamp timestamp) {
        Tracer tracer = DriverSapDB.getTracer();
        tracer.refreshTraceSettings();
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("isEmptyTimestamp") : null;
        try {
            boolean result;
            if (on) {
                tracer.printCall(Driver.class, "isEmptyTimestamp", timestamp);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = timestamp != null && (timestamp.getTime() == AbstractConverter.getEmptySecondDateMilliseconds() || timestamp.getTime() == AbstractConverter.getEmptyLongDateMilliseconds() && timestamp.getNanos() == AbstractConverter.getEmptyLongDateNanoseconds());
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static List<String> getPrintLines(Statement statement) {
        Tracer tracer;
        StatementSapDB statementSapDB = StatementSapDB.getStatementSapDB(statement);
        if (statementSapDB != null) {
            tracer = statementSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getPrintLines") : null;
        try {
            List<String> result;
            if (on) {
                tracer.printCall(Driver.class, "getPrintLines", statement);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = statementSapDB != null ? statementSapDB._getPrintLines() : Collections.emptyList();
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            List<String> list = result;
            return list;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static long getServerProcessingTime(Statement statement) {
        Tracer tracer;
        StatementSapDB statementSapDB = StatementSapDB.getStatementSapDB(statement);
        if (statementSapDB != null) {
            tracer = statementSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getServerProcessingTime") : null;
        try {
            long result;
            if (on) {
                tracer.printCall(Driver.class, "getServerProcessingTime", statement);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = statementSapDB != null ? statementSapDB.getServerKPIs().getServerProcessingTime() : 0L;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static long getServerProcessingTime(ResultSet resultSet) {
        Tracer tracer;
        ResultSetSapDB resultSetSapDB = ResultSetSapDB.getResultSetSapDB(resultSet);
        if (resultSetSapDB != null) {
            tracer = resultSetSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getServerProcessingTime") : null;
        try {
            long result;
            if (on) {
                tracer.printCall(Driver.class, "getServerProcessingTime", resultSet);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = resultSetSapDB != null ? resultSetSapDB.getServerKPIs().getServerProcessingTime() : 0L;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static long getServerCPUTime(Statement statement) {
        Tracer tracer;
        StatementSapDB statementSapDB = StatementSapDB.getStatementSapDB(statement);
        if (statementSapDB != null) {
            tracer = statementSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getServerCPUTime") : null;
        try {
            long result;
            if (on) {
                tracer.printCall(Driver.class, "getServerCPUTime", statement);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = statementSapDB != null ? statementSapDB.getServerKPIs().getServerCPUTime() : 0L;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static long getServerCPUTime(ResultSet resultSet) {
        Tracer tracer;
        ResultSetSapDB resultSetSapDB = ResultSetSapDB.getResultSetSapDB(resultSet);
        if (resultSetSapDB != null) {
            tracer = resultSetSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getServerCPUTime") : null;
        try {
            long result;
            if (on) {
                tracer.printCall(Driver.class, "getServerCPUTime", resultSet);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = resultSetSapDB != null ? resultSetSapDB.getServerKPIs().getServerCPUTime() : 0L;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static long getServerMemoryUsage(Statement statement) {
        Tracer tracer;
        StatementSapDB statementSapDB = StatementSapDB.getStatementSapDB(statement);
        if (statementSapDB != null) {
            tracer = statementSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getServerMemoryUsage") : null;
        try {
            long result;
            if (on) {
                tracer.printCall(Driver.class, "getServerMemoryUsage", statement);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = statementSapDB != null ? statementSapDB.getServerKPIs().getServerMemoryUsage() : 0L;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static long getServerMemoryUsage(ResultSet resultSet) {
        Tracer tracer;
        ResultSetSapDB resultSetSapDB = ResultSetSapDB.getResultSetSapDB(resultSet);
        if (resultSetSapDB != null) {
            tracer = resultSetSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getServerMemoryUsage") : null;
        try {
            long result;
            if (on) {
                tracer.printCall(Driver.class, "getServerMemoryUsage", resultSet);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = resultSetSapDB != null ? resultSetSapDB.getServerKPIs().getServerMemoryUsage() : 0L;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static int getPacketSize(Statement statement) throws SQLException {
        Tracer tracer;
        StatementSapDB statementSapDB = StatementSapDB.getStatementSapDB(statement);
        if (statementSapDB != null) {
            tracer = statementSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getPacketSize") : null;
        try {
            int result;
            if (on) {
                tracer.printCall(Driver.class, "getPacketSize", statement);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = statementSapDB != null ? statementSapDB.getPacketSize() : 0;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static void setPacketSize(Statement statement, int packetSize) throws SQLException {
        Tracer tracer;
        StatementSapDB statementSapDB = StatementSapDB.getStatementSapDB(statement);
        if (statementSapDB != null) {
            tracer = statementSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("setPacketSize") : null;
        try {
            if (on) {
                tracer.printCall(Driver.class, "setPacketSize", statement, packetSize);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                if (statementSapDB != null) {
                    statementSapDB.setPacketSize(packetSize);
                }
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static String getSQL(Statement statement) throws SQLException {
        Tracer tracer;
        StatementSapDB statementSapDB = StatementSapDB.getStatementSapDB(statement);
        if (statementSapDB != null) {
            tracer = statementSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getSQL") : null;
        try {
            String result;
            if (on) {
                tracer.printCall(Driver.class, "getSQL", statement);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = statementSapDB != null ? statementSapDB.getSQL() : null;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static List<String> getBatchSQL(Statement statement) throws SQLException {
        Tracer tracer;
        StatementSapDB statementSapDB = StatementSapDB.getStatementSapDB(statement);
        if (statementSapDB != null) {
            tracer = statementSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getBatchSQL") : null;
        try {
            List<String> result;
            if (on) {
                tracer.printCall(Driver.class, "getBatchSQL", statement);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = statementSapDB != null ? statementSapDB.getBatchSQL() : null;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            List<String> list = result;
            return list;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static String getSQLHash(Statement statement) throws SQLException {
        Tracer tracer;
        StatementSapDB statementSapDB = StatementSapDB.getStatementSapDB(statement);
        if (statementSapDB != null) {
            tracer = statementSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getSQLHash") : null;
        try {
            String result;
            if (on) {
                tracer.printCall(Driver.class, "getSQLHash", statement);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = statementSapDB != null ? HexUtils.toHexString(statementSapDB.getSQLHash()) : null;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static SAPPassport getPassport(Connection connection) {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getPassport") : null;
        try {
            SAPPassport result;
            if (on) {
                tracer.printCall(Driver.class, "getPassport", connection);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB.getPassport() : null;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            SAPPassport sAPPassport = result;
            return sAPPassport;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static void setPassport(Connection connection, byte[] inboundBytes, String componentName, PassportListener passportListener) {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("setPassport") : null;
        try {
            if (on) {
                tracer.printCall(Driver.class, "setPassport", connection, inboundBytes, componentName, passportListener);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                if (connectionSapDB != null) {
                    connectionSapDB.setPassport(inboundBytes, componentName, passportListener);
                }
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static void setPassport(Connection connection, String inboundHexString, String componentName, PassportListener passportListener) {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("setPassport") : null;
        try {
            if (on) {
                tracer.printCall(Driver.class, "setPassport", connection, inboundHexString, componentName, passportListener);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                if (connectionSapDB != null) {
                    connectionSapDB.setPassport(inboundHexString, componentName, passportListener);
                }
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static void clearPassport(Connection connection) {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("clearPassport") : null;
        try {
            if (on) {
                tracer.printCall(Driver.class, "clearPassport", connection);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                if (connectionSapDB != null) {
                    connectionSapDB.clearPassport();
                }
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static Statement createStatement(Connection connection, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("createStatement") : null;
        try {
            Statement result;
            if (on) {
                tracer.printCall(Driver.class, "createStatement", connection, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB._createStatement(1003, 1007, connectionSapDB._getHoldability(), commandInfoSource, commandInfoLine) : connection.createStatement();
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            Statement statement = result;
            return statement;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static Statement createStatement(Connection connection, int resultSetType, int resultSetConcurrency, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("createStatement") : null;
        try {
            Statement result;
            if (on) {
                tracer.printCall(Driver.class, "createStatement", connection, resultSetType, resultSetConcurrency, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB._createStatement(resultSetType, resultSetConcurrency, connectionSapDB._getHoldability(), commandInfoSource, commandInfoLine) : connection.createStatement(resultSetType, resultSetConcurrency);
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            Statement statement = result;
            return statement;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static Statement createStatement(Connection connection, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("createStatement") : null;
        try {
            Statement result;
            if (on) {
                tracer.printCall(Driver.class, "createStatement", connection, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB._createStatement(resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine) : connection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            Statement statement = result;
            return statement;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="true")
    public static PreparedStatement prepareStatement(Connection connection, String sql, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        PassportListener pl = connectionSapDB != null ? connectionSapDB.getPassportListener() : null;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("prepareStatement") : null;
        try {
            PreparedStatement result;
            if (on) {
                tracer.printCall(Driver.class, "prepareStatement", connection, sql, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB._prepareStatement(sql, 1003, 1007, connectionSapDB._getHoldability(), commandInfoSource, commandInfoLine, connectionSapDB._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE) : connection.prepareStatement(sql);
            }
            finally {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiFinish(aon, pl);
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="true")
    public static PreparedStatement prepareStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        PassportListener pl = connectionSapDB != null ? connectionSapDB.getPassportListener() : null;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("prepareStatement") : null;
        try {
            PreparedStatement result;
            if (on) {
                tracer.printCall(Driver.class, "prepareStatement", connection, sql, resultSetType, resultSetConcurrency, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB._prepareStatement(sql, resultSetType, resultSetConcurrency, connectionSapDB._getHoldability(), commandInfoSource, commandInfoLine, connectionSapDB._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE) : connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
            }
            finally {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiFinish(aon, pl);
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="true")
    public static PreparedStatement prepareStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        PassportListener pl = connectionSapDB != null ? connectionSapDB.getPassportListener() : null;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("prepareStatement") : null;
        try {
            PreparedStatement result;
            if (on) {
                tracer.printCall(Driver.class, "prepareStatement", connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB._prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, connectionSapDB._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE) : connection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            finally {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiFinish(aon, pl);
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="true")
    public static PreparedStatement prepareStatement(Connection connection, String sql, int autoGeneratedKeys, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        PassportListener pl = connectionSapDB != null ? connectionSapDB.getPassportListener() : null;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("prepareStatement") : null;
        try {
            PreparedStatement result;
            if (on) {
                tracer.printCall(Driver.class, "prepareStatement", connection, sql, autoGeneratedKeys, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB._prepareStatement(sql, 1003, 1007, connectionSapDB._getHoldability(), commandInfoSource, commandInfoLine, connectionSapDB._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE) : connection.prepareStatement(sql, autoGeneratedKeys);
            }
            finally {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiFinish(aon, pl);
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            PreparedStatement preparedStatement = result;
            return preparedStatement;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="true")
    public static CallableStatement prepareCall(Connection connection, String sql, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        PassportListener pl = connectionSapDB != null ? connectionSapDB.getPassportListener() : null;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("prepareCall") : null;
        try {
            CallableStatement result;
            if (on) {
                tracer.printCall(Driver.class, "prepareCall", connection, sql, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB._prepareCall(sql, 1003, 1007, connectionSapDB._getHoldability(), commandInfoSource, commandInfoLine, connectionSapDB._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE) : connection.prepareCall(sql);
            }
            finally {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiFinish(aon, pl);
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            CallableStatement callableStatement = result;
            return callableStatement;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="true")
    public static CallableStatement prepareCall(Connection connection, String sql, int resultSetType, int resultSetConcurrency, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        PassportListener pl = connectionSapDB != null ? connectionSapDB.getPassportListener() : null;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("prepareCall") : null;
        try {
            CallableStatement result;
            if (on) {
                tracer.printCall(Driver.class, "prepareCall", connection, sql, resultSetType, resultSetConcurrency, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB._prepareCall(sql, resultSetType, resultSetConcurrency, connectionSapDB._getHoldability(), commandInfoSource, commandInfoLine, connectionSapDB._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE) : connection.prepareCall(sql, resultSetType, resultSetConcurrency);
            }
            finally {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiFinish(aon, pl);
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            CallableStatement callableStatement = result;
            return callableStatement;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="true")
    public static CallableStatement prepareCall(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB != null) {
            tracer = connectionSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        PassportListener pl = connectionSapDB != null ? connectionSapDB.getPassportListener() : null;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("prepareCall") : null;
        try {
            CallableStatement result;
            if (on) {
                tracer.printCall(Driver.class, "prepareCall", connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiStart();
                }
                result = connectionSapDB != null ? connectionSapDB._prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability, commandInfoSource, commandInfoLine, connectionSapDB._isDeferredPrepare() ? StatementSapDB.StatementFlag.DEFER_PREPARE : StatementSapDB.StatementFlag.NONE) : connection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            }
            finally {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiFinish(aon, pl);
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            CallableStatement callableStatement = result;
            return callableStatement;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JDBCAPI(packetExchange="false")
    public static void setCommandInfo(Statement statement, String commandInfoSource, int commandInfoLine) throws SQLException {
        Tracer tracer;
        StatementSapDB statementSapDB = StatementSapDB.getStatementSapDB(statement);
        if (statementSapDB != null) {
            tracer = statementSapDB.getTracer();
        } else {
            tracer = DriverSapDB.getTracer();
            tracer.refreshTraceSettings();
        }
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("setCommandInfo") : null;
        try {
            if (on) {
                tracer.printCall(Driver.class, "setCommandInfo", statement, commandInfoSource, commandInfoLine);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                if (statementSapDB != null) {
                    statementSapDB.setCommandInfo(commandInfoSource, commandInfoLine);
                }
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    public static synchronized HostnameVerifier getHostnameVerifier() {
        return _hostnameVerifier;
    }

    public static synchronized void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        _hostnameVerifier = hostnameVerifier;
    }

    public static X509Certificate[] getPeerCertificateChain(Connection connection) {
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB == null || connectionSapDB._isClosed()) {
            return null;
        }
        Session anchorSession = connectionSapDB.getSessionPool().getAnchorSession();
        if (anchorSession == null) {
            return null;
        }
        return anchorSession._getPeerCertificateChain();
    }

    public static Certificate[] getPeerCertificates(Connection connection) {
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB == null || connectionSapDB._isClosed()) {
            return null;
        }
        Session anchorSession = connectionSapDB.getSessionPool().getAnchorSession();
        if (anchorSession == null) {
            return null;
        }
        return anchorSession._getPeerCertificates();
    }

    public static String getComputerName() {
        return COMPUTER_NAME;
    }

    public static String getFullComputerName() {
        return FULL_COMPUTER_NAME;
    }

    public static int getJavaVersion() {
        return JAVA_VERSION;
    }

    public static int getProcessID() {
        return PROCESS_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ConnectionSapDB> getConnections() {
        Set<ConnectionSapDB> set = CONNECTIONS;
        synchronized (set) {
            return new HashSet<ConnectionSapDB>(CONNECTIONS);
        }
    }

    public static String getDatabaseName() {
        return "HDB";
    }

    public static String getDriverName() {
        return "HDB";
    }

    public static DriverVersionInfo getVersionInfo() {
        return VERSION_INFO;
    }

    public static int getJDBCMajorVersion() {
        return 4;
    }

    public static int getJDBCMinorVersion() {
        return 3;
    }

    public static Tracer getTracer() {
        if (ENVIRONMENT_VARIABLE_TRACER != null) {
            ENVIRONMENT_VARIABLE_TRACER.switchTraceOn();
            return ENVIRONMENT_VARIABLE_TRACER;
        }
        return SETTINGS_FILE_TRACER;
    }

    public static TraceControl getTraceControl() {
        return DriverSapDB.getTracer().getTraceControl();
    }

    public static void checkJavaVersionMaximum8() {
        DriverSapDB._checkJavaVersion(-1, 8);
    }

    public static void checkJavaVersionMinimum9() {
        DriverSapDB._checkJavaVersion(9, -1);
    }

    public static void checkJavaVersionMaximum10() {
        DriverSapDB._checkJavaVersion(-1, 10);
    }

    public static void checkJavaVersionMinimum11() {
        DriverSapDB._checkJavaVersion(11, -1);
    }

    private static void _checkJavaVersion(int min, int max) {
        if (min != -1 && JAVA_VERSION < min) {
            throw new AssertionError((Object)("Unexpected Java class loaded under Java version " + JAVA_VERSION + " (minimum supported version is " + min + ")"));
        }
        if (max != -1 && JAVA_VERSION > max) {
            throw new AssertionError((Object)("Unexpected Java class loaded under Java version " + JAVA_VERSION + " (maximum supported version is " + max + ")"));
        }
    }

    public static int getAnchorConnID(Connection connection) {
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB == null || connectionSapDB._isClosed()) {
            return -1;
        }
        Session anchorSession = connectionSapDB.getSessionPool().getAnchorSession();
        if (anchorSession == null) {
            return -1;
        }
        return anchorSession.getConnectionID();
    }

    public static int getPrimaryConnID(Connection connection) {
        ConnectionSapDB connectionSapDB = ConnectionSapDB.getConnectionSapDB(connection);
        if (connectionSapDB == null || connectionSapDB._isClosed()) {
            return -1;
        }
        Session primarySession = connectionSapDB.getSessionPool().getPrimarySession();
        if (primarySession == null) {
            return -1;
        }
        return primarySession.getConnectionID();
    }

    public static SessionFactory getSessionFactory(Tracer tracer, ConnectionProperties connectionProperties) throws RTEException {
        SessionFactory factory;
        boolean isWebSocket;
        String webSocketUrl = connectionProperties.getProperty(ConnectionProperty.WEB_SOCKET_URL);
        boolean bl = isWebSocket = webSocketUrl != null && !webSocketUrl.isEmpty();
        String transport = (isWebSocket || connectionProperties.getBooleanProperty(ConnectionProperty.PROXY_HTTP)) && !connectionProperties.hasProperty(ConnectionProperty.ENCRYPT) && !connectionProperties.hasProperty(ConnectionProperty.TRANSPORT) ? "secure" : (connectionProperties.getBooleanProperty(ConnectionProperty.ENCRYPT) ? "secure" : connectionProperties.getProperty(ConnectionProperty.TRANSPORT));
        if (transport.equals("secure")) {
            factory = isWebSocket ? SecureWebSession.SECURE_WEB_SESSION_FACTORY : (connectionProperties.getBooleanProperty(ConnectionProperty.NON_BLOCKING_IO) ? SecureChannelSession.SECURE_CHANNEL_SESSION_FACTORY : SecureSocketSession.SECURE_SOCKET_SESSION_FACTORY);
        } else if (transport.equals("socket")) {
            factory = isWebSocket ? BasicWebSession.BASIC_WEB_SESSION_FACTORY : (connectionProperties.getBooleanProperty(ConnectionProperty.NON_BLOCKING_IO) ? BasicChannelSession.BASIC_CHANNEL_SESSION_FACTORY : BasicSocketSession.BASIC_SOCKET_SESSION_FACTORY);
        } else {
            throw RTEException.newInstance(tracer, null, MessageTranslator.translate("error.invalid.transport", transport), RteReturnCode.SQLNOTOK, -10899);
        }
        return factory;
    }

    public static String buildURL(String addresses, ConnectionProperties connectionProperties) {
        String url = "jdbc:sap://" + addresses;
        boolean hasOption = false;
        if (connectionProperties != null) {
            String value = connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
            if (value != null && !value.isEmpty()) {
                url = url + "?" + ConnectionProperty.DATABASE_NAME.getName() + "=" + value;
                hasOption = true;
            }
            if ((value = connectionProperties.getProperty(ConnectionProperty.INSTANCE_NUMBER)) != null) {
                url = url + (hasOption ? "&" : "?") + ConnectionProperty.INSTANCE_NUMBER.getName() + "=" + value;
            }
        }
        return url;
    }

    public static void printResultSet(PrintStream out, ResultSet resultSet) throws SQLException {
        int width;
        int i;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int columnCount = resultSetMetaData.getColumnCount();
        boolean[] isArrays = new boolean[columnCount];
        boolean[] isSpatials = new boolean[columnCount];
        int[] widths = new int[columnCount];
        out.print("|");
        int totalWidth = 1;
        for (i = 1; i <= columnCount; ++i) {
            boolean isSpatial;
            String columnName = resultSetMetaData.getColumnLabel(i);
            int dataType = resultSetMetaData.getColumnType(i);
            DataType dataTypeEnum = resultSetMetaData instanceof ResultSetMetaDataSapDB ? ((ResultSetMetaDataSapDB)resultSetMetaData).getConverter(i).getDataType() : null;
            width = resultSetMetaData.getPrecision(i);
            boolean isLob = dataType == 2005 || dataType == 2011 || dataType == 2004;
            boolean isArray = dataType == 2003;
            boolean bl = isSpatial = dataTypeEnum == DataType.POINT || dataTypeEnum == DataType.GEOMETRY;
            if (isLob || isArray || isSpatial) {
                width = 200;
            } else if (width > 100) {
                width = 100;
            } else if (width < 6) {
                width = 6;
            }
            widths[i - 1] = width;
            isArrays[i - 1] = isArray;
            isSpatials[i - 1] = isSpatial;
            out.printf(" %-" + width + "." + width + "s |", columnName);
            totalWidth += width + 3;
        }
        out.println();
        out.print(String.format("%" + totalWidth + "s\n", "").replace(' ', '-'));
        long rowCount = 0L;
        while (resultSet.next()) {
            out.print("|");
            for (i = 1; i <= columnCount; ++i) {
                byte[] bytes;
                Array array;
                String value = isArrays[i - 1] ? ((array = resultSet.getArray(i)) != null ? Arrays.deepToString((Object[])array.getArray()) : null) : (isSpatials[i - 1] ? ((bytes = resultSet.getBytes(i)) != null ? Arrays.toString(bytes) : null) : resultSet.getString(i));
                if (value == null) {
                    value = "(NULL)";
                }
                width = widths[i - 1];
                out.printf(" %-" + width + "." + width + "s |", value);
            }
            out.println();
            ++rowCount;
        }
        out.printf("%d rows.\n", rowCount);
    }

    public static synchronized Class<?> loadNativeAuthentication() throws SQLException {
        if (_nativeAuthenticationClass != null) {
            return _nativeAuthenticationClass;
        }
        try {
            System.loadLibrary("jniAuthentication");
            _nativeAuthenticationClass = Class.forName("com.sap.db.util.security.NativeAuthenticationManager");
        }
        catch (ClassNotFoundException | SecurityException | UnsatisfiedLinkError e) {
            throw SQLExceptionSapDB.newInstance(e, "error.library.notloaded", "jniAuthentication", e.toString());
        }
        return _nativeAuthenticationClass;
    }

    public static String getAddresses(String url) {
        int idx;
        if (url == null || !url.startsWith(PROTOCOL_NAME)) {
            return url;
        }
        String addresses = url.substring(PROTOCOL_NAME_LENGTH);
        if (addresses.startsWith("//")) {
            addresses = addresses.substring(2);
        }
        if ((idx = addresses.indexOf(47)) != -1) {
            addresses = addresses.substring(0, idx);
        }
        return addresses;
    }

    public static synchronized void setNativeAuthenticationClass(Class<?> clas) throws SQLException {
        String[] methods = new String[]{"init", "release", "evaluate"};
        Class[][] parameterTypes = new Class[][]{{String.class, String.class}, {Long.TYPE}, {Long.TYPE, byte[].class}};
        for (int i = 0; i < methods.length; ++i) {
            try {
                clas.getMethod(methods[i], parameterTypes[i]);
                continue;
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.wrong.autenticationclass", e.toString());
            }
        }
        _nativeAuthenticationClass = clas;
    }

    public static TraceControl openTrace(Properties info) {
        return DriverSapDB._openTrace(new ConnectionProperties(info)).getTraceControl();
    }

    public static void switchTraceOff() {
        DriverSapDB.getTracer().switchTraceOff();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="true")
    public Connection connect(String url, Properties info) throws SQLException {
        String[] outUrlPrefix = new String[1];
        Properties[] outMergedInfo = new Properties[1];
        ConnectionProperties[] outConnectionProperties = new ConnectionProperties[1];
        PassportListener[] outPassportListener = new PassportListener[1];
        Tracer tracer = DriverSapDB._initConnect(url, info, outUrlPrefix, outMergedInfo, outConnectionProperties, outPassportListener);
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        PassportListener pl = outPassportListener[0];
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("connect") : null;
        try {
            Connection result;
            if (on) {
                tracer.printCall(this, "connect", DriverSapDB.getDisplayUrl(url), DriverSapDB.getDisplayProperties(info));
            }
            try {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiStart();
                }
                result = DriverSapDB._connect(outUrlPrefix[0], outMergedInfo[0], outConnectionProperties[0], pl, tracer);
            }
            finally {
                if (aon || pl != null) {
                    APIMetrics.getInstance().apiFinish(aon, pl);
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            Connection connection = result;
            return connection;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean acceptsURL(String url) throws SQLException {
        Tracer tracer = DriverSapDB.getTracer();
        tracer.refreshTraceSettings();
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("acceptsURL") : null;
        try {
            boolean result;
            if (on) {
                tracer.printCall(this, "acceptsURL", DriverSapDB.getDisplayUrl(url));
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = DriverSapDB._acceptsURL(url);
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Tracer tracer = DriverSapDB.getTracer();
        tracer.refreshTraceSettings();
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getPropertyInfo") : null;
        try {
            DriverPropertyInfo[] result;
            if (on) {
                tracer.printCall(this, "getPropertyInfo", DriverSapDB.getDisplayUrl(url), DriverSapDB.getDisplayProperties(info));
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = DriverSapDB._getPropertyInfo(info);
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            DriverPropertyInfo[] driverPropertyInfoArray = result;
            return driverPropertyInfoArray;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMajorVersion() {
        Tracer tracer = DriverSapDB.getTracer();
        tracer.refreshTraceSettings();
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getMajorVersion") : null;
        try {
            int result;
            if (on) {
                tracer.printCall(this, "getMajorVersion", new Object[0]);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = VERSION_INFO.getMajorVersion();
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int getMinorVersion() {
        Tracer tracer = DriverSapDB.getTracer();
        tracer.refreshTraceSettings();
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getMinorVersion") : null;
        try {
            int result;
            if (on) {
                tracer.printCall(this, "getMinorVersion", new Object[0]);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = VERSION_INFO.getMinorVersion();
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public boolean jdbcCompliant() {
        Tracer tracer = DriverSapDB.getTracer();
        tracer.refreshTraceSettings();
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("jdbcCompliant") : null;
        try {
            boolean result;
            if (on) {
                tracer.printCall(this, "jdbcCompliant", new Object[0]);
            }
            try {
                if (aon) {
                    APIMetrics.getInstance().apiStart();
                }
                result = true;
            }
            finally {
                if (aon) {
                    APIMetrics.getInstance().apiFinish();
                }
            }
            if (on) {
                tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                DriverSapDB._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        Tracer tracer = DriverSapDB.getTracer();
        tracer.refreshTraceSettings();
        boolean on = tracer.on();
        boolean pon = tracer.pon();
        boolean aon = on ? tracer.aon() : false;
        TraceRecord r = pon ? DriverSapDB._newTraceRecord("getParentLogger") : null;
        try {
            try {
                if (on) {
                    tracer.printCall(this, "getParentLogger", new Object[0]);
                }
                try {
                    if (aon) {
                        APIMetrics.getInstance().apiStart();
                    }
                    throw (SQLFeatureNotSupportedException)DriverSapDB._getUnsupportedMethodException("getParentLogger()");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        APIMetrics.getInstance().apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                DriverSapDB._publish(r);
            }
            throw throwable;
        }
    }

    public Connection getConnection(String url, Properties info) throws SQLException {
        String[] outUrlPrefix = new String[1];
        Properties[] outMergedInfo = new Properties[1];
        ConnectionProperties[] outConnectionProperties = new ConnectionProperties[1];
        PassportListener[] outPassportListener = new PassportListener[1];
        Tracer tracer = DriverSapDB._initConnect(url, info, outUrlPrefix, outMergedInfo, outConnectionProperties, outPassportListener);
        return DriverSapDB._connect(outUrlPrefix[0], outMergedInfo[0], outConnectionProperties[0], outPassportListener[0], tracer);
    }

    public static String getDisplayUrl(String url) {
        if (url == null) {
            return null;
        }
        Properties info = new Properties();
        String urlPrefix = DriverSapDB._getUrlPrefixAndCanonicalProperties(url, new Properties(), info);
        StringBuilder builder = new StringBuilder(urlPrefix);
        boolean isFirst = true;
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String key = entry.getKey().toString();
            ConnectionProperty connectionProperty = ConnectionProperty.getConnectionProperty(key);
            String value = connectionProperty != null && connectionProperty.isPassword() ? OBFUSCATED_PSWD_STRING : entry.getValue().toString();
            builder.append(isFirst ? "?" : "&").append(key).append("=").append(value);
            isFirst = false;
        }
        return builder.toString();
    }

    public static Map<String, String> getDisplayProperties(Properties info) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            String key = entry.getKey().toString();
            ConnectionProperty connectionProperty = ConnectionProperty.getConnectionProperty(key);
            String value = connectionProperty != null && connectionProperty.isPassword() ? OBFUSCATED_PSWD_STRING : entry.getValue().toString();
            map.put(key, value);
        }
        return map;
    }

    public static Map<String, String> getDisplayProperties(ConnectionProperties connectionProperties) {
        TreeMap<String, String> map = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<ConnectionProperty, String> entry : connectionProperties.getProperties().entrySet()) {
            ConnectionProperty key = entry.getKey();
            if (key == ConnectionProperty.DBURL) continue;
            String value = key.isPassword() ? OBFUSCATED_PSWD_STRING : entry.getValue();
            map.put(key.getName(), value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _addConnection(ConnectionSapDB connection) {
        Set<ConnectionSapDB> set = CONNECTIONS;
        synchronized (set) {
            CONNECTIONS.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void _removeConnection(ConnectionSapDB connection) {
        Set<ConnectionSapDB> set = CONNECTIONS;
        synchronized (set) {
            CONNECTIONS.remove(connection);
        }
    }

    protected static synchronized void _addHeartbeatTask(String connectionToString, TimerTask timerTask, int seconds) {
        int milliseconds = seconds * 1000;
        if (_heartbeatTimer == null) {
            _heartbeatTimer = new Timer(true);
        }
        _heartbeatTimer.schedule(timerTask, milliseconds, (long)milliseconds);
    }

    protected static synchronized void _removeHeartbeatTask(String connectionToString, TimerTask timerTask) {
        timerTask.cancel();
    }

    protected static boolean _createFinalizerClass(ConnectionProperties connectionProperties) {
        return connectionProperties.getBooleanProperty(ConnectionProperty.CLOSE_HANDLES_ON_FINALIZE);
    }

    protected static boolean _createCleanerClass(ConnectionProperties connectionProperties) {
        return JAVA_VERSION >= 9 && connectionProperties.getBooleanProperty(ConnectionProperty.CLOSE_HANDLES_BY_CLEANER);
    }

    protected static boolean _createPhantomClass(ConnectionProperties connectionProperties) {
        return JAVA_VERSION < 9 && connectionProperties.getBooleanProperty(ConnectionProperty.CLOSE_HANDLES_BY_PHANTOM_REFERENCE);
    }

    protected static Tracer _initConnect(String url, Properties info, String[] outUrlPrefix, Properties[] outMergedInfo, ConnectionProperties[] outConnectionProperties, PassportListener[] outPassportListener) throws SQLException {
        Properties mergedInfo = new Properties();
        String urlPrefix = DriverSapDB._getUrlPrefixAndCanonicalProperties(url, info, mergedInfo);
        ConnectionProperties connectionProperties = new ConnectionProperties(mergedInfo);
        String passport = connectionProperties.getProperty(ConnectionProperty.PASSPORT);
        String passportComponentName = connectionProperties.getProperty(ConnectionProperty.PASSPORT_COMPONENT_NAME);
        String passportListenerClassName = connectionProperties.getProperty(ConnectionProperty.PASSPORT_LISTENER);
        PassportListener passportListener = null;
        if (!(passport == null || passport.isEmpty() || passportComponentName == null || passportComponentName.isEmpty() || passportListenerClassName == null || passportListenerClassName.isEmpty())) {
            try {
                Class<?> clas = Class.forName(passportListenerClassName);
                Object obj = clas.newInstance();
                if (!(obj instanceof PassportListener)) {
                    throw SQLExceptionSapDB.newInstance("error.passport.listener.implementation", passportListenerClassName, PassportListener.class.getCanonicalName());
                }
                passportListener = (PassportListener)obj;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.passport.listener.instantiation", passportListenerClassName);
            }
        }
        Tracer tracer = DriverSapDB._openTrace(connectionProperties);
        tracer.refreshTraceSettings();
        outUrlPrefix[0] = urlPrefix;
        outMergedInfo[0] = mergedInfo;
        outConnectionProperties[0] = connectionProperties;
        outPassportListener[0] = passportListener;
        return tracer;
    }

    protected static Connection _connect(String urlPrefix, Properties mergedInfo, ConnectionProperties connectionProperties, PassportListener passportListener, Tracer tracer) throws SQLException {
        ConnectionSapDB connection;
        if (!DriverSapDB._acceptsURL(urlPrefix)) {
            return null;
        }
        SiteType siteType = SiteType.decode(connectionProperties.getProperty(ConnectionProperty.SITE_TYPE));
        boolean ignoreTopology = connectionProperties.getBooleanProperty(ConnectionProperty.IGNORE_TOPOLOGY);
        boolean deferredPrepare = connectionProperties.getBooleanProperty(ConnectionProperty.DEFERRED_PREPARE);
        boolean routeDirectExecute = connectionProperties.getBooleanProperty(ConnectionProperty.ROUTE_DIRECT_EXECUTE);
        String distribution = connectionProperties.getProperty(ConnectionProperty.DISTRIBUTION, "").trim();
        if ((siteType == SiteType.PRIMARY || siteType == SiteType.SECONDARY) && ignoreTopology) {
            throw SQLExceptionSapDB.newInstance("error.connection.invalidproperties", "siteType=PRIMARY|SECONDARY", "ignoreTopology=TRUE");
        }
        if (deferredPrepare && routeDirectExecute) {
            throw SQLExceptionSapDB.newInstance("error.connection.invalidproperties", "deferredPrepare=TRUE", "routeDirectExecute=TRUE");
        }
        if (deferredPrepare && (distribution.equalsIgnoreCase("STATEMENT") || distribution.equalsIgnoreCase("ALL"))) {
            throw SQLExceptionSapDB.newInstance("error.connection.invalidproperties", "deferredPrepare=TRUE", "distribution=STATEMENT|ALL");
        }
        for (ConnectionProperty connectionProperty : new ConnectionProperty[]{ConnectionProperty.APPLICATION, ConnectionProperty.APPLICATIONUSER}) {
            String value = ConnectionSapDB._getSessionVariableFromProperties(connectionProperty.getName(), mergedInfo);
            if (value == null || value.isEmpty()) continue;
            connectionProperties.setProperty(connectionProperty, value);
        }
        SecureStoreLoginInformation loginInfo = DriverSapDB._getLoginInfoFromSecureStore(tracer, connectionProperties);
        if (loginInfo != null) {
            urlPrefix = DriverSapDB.buildURL(loginInfo.getAddress(), null);
            connectionProperties.setProperty(ConnectionProperty.USER, loginInfo.getUsername());
            connectionProperties.setProperty(ConnectionProperty.PASSWD, loginInfo.getPasswd());
            String databaseName = loginInfo.getDatabaseName();
            if (databaseName != null && !databaseName.trim().isEmpty()) {
                connectionProperties.setProperty(ConnectionProperty.DATABASE_NAME, databaseName);
            }
        }
        try {
            List<PreferredAddress> preferredAddresses = DriverSapDB._getPreferredAddresses(tracer, urlPrefix, connectionProperties);
            connection = Driver._createConnection(tracer, mergedInfo, connectionProperties, passportListener, preferredAddresses);
            connection._connectAnchor(false, null);
        }
        catch (RTEException e) {
            throw SQLExceptionSapDB.newInstance(e.getCause(), "error.connect.rteexception", "", e.getDetailErrorCode(), 0, e.getRTEReturnCode(), SQLExceptionSapDB.NO_UPDATE_COUNTS, urlPrefix, e.getMessage());
        }
        if (tracer.isForOneConnection()) {
            tracer.setConnection(connection);
        }
        return connection;
    }

    protected static String _getUrlPrefixAndCanonicalProperties(String url, Properties input, Properties output) {
        String urlPrefix;
        int idx;
        if (url != null && (idx = url.indexOf(63)) != -1) {
            urlPrefix = url.substring(0, idx);
            for (String arg : url.substring(idx + 1).split("&")) {
                idx = arg.indexOf(61);
                if (idx == -1) continue;
                String name = arg.substring(0, idx);
                String value = arg.substring(idx + 1);
                output.setProperty(ConnectionProperty.getCanonicalName(name), value);
            }
        } else {
            urlPrefix = url;
        }
        String[] stringArray = input.entrySet().iterator();
        while (stringArray.hasNext()) {
            Map.Entry<Object, Object> object;
            Map.Entry<Object, Object> entry = object = stringArray.next();
            Object key = entry.getKey();
            Object val = entry.getValue();
            output.put(key instanceof String ? ConnectionProperty.getCanonicalName((String)key) : key, val);
        }
        return urlPrefix;
    }

    protected static List<PreferredAddress> _getPreferredAddresses(Tracer tracer, String url, ConnectionProperties connectionProperties) throws RTEException {
        if (!url.startsWith(PROTOCOL_NAME)) {
            throw RTEException.newInstance(tracer, null, "Invalid URL: " + DriverSapDB.getDisplayUrl(url), RteReturnCode.SQLNOTOK, -708);
        }
        String addresses = DriverSapDB.getAddresses(url);
        String portOverrideString = connectionProperties.getProperty(ConnectionProperty.PORT_OVERRIDE);
        String instanceNumberString = connectionProperties.getProperty(ConnectionProperty.INSTANCE_NUMBER);
        String databaseName = connectionProperties.getProperty(ConnectionProperty.DATABASE_NAME);
        int instanceNumber = -1;
        int overriddenPort = -1;
        int defaultPort = -1;
        boolean isEncryptionDefault = false;
        connectionProperties.setProperty(ConnectionProperty.DBURL, DriverSapDB.buildURL(addresses, connectionProperties));
        if (portOverrideString != null && !portOverrideString.isEmpty()) {
            try {
                overriddenPort = Integer.parseInt(portOverrideString);
            }
            catch (NumberFormatException e) {
                throw RTEException.newInstance(tracer, null, "Invalid portOverride value: " + portOverrideString, RteReturnCode.SQLNOTOK, -708, e);
            }
        }
        if (instanceNumberString != null && !instanceNumberString.isEmpty()) {
            try {
                instanceNumber = Integer.parseInt(instanceNumberString);
            }
            catch (NumberFormatException e) {
                throw RTEException.newInstance(tracer, null, "Invalid instance number: " + instanceNumberString, RteReturnCode.SQLNOTOK, -708, e);
            }
            defaultPort = instanceNumber * 100 + (databaseName == null || databaseName.isEmpty() ? 30015 : 30013);
        }
        ArrayList<PreferredAddress> preferredAddresses = new ArrayList<PreferredAddress>();
        for (String address : addresses.split(";")) {
            int port;
            NetworkAddress networkAddress = NetworkAddress.newInstance(tracer, address);
            String networkHost = networkAddress.getHost();
            Integer networkPort = networkAddress.getPort();
            if (overriddenPort != -1) {
                port = overriddenPort;
            } else if (networkPort != null) {
                port = networkPort;
                if (instanceNumber != -1 && instanceNumber != port % 10000 / 100) {
                    throw RTEException.newInstance(tracer, null, "Ambiguous port number: Instance number " + instanceNumber + " conflicts with port " + port, RteReturnCode.SQLNOTOK, -708);
                }
                if (port == 443) {
                    isEncryptionDefault = true;
                }
            } else if (defaultPort != -1) {
                port = defaultPort;
            } else {
                throw RTEException.newInstance(tracer, null, "Invalid address, missing port number: " + address, RteReturnCode.SQLNOTOK, -708);
            }
            preferredAddresses.add(new PreferredAddress(networkHost, port));
        }
        if (isEncryptionDefault && !connectionProperties.hasProperty(ConnectionProperty.ENCRYPT)) {
            connectionProperties.setProperty(ConnectionProperty.ENCRYPT, "true");
        }
        return preferredAddresses;
    }

    private static SQLException _getUnsupportedMethodException(String methodSignature) {
        return SQLExceptionSapDB.newInstance("error.method.unsupported", methodSignature, "Driver");
    }

    private static void _showTraceSettings(boolean toConsole) {
        if (toConsole) {
            new TraceConfiguration().printTraceSettings();
        } else {
            TraceTool.showWindow();
        }
    }

    private static void _printUsage(String message) {
        DriverSapDB._printUsage(message, null, 0);
    }

    private static void _printUsage(String message, String arg) {
        DriverSapDB._printUsage(message, new String[]{arg}, 0);
    }

    private static void _printUsage(String message, String[] args, int firstArg) {
        if (message != null) {
            if (args != null) {
                StringBuilder builder = new StringBuilder();
                builder.append(message);
                int n = args.length;
                for (int i = firstArg; i < n; ++i) {
                    builder.append(' ').append(args[i]);
                }
                System.err.println(builder);
            } else {
                System.err.println(message);
            }
            System.err.println();
        }
        System.out.println("Usage: java -jar ngdbc.jar -h | --help | HELP\n         to show this message.\n\n   or  java -jar ngdbc.jar -v | --version | VERSION\n         to show the version information.\n\n   or  java -jar ngdbc.jar -g | --gui | GUI\n         to run a GUI tool to configure trace settings.\n\n   or  java -jar ngdbc.jar -u <user,password>\n         [-n <host-name>[:<port>]]\n         [-d <database-name>]\n         [-i <instance-number>]\n         [-o <connect-option-name>=<connect-option-value>]\n         [-c <sql-command>]\n         to check whether a connection can be established or to execute\n         a command.\n\n   or  java -jar ngdbc.jar -k <key>\n         [-o <connect-option-name>=<connect-option-value>]\n         [-c <sql-command>]\n         to check whether a connection can be established or to execute\n         a command.\n\n   or  java -jar ngdbc.jar <command>\n         Commands:\n           TRACE ON | OFF\n             Enables/disables trace.\n           TRACE FILENAME <filename>\n             Sets the name of the trace file. The driver adds a unique\n             suffix to the trace file name.\n           TRACE CONNECTIONS ON | OFF\n             Enables/disables trace of connects and disconnects.\n           TRACE API ON | OFF\n             Enables/disables JDBC API trace.\n           TRACE PACKET ON | OFF\n             Enables/disables trace of communication packets.\n           TRACE DISTRIBUTION ON | OFF\n             Enables/disables trace of distribution features.\n           TRACE STATISTICS ON | OFF\n             Enables/disables trace of sent/received packet/byte counts.\n           TRACE CLEANERS ON | OFF\n             Enables/disables trace of cleaners/finalizers for connections, statements, and result sets.\n           TRACE DEBUG ON | OFF\n             Enables/disables trace of debug messages.\n           TRACE SHOW PLAINTEXTCSE ON | OFF\n             Enables/disables trace of client-side encrypted values in plain-text.\n           TRACE SHOW TIMESTAMPS ON | OFF\n             Enables/disables timestamps for each trace record.\n           TRACE SHOW ELAPSEDTIMES ON | OFF\n             Enables/disables elapsed times for each JDBC API call and communication packet.\n           TRACE SIZE <size> [KB | MB | GB] | UNLIMITED\n             Limits the size of the trace file to <size>. Minimum size\n             is 8192 bytes.\n           TRACE STOP ON ERROR <error> | OFF\n             Stops tracing after the error <error> is encountered or\n             switches the trace stop feature off.\n           TRACE FAILURE ACTION IGNORE | STDOUT | STDERR | EXCEPTION\n             Selects the action in the event of a failure to open or write to the trace file.\n           PERFORMANCETRACE ON | OFF\n             Enables/disables performance trace.\n           PERFORMANCETRACE FILENAME\n             Sets the name of the performance trace file. The driver\n             adds a unique suffix to the trace file name.\n           SHOW [ALL | TRACESETTINGS]\n             Displays the current trace settings.");
        System.exit(1);
    }

    private static boolean _acceptsURL(String url) {
        return url != null && url.startsWith(PROTOCOL_NAME);
    }

    private static Tracer _openTrace(ConnectionProperties connectionProperties) {
        Tracer tracer = null;
        boolean isUsingLegacySupport = false;
        boolean isUsingNewSupport = false;
        String traceFileName = connectionProperties.getProperty(ConnectionProperty.TRACE);
        if (traceFileName != null && !traceFileName.isEmpty()) {
            tracer = SETTINGS_FILE_TRACER;
            isUsingLegacySupport = true;
        } else {
            traceFileName = connectionProperties.getProperty(ConnectionProperty.CONNECTION_TRACE);
            if (traceFileName != null && !traceFileName.isEmpty()) {
                tracer = new Tracer(true);
                isUsingLegacySupport = true;
            }
        }
        if (isUsingLegacySupport) {
            String maxTraceSize = connectionProperties.getProperty(ConnectionProperty.TRACE_SIZE);
            boolean wasTraceFileNameChanged = tracer.setTraceFileName(traceFileName);
            boolean wasMaxTraceSizeChanged = tracer.setTraceSize(maxTraceSize);
            if (wasTraceFileNameChanged || wasMaxTraceSizeChanged) {
                tracer.switchTraceOff();
            }
            tracer.switchTraceOn();
            return tracer;
        }
        boolean traceDisabled = connectionProperties.getBooleanProperty(ConnectionProperty.TRACE_DISABLED);
        if (traceDisabled) {
            return Tracer.getDummyTracer();
        }
        String traceOptions = connectionProperties.getProperty(ConnectionProperty.TRACE_OPTIONS);
        if (traceOptions != null && !traceOptions.isEmpty()) {
            String traceListener = connectionProperties.getProperty(ConnectionProperty.TRACE_LISTENER);
            if (traceListener != null && !traceListener.isEmpty()) {
                tracer = new Tracer(true, false, traceListener, null, traceOptions);
                tracer.switchTraceOn();
                isUsingNewSupport = true;
            } else {
                String traceFile = connectionProperties.getProperty(ConnectionProperty.TRACE_FILE);
                if (traceFile != null && !traceFile.isEmpty()) {
                    tracer = new Tracer(true, false, null, traceFile, traceOptions);
                    tracer.switchTraceOn();
                    isUsingNewSupport = true;
                }
            }
        } else if (ENVIRONMENT_VARIABLE_TRACER != null) {
            tracer = ENVIRONMENT_VARIABLE_TRACER;
            tracer.switchTraceOn();
            isUsingNewSupport = true;
        }
        if (isUsingNewSupport) {
            return tracer;
        }
        return SETTINGS_FILE_TRACER;
    }

    private static SecureStoreLoginInformation _getLoginInfoFromSecureStore(Tracer tracer, ConnectionProperties connectionProperties) throws SQLException {
        SecureStoreLoginInformation loginInfo;
        String key = connectionProperties.getProperty(ConnectionProperty.KEY);
        if (key == null || key.trim().isEmpty()) {
            return null;
        }
        String virtualHostName = connectionProperties.getProperty(ConnectionProperty.VIRTUAL_HOST_NAME);
        if ((virtualHostName == null || virtualHostName.trim().isEmpty()) && ((virtualHostName = System.getenv("SAPLOCALHOST")) == null || virtualHostName.trim().isEmpty())) {
            String path = Driver.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            int index = path.lastIndexOf("ngdbc.jar");
            if (index != -1) {
                virtualHostName = SecureStore.getVirtualHostNameFromIniFile(path.substring(0, index));
                if (tracer.on()) {
                    tracer.printDebugMessage("The jar location is " + virtualHostName);
                }
            } else {
                virtualHostName = "";
            }
        }
        if (tracer.on()) {
            tracer.printDebugMessage("The Secure Store key is ***\nThe Virtual Hostname is " + virtualHostName);
        }
        if ((loginInfo = SecureStore.getLoginInformation(tracer, key, virtualHostName)) == null) {
            throw SQLExceptionSapDB.newInstance("error.connection.securestorenulllogin", new String[0]);
        }
        return loginInfo;
    }

    private static DriverPropertyInfo[] _getPropertyInfo(Properties info) {
        DriverPropertyInfo propertyInfo;
        ArrayList<DriverPropertyInfo> propertyInfos = new ArrayList<DriverPropertyInfo>();
        if (info.getProperty(ConnectionProperty.USER.getName()) == null) {
            propertyInfo = new DriverPropertyInfo(ConnectionProperty.USER.getName(), null);
            propertyInfo.required = true;
            propertyInfos.add(propertyInfo);
        }
        if (info.getProperty(ConnectionProperty.PASSWD.getName()) == null) {
            propertyInfo = new DriverPropertyInfo(ConnectionProperty.PASSWD.getName(), null);
            propertyInfo.required = true;
            propertyInfos.add(propertyInfo);
        }
        return propertyInfos.toArray(new DriverPropertyInfo[0]);
    }

    private static TraceRecord _newTraceRecord(String methodName) {
        return new TraceRecord(null, null, null, "Driver", methodName);
    }

    private static void _publish(TraceRecord r) {
        r.update(null);
        TraceRecordPublisher.getInstance().publish(r);
    }

    static {
        int pos;
        SETTINGS_FILE_TRACER = new Tracer(false);
        String traceOptions = System.getenv("HDB_JDBC_TRACEOPTIONS");
        Tracer environmentVariableTracer = null;
        if (traceOptions != null && !traceOptions.isEmpty()) {
            String traceListener = System.getenv("HDB_JDBC_TRACELISTENER");
            if (traceListener != null && !traceListener.isEmpty()) {
                environmentVariableTracer = new Tracer(false, false, traceListener, null, traceOptions);
            } else {
                String traceFile = System.getenv("HDB_JDBC_TRACEFILE");
                if (traceFile != null && !traceFile.isEmpty()) {
                    environmentVariableTracer = new Tracer(false, false, null, traceFile, traceOptions);
                }
            }
        }
        ENVIRONMENT_VARIABLE_TRACER = environmentVariableTracer;
        String computerName = null;
        String fullComputerName = null;
        int javaVersion = 7;
        int processID = 0;
        try {
            computerName = InetAddress.getLocalHost().getHostName();
            pos = computerName.indexOf(46);
            if (pos != -1) {
                computerName = computerName.substring(0, pos);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        COMPUTER_NAME = computerName;
        try {
            fullComputerName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        FULL_COMPUTER_NAME = fullComputerName;
        try {
            String javaSpecificationVersion = System.getProperty("java.specification.version");
            if (javaSpecificationVersion != null) {
                String[] components = javaSpecificationVersion.split(Pattern.quote("."));
                javaVersion = components.length >= 2 ? Integer.parseInt(components[1]) : Integer.parseInt(javaSpecificationVersion);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        JAVA_VERSION = javaVersion;
        try {
            String name = ManagementFactory.getRuntimeMXBean().getName();
            pos = name.indexOf(64);
            if (pos != -1) {
                processID = Integer.parseInt(name.substring(0, pos));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        PROCESS_ID = processID;
        CONNECTIONS = Collections.newSetFromMap(new WeakHashMap());
        VERSION_INFO = DriverVersionInfo.newInstance(Driver.class.getPackage().toString());
        PROTOCOL_NAME_LENGTH = PROTOCOL_NAME.length();
    }
}

