/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.grpc.contrib.xfcc;

import java.util.ArrayList;
import java.util.List;

final class XfccQuoteUtil {
    private XfccQuoteUtil() {
    }

    static List<String> quoteAwareSplit(String str, char delim) {
        boolean inQuotes = false;
        boolean inEscape = false;
        ArrayList<String> elements = new ArrayList<String>();
        StringBuilder buffer = new StringBuilder();
        for (char c : str.toCharArray()) {
            if (c == delim && !inQuotes) {
                elements.add(buffer.toString());
                buffer.setLength(0);
                inEscape = false;
                continue;
            }
            if (c == '\"') {
                if (inQuotes) {
                    if (!inEscape) {
                        inQuotes = false;
                    }
                } else {
                    inQuotes = true;
                }
                inEscape = false;
                buffer.append(c);
                continue;
            }
            if (c == '\\' && !inEscape) {
                inEscape = true;
                buffer.append(c);
                continue;
            }
            inEscape = false;
            buffer.append(c);
        }
        if (inQuotes) {
            throw new RuntimeException("Quoted string not closed");
        }
        elements.add(buffer.toString());
        return elements;
    }

    static String enquote(String value) {
        if ((value = value.replace("\"", "\\\"")).contains(",") || value.contains(";") || value.contains("=")) {
            value = "\"" + value + "\"";
        }
        return value;
    }

    static String dequote(String str) {
        if ((str = str.replace("\\\"", "\"")).startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

