/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs.canteen;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionErrorHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.io.FileUtils;

@Mojo(name="bootstrap", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class BootstrapMojo
extends AbstractMojo {
    private static final String CANTEEN_BOOTSTRAP = "canteen-bootstrap";
    private static final List<String> PLATFORMS = Arrays.asList("osx-x86_64", "osx-aarch_64", "linux-x86_64", "linux-aarch_64", "windows-x86_64");
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ResolutionErrorHandler resolutionErrorHandler;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Parameter(required=true, readonly=true, property="localRepository")
    private ArtifactRepository localRepository;
    @Parameter(required=true, readonly=true, defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", readonly=true)
    private String finalName;
    @Parameter(required=true, defaultValue="${project.build.directory}/canteen-bootstrap")
    private File canteenBootstrapDirectory;
    @Parameter(required=false)
    private String classifier;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (String platform : PLATFORMS) {
            Artifact bootstrapArtifact = this.createDependencyArtifact(this.plugin.getGroupId(), CANTEEN_BOOTSTRAP, this.plugin.getVersion(), "exe", platform);
            File bootstrapFile = this.resolveBinaryArtifact(bootstrapArtifact);
            Artifact sourceArtifact = this.getSourceArtifact();
            File targetFile = this.getTargetFile(platform);
            try (FileOutputStream targetStream = new FileOutputStream(targetFile);){
                try (FileInputStream bootstrapStream = new FileInputStream(bootstrapFile);){
                    ByteStreams.copy((InputStream)bootstrapStream, (OutputStream)targetStream);
                }
                try (FileInputStream sourceStream = new FileInputStream(sourceArtifact.getFile());){
                    ByteStreams.copy((InputStream)sourceStream, (OutputStream)targetStream);
                }
                targetStream.flush();
            }
            catch (IOException ex) {
                throw new MojoFailureException("Failed to write bootstrapped jar", (Throwable)ex);
            }
            if (!Os.isFamily((String)"windows")) {
                targetFile.setExecutable(true);
            }
            this.projectHelper.attachArtifact(this.project, "exe", platform, targetFile);
        }
    }

    private Artifact createDependencyArtifact(String groupId, String artifactId, String version, String type, String classifier) {
        Dependency dependency = new Dependency();
        dependency.setGroupId(groupId);
        dependency.setArtifactId(artifactId);
        dependency.setVersion(version);
        dependency.setType(type);
        dependency.setClassifier(classifier);
        dependency.setScope("runtime");
        return this.repositorySystem.createDependencyArtifact(dependency);
    }

    private File resolveBinaryArtifact(Artifact artifact) throws MojoExecutionException {
        ArtifactResolutionResult result;
        try {
            ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(this.project.getArtifact()).setResolveRoot(false).setResolveTransitively(false).setArtifactDependencies(Collections.singleton(artifact)).setManagedVersionMap(Collections.emptyMap()).setLocalRepository(this.localRepository).setRemoteRepositories(this.remoteRepositories).setOffline(this.session.isOffline()).setForceUpdate(this.session.getRequest().isUpdateSnapshots()).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies());
            result = this.repositorySystem.resolve(request);
            this.resolutionErrorHandler.throwErrors(request, result);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        Set artifacts = result.getArtifacts();
        if (artifacts == null || artifacts.isEmpty()) {
            throw new MojoExecutionException("Unable to resolve artifact");
        }
        Artifact resolvedBinaryArtifact = (Artifact)artifacts.iterator().next();
        this.getLog().debug((CharSequence)("Resolved artifact: " + resolvedBinaryArtifact));
        File sourceFile = resolvedBinaryArtifact.getFile();
        String sourceFileName = sourceFile.getName();
        String targetFileName = Os.isFamily((String)"windows") && !sourceFileName.endsWith(".exe") ? sourceFileName + ".exe" : sourceFileName;
        File targetFile = new File(this.canteenBootstrapDirectory, targetFileName);
        if (targetFile.exists()) {
            this.getLog().debug((CharSequence)("Executable file already exists: " + targetFile.getAbsolutePath()));
            return targetFile;
        }
        try {
            FileUtils.forceMkdir((File)this.canteenBootstrapDirectory);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to create directory " + this.canteenBootstrapDirectory, (Exception)e);
        }
        try {
            FileUtils.copyFile((File)sourceFile, (File)targetFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to copy the file to " + this.canteenBootstrapDirectory, (Exception)e);
        }
        this.getLog().debug((CharSequence)("Executable file resolved: " + targetFile.getAbsolutePath()));
        return targetFile;
    }

    private Artifact getSourceArtifact() {
        Artifact sourceArtifact = this.getArtifact(this.classifier);
        return sourceArtifact != null ? sourceArtifact : this.project.getArtifact();
    }

    private Artifact getArtifact(String classifier) {
        if (classifier != null) {
            for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
                if (!classifier.equals(attachedArtifact.getClassifier()) || attachedArtifact.getFile() == null || !attachedArtifact.getFile().isFile()) continue;
                return attachedArtifact;
            }
        }
        return null;
    }

    private File getTargetFile(String classifier) {
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        return new File(this.outputDirectory, this.finalName + "-" + classifier + ".exe");
    }
}

