/*
 * Decompiled with CFR 0.152.
 */
package com.force.db.i18n;

import com.force.db.i18n.OracleUpper;
import java.util.Locale;

public enum OracleUpperTable {
    ENGLISH("upper(%s)", "en", "\u00df"),
    GERMAN("nls_upper(%s, 'nls_sort=xgerman')", "de", ""),
    FRENCH("nls_upper(%s, 'nls_sort=xfrench')", "fr", "\u00df"),
    ITALIAN("nls_upper(%s, 'nls_sort=italian')", "it", "\u00df"),
    SPANISH("nls_upper(%s, 'nls_sort=spanish')", "es", "\u00df"),
    CATALAN("nls_upper(%s, 'nls_sort=catalan')", "ca", "\u00df"),
    DUTCH("nls_upper(%s, 'nls_sort=dutch')", "nl", "\u00df"),
    PORTUGUESE("nls_upper(%s, 'nls_sort=west_european')", "pt", "\u00df"),
    DANISH("nls_upper(%s, 'nls_sort=danish')", "da", "\u00df"),
    NORWEGIAN("nls_upper(%s, 'nls_sort=norwegian')", "no", "\u00df"),
    SWEDISH("nls_upper(%s, 'nls_sort=swedish')", "sv", "\u00df"),
    FINNISH("nls_upper(%s, 'nls_sort=finnish')", "fi", "\u00df"),
    CZECH("nls_upper(%s, 'nls_sort=xczech')", "cs", "\u00df"),
    POLISH("nls_upper(%s, 'nls_sort=polish')", "pl", "\u00df"),
    TURKISH("nls_upper(translate(%s,'i','\u0130'), 'nls_sort=xturkish')", "tr", "\u00df"),
    CHINESE_HK("nls_upper(to_single_byte(%s), 'nls_sort=tchinese_radical_m')", "zh", ""),
    CHINESE_HK_STROKE("nls_upper(to_single_byte(%s), 'nls_sort=tchinese_stroke_m')", "zh", ""),
    CHINESE_TW("nls_upper(to_single_byte(%s), 'nls_sort=tchinese_radical_m')", "zh", ""),
    CHINESE_TW_STROKE("nls_upper(to_single_byte(%s), 'nls_sort=tchinese_stroke_m')", "zh", ""),
    CHINESE("nls_upper(to_single_byte(%s), 'nls_sort=schinese_radical_m')", "zh", ""),
    CHINESE_STROKE("nls_upper(to_single_byte(%s), 'nls_sort=schinese_stroke_m')", "zh", ""),
    CHINESE_PINYIN("nls_upper(to_single_byte(%s), 'nls_sort=schinese_pinyin_m')", "zh", ""),
    JAPANESE("nls_upper(to_single_byte(%s), 'nls_sort=japanese_m')", "ja", ""),
    KOREAN("nls_upper(to_single_byte(%s), 'nls_sort=korean_m')", "ko", ""),
    RUSSIAN("nls_upper(%s, 'nls_sort=russian')", "ru", "\u00df"),
    BULGARIAN("nls_upper(%s, 'nls_sort=bulgarian')", "bg", "\u00df"),
    INDONESIAN("nls_upper(%s, 'nls_sort=indonesian')", "in", "\u00df"),
    ROMANIAN("nls_upper(%s, 'nls_sort=romanian')", "ro", "\u00df"),
    VIETNAMESE("nls_upper(%s, 'nls_sort=vietnamese')", "vi", "\u00df"),
    UKRANIAN("nls_upper(%s, 'nls_sort=ukrainian')", "uk", "\u00df"),
    HUNGARIAN("nls_upper(%s, 'nls_sort=xhungarian')", "hu", ""),
    GREEK("nls_upper(%s, 'nls_sort=greek')", "el", "\u00df\u0386\u0388\u0389\u038a\u038c\u038e\u038f\u03ac\u03ad\u03ae\u03af\u03cc\u03cd\u03ce"),
    HEBREW("nls_upper(%s, 'nls_sort=hebrew')", "iw", "\u00df"),
    SLOVAK("nls_upper(%s, 'nls_sort=slovak')", "sk", "\u00df"),
    SERBIAN_CYRILLIC("nls_upper(%s, 'nls_sort=generic_m')", "sr", ""),
    SERBIAN_LATIN("nls_upper(%s, 'nls_sort=xcroatian')", "sh", "\u00df"),
    BOSNIAN("nls_upper(%s, 'nls_sort=xcroatian')", "bs", "\u00df"),
    GEORGIAN("nls_upper(%s, 'nls_sort=binary')", "ka", "\u00df"),
    BASQUE("nls_upper(%s, 'nls_sort=west_european')", "eu", "\u00df"),
    MALTESE("nls_upper(%s, 'nls_sort=west_european')", "mt", "\u00df"),
    ROMANSH("nls_upper(%s, 'nls_sort=west_european')", "rm", "\u00df"),
    LUXEMBOURGISH("nls_upper(%s, 'nls_sort=west_european')", "lb", "\u00df"),
    IRISH("nls_upper(%s, 'nls_sort=west_european')", "ga", "\u00df"),
    SLOVENE("nls_upper(%s, 'nls_sort=xslovenian')", "sl", "\u00df"),
    CROATIAN("nls_upper(%s, 'nls_sort=xcroatian')", "hr", "\u00df"),
    MALAY("nls_upper(%s, 'nls_sort=malay')", "ms", "\u00df"),
    ARABIC("nls_upper(%s, 'nls_sort=arabic')", "ar", "\u00df"),
    ESTONIAN("nls_upper(%s, 'nls_sort=estonian')", "et", "\u00df"),
    ICELANDIC("nls_upper(%s, 'nls_sort=icelandic')", "is", "\u00df"),
    LATVIAN("nls_upper(%s, 'nls_sort=latvian')", "lv", "\u00df"),
    LITHUANIAN("nls_upper(%s, 'nls_sort=lithuanian')", "lt", "\u00df"),
    KYRGYZ("nls_upper(%s, 'nls_sort=binary')", "ky", "\u00df"),
    KAZAKH("nls_upper(%s, 'nls_sort=binary')", "kk", "\u00df"),
    TAJIK("nls_upper(%s, 'nls_sort=russian')", "tg", "\u00df"),
    BELARUSIAN("nls_upper(%s, 'nls_sort=russian')", "be", "\u00df"),
    TURKMEN("nls_upper(translate(%s,'i','\u0130'), 'nls_sort=xturkish')", "tk", "i\u00df"),
    AZERBAIJANI("nls_upper(translate(%s,'i','\u0130'), 'nls_sort=xturkish')", "az", "\u00df"),
    ARMENIAN("nls_upper(%s, 'nls_sort=binary')", "hy", "\u00df"),
    THAI("nls_upper(%s, 'nls_sort=thai_dictionary')", "th", "\u00df"),
    HINDI("nls_upper(%s, 'nls_sort=binary')", "hi", "\u00df"),
    URDU("nls_upper(%s, 'nls_sort=arabic')", "ur", "\u00df"),
    BENGALI("nls_upper(%s, 'nls_sort=bengali')", "bn", "\u00df"),
    TAMIL("nls_upper(%s, 'nls_sort=binary')", "ta", "\u00df"),
    ESPERANTO("upper(%s)", "eo", ""),
    XWEST_EUROPEAN("NLS_UPPER(%s,'NLS_SORT=xwest_european')", "en", "");

    private final String sql;
    private final Locale locale;
    private final char[] exceptionChars;

    private OracleUpperTable(String sql, String lang, String exceptionChars) {
        this.sql = sql;
        this.locale = new Locale(lang);
        this.exceptionChars = exceptionChars.toCharArray();
    }

    final char[] getUpperCaseExceptions() {
        return this.exceptionChars;
    }

    final String getUpperCaseExceptionMapping(char exception) {
        switch (exception) {
            case 'i': {
                switch (this) {
                    case TURKMEN: {
                        return "\u0130";
                    }
                }
                break;
            }
            case '\u00df': {
                switch (this) {
                    case ENGLISH: {
                        return "\u00df";
                    }
                    case FRENCH: {
                        return "\u00df";
                    }
                    case ITALIAN: {
                        return "\u00df";
                    }
                    case SPANISH: {
                        return "\u00df";
                    }
                    case CATALAN: {
                        return "\u00df";
                    }
                    case DUTCH: {
                        return "\u00df";
                    }
                    case PORTUGUESE: {
                        return "\u00df";
                    }
                    case DANISH: {
                        return "\u00df";
                    }
                    case NORWEGIAN: {
                        return "\u00df";
                    }
                    case SWEDISH: {
                        return "\u00df";
                    }
                    case FINNISH: {
                        return "\u00df";
                    }
                    case CZECH: {
                        return "\u00df";
                    }
                    case POLISH: {
                        return "\u00df";
                    }
                    case TURKISH: {
                        return "\u00df";
                    }
                    case RUSSIAN: {
                        return "\u00df";
                    }
                    case BULGARIAN: {
                        return "\u00df";
                    }
                    case INDONESIAN: {
                        return "\u00df";
                    }
                    case ROMANIAN: {
                        return "\u00df";
                    }
                    case VIETNAMESE: {
                        return "\u00df";
                    }
                    case UKRANIAN: {
                        return "\u00df";
                    }
                    case GREEK: {
                        return "\u00df";
                    }
                    case HEBREW: {
                        return "\u00df";
                    }
                    case SLOVAK: {
                        return "\u00df";
                    }
                    case SERBIAN_LATIN: {
                        return "\u00df";
                    }
                    case BOSNIAN: {
                        return "\u00df";
                    }
                    case GEORGIAN: {
                        return "\u00df";
                    }
                    case BASQUE: {
                        return "\u00df";
                    }
                    case MALTESE: {
                        return "\u00df";
                    }
                    case ROMANSH: {
                        return "\u00df";
                    }
                    case LUXEMBOURGISH: {
                        return "\u00df";
                    }
                    case IRISH: {
                        return "\u00df";
                    }
                    case SLOVENE: {
                        return "\u00df";
                    }
                    case CROATIAN: {
                        return "\u00df";
                    }
                    case MALAY: {
                        return "\u00df";
                    }
                    case ARABIC: {
                        return "\u00df";
                    }
                    case ESTONIAN: {
                        return "\u00df";
                    }
                    case ICELANDIC: {
                        return "\u00df";
                    }
                    case LATVIAN: {
                        return "\u00df";
                    }
                    case LITHUANIAN: {
                        return "\u00df";
                    }
                    case KYRGYZ: {
                        return "\u00df";
                    }
                    case KAZAKH: {
                        return "\u00df";
                    }
                    case TAJIK: {
                        return "\u00df";
                    }
                    case BELARUSIAN: {
                        return "\u00df";
                    }
                    case TURKMEN: {
                        return "\u00df";
                    }
                    case AZERBAIJANI: {
                        return "\u00df";
                    }
                    case ARMENIAN: {
                        return "\u00df";
                    }
                    case THAI: {
                        return "\u00df";
                    }
                    case HINDI: {
                        return "\u00df";
                    }
                    case URDU: {
                        return "\u00df";
                    }
                    case BENGALI: {
                        return "\u00df";
                    }
                    case TAMIL: {
                        return "\u00df";
                    }
                }
                break;
            }
            case '\u0386': {
                switch (this) {
                    case GREEK: {
                        return "\u0391";
                    }
                }
                break;
            }
            case '\u0388': {
                switch (this) {
                    case GREEK: {
                        return "\u0395";
                    }
                }
                break;
            }
            case '\u0389': {
                switch (this) {
                    case GREEK: {
                        return "\u0397";
                    }
                }
                break;
            }
            case '\u038a': {
                switch (this) {
                    case GREEK: {
                        return "\u0399";
                    }
                }
                break;
            }
            case '\u038c': {
                switch (this) {
                    case GREEK: {
                        return "\u039f";
                    }
                }
                break;
            }
            case '\u038e': {
                switch (this) {
                    case GREEK: {
                        return "\u03a5";
                    }
                }
                break;
            }
            case '\u038f': {
                switch (this) {
                    case GREEK: {
                        return "\u03a9";
                    }
                }
                break;
            }
            case '\u03ac': {
                switch (this) {
                    case GREEK: {
                        return "\u0391";
                    }
                }
                break;
            }
            case '\u03ad': {
                switch (this) {
                    case GREEK: {
                        return "\u0395";
                    }
                }
                break;
            }
            case '\u03ae': {
                switch (this) {
                    case GREEK: {
                        return "\u0397";
                    }
                }
                break;
            }
            case '\u03af': {
                switch (this) {
                    case GREEK: {
                        return "\u0399";
                    }
                }
                break;
            }
            case '\u03cc': {
                switch (this) {
                    case GREEK: {
                        return "\u039f";
                    }
                }
                break;
            }
            case '\u03cd': {
                switch (this) {
                    case GREEK: {
                        return "\u03a5";
                    }
                }
                break;
            }
            case '\u03ce': {
                switch (this) {
                    case GREEK: {
                        return "\u03a9";
                    }
                }
            }
        }
        throw new IllegalArgumentException("No upper case mapping for char=" + exception + " and this=" + (Object)((Object)this));
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public String getSqlFormatString() {
        return this.sql;
    }

    public String getSql(String expr) {
        return String.format(this.sql, expr);
    }

    public String toUpperCase(String value) {
        return OracleUpper.toUpperCase(this, value);
    }

    public static final OracleUpperTable forLinguisticSort(String sort) {
        return Enum.valueOf(OracleUpperTable.class, sort);
    }
}

