/*
 * Decompiled with CFR 0.152.
 */
package com.rudikershaw.gitbuildhook;

import com.rudikershaw.gitbuildhook.threadsafety.ClassLock;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Mojo(name="initialize", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class InitialiseMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="gitbuildhook.init.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping");
            return;
        }
        if (!this.isGitRepoInitialised()) {
            this.initialiseGitRepository();
        } else {
            this.getLog().info((CharSequence)"A Git repository is already initialized.");
        }
    }

    private boolean isGitRepoInitialised() {
        FileRepositoryBuilder repoBuilder = new FileRepositoryBuilder();
        repoBuilder.findGitDir(this.project.getBasedir());
        return repoBuilder.getGitDir() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseGitRepository() throws MojoFailureException {
        try {
            Class<ClassLock> clazz = ClassLock.class;
            synchronized (ClassLock.class) {
                Git.init().setDirectory(this.project.getBasedir()).call();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (GitAPIException e) {
            if (!this.isGitRepoInitialised()) {
                throw new MojoFailureException("Could not initialise a local git repository.", (Throwable)e);
            }
            this.getLog().warn((CharSequence)"Tried to initialize a Git repository, but a repository already exists.");
        }
        {
            return;
        }
    }
}

