/*
 * Decompiled with CFR 0.152.
 */
package com.relevantcodes.extentreports;

import com.relevantcodes.extentreports.LogStatus;
import com.relevantcodes.extentreports.model.Log;
import com.relevantcodes.extentreports.model.Test;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogCounts {
    private int pass = 0;
    private int fail = 0;
    private int fatal = 0;
    private int error = 0;
    private int warning = 0;
    private int info = 0;
    private int skip = 0;
    private int unknown = 0;

    public HashMap<LogStatus, Integer> getLogCounts(Test test) {
        Test.LogIterator iter = test.logIterator();
        while (iter.hasNext()) {
            Log log = (Log)iter.next();
            if (log.getLogStatus() == LogStatus.PASS) {
                ++this.pass;
                continue;
            }
            if (log.getLogStatus() == LogStatus.FAIL) {
                ++this.fail;
                continue;
            }
            if (log.getLogStatus() == LogStatus.FATAL) {
                ++this.fatal;
                continue;
            }
            if (log.getLogStatus() == LogStatus.ERROR) {
                ++this.error;
                continue;
            }
            if (log.getLogStatus() == LogStatus.WARNING) {
                ++this.warning;
                continue;
            }
            if (log.getLogStatus() == LogStatus.INFO) {
                ++this.info;
                continue;
            }
            if (log.getLogStatus() == LogStatus.SKIP) {
                ++this.skip;
                continue;
            }
            if (log.getLogStatus() != LogStatus.UNKNOWN) continue;
            ++this.unknown;
        }
        for (Test node : test.getNodeList()) {
            this.getLogCounts(node);
        }
        HashMap<LogStatus, Integer> logCounts = new HashMap<LogStatus, Integer>();
        logCounts.put(LogStatus.PASS, this.pass);
        logCounts.put(LogStatus.FAIL, this.fail);
        logCounts.put(LogStatus.FATAL, this.fatal);
        logCounts.put(LogStatus.ERROR, this.error);
        logCounts.put(LogStatus.WARNING, this.warning);
        logCounts.put(LogStatus.INFO, this.info);
        logCounts.put(LogStatus.SKIP, this.skip);
        logCounts.put(LogStatus.UNKNOWN, this.unknown);
        return logCounts;
    }
}

