/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class NioHelper {
    static int read(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int read = channel.read(buffer);
        if (read < 0) {
            throw new IOException("I/O thread: reached EOF");
        }
        return read;
    }

    static int retryRead(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int read = 0;
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            read = NioHelper.read(channel, buffer);
            if (read > 0) break;
        }
        return read;
    }

    static int readWithRetry(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        int bytesRead = NioHelper.read(channel, buffer);
        if (bytesRead <= 0) {
            bytesRead = NioHelper.retryRead(channel, buffer);
        }
        return bytesRead;
    }
}

