/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.test.ssl;

import com.rabbitmq.client.ConnectionFactory;
import junit.framework.TestCase;
import org.junit.Assert;

public class ConnectionFactoryDefaultTlsVersion
extends TestCase {
    private ConnectionFactory connectionFactory = new ConnectionFactory();

    public void testDefaultTlsVersionJdk16ShouldTakeFallback() {
        String[] supportedProtocols = new String[]{"SSLv2Hello", "SSLv3", "TLSv1"};
        String tlsProtocol = ConnectionFactory.computeDefaultTlsProcotol(supportedProtocols);
        Assert.assertEquals((Object)"TLSv1", (Object)tlsProtocol);
    }

    public void testDefaultTlsVersionJdk17ShouldTakePrefered() {
        String[] supportedProtocols = new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
        String tlsProtocol = ConnectionFactory.computeDefaultTlsProcotol(supportedProtocols);
        Assert.assertEquals((Object)"TLSv1.2", (Object)tlsProtocol);
    }

    public void testDefaultTlsVersionJdk18ShouldTakePrefered() {
        String[] supportedProtocols = new String[]{"SSLv2Hello", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
        String tlsProtocol = ConnectionFactory.computeDefaultTlsProcotol(supportedProtocols);
        Assert.assertEquals((Object)"TLSv1.2", (Object)tlsProtocol);
    }
}

