/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jpa.impl;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mysema.commons.lang.CloseableIterator;
import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.NonUniqueResultException;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.QueryResults;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.jpa.JPAQueryBase;
import com.querydsl.jpa.JPQLSerializer;
import com.querydsl.jpa.JPQLTemplates;
import com.querydsl.jpa.QueryHandler;
import com.querydsl.jpa.impl.JPAProvider;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractJPAQuery<T, Q extends AbstractJPAQuery<T, Q>>
extends JPAQueryBase<T, Q> {
    private static final Logger logger = LoggerFactory.getLogger(JPAQuery.class);
    protected final Multimap<String, Object> hints = LinkedHashMultimap.create();
    protected final EntityManager entityManager;
    protected final QueryHandler queryHandler;
    @Nullable
    protected LockModeType lockMode;
    @Nullable
    protected FlushModeType flushMode;
    @Nullable
    protected FactoryExpression<?> projection;

    public AbstractJPAQuery(EntityManager em) {
        this(em, JPAProvider.getTemplates(em), (QueryMetadata)new DefaultQueryMetadata());
    }

    public AbstractJPAQuery(EntityManager em, JPQLTemplates templates, QueryMetadata metadata) {
        super(metadata, templates);
        this.queryHandler = templates.getQueryHandler();
        this.entityManager = em;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fetchCount() {
        try {
            Query query = this.createQuery(null, true);
            long l = (Long)query.getSingleResult();
            return l;
        }
        finally {
            this.reset();
        }
    }

    public Query createQuery() {
        return this.createQuery(this.getMetadata().getModifiers(), false);
    }

    protected Query createQuery(@Nullable QueryModifiers modifiers, boolean forCount) {
        JPQLSerializer serializer = this.serialize(forCount);
        String queryString = serializer.toString();
        this.logQuery(queryString, serializer.getConstantToAllLabels());
        Query query = this.entityManager.createQuery(queryString);
        JPAUtil.setConstants(query, serializer.getConstantToAllLabels(), this.getMetadata().getParams());
        if (modifiers != null && modifiers.isRestricting()) {
            Integer limit = modifiers.getLimitAsInteger();
            Integer offset = modifiers.getOffsetAsInteger();
            if (limit != null) {
                query.setMaxResults(limit.intValue());
            }
            if (offset != null) {
                query.setFirstResult(offset.intValue());
            }
        }
        if (this.lockMode != null) {
            query.setLockMode(this.lockMode);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        for (Map.Entry entry : this.hints.entries()) {
            query.setHint((String)entry.getKey(), entry.getValue());
        }
        Expression projection = this.getMetadata().getProjection();
        this.projection = null;
        if (!forCount && projection instanceof FactoryExpression && !this.queryHandler.transform(query, (FactoryExpression)projection)) {
            this.projection = (FactoryExpression)projection;
        }
        return query;
    }

    private List<?> getResultList(Query query) {
        if (this.projection != null) {
            List results = query.getResultList();
            ArrayList<Object> rv = new ArrayList<Object>(results.size());
            for (Object o : results) {
                if (o != null) {
                    if (!o.getClass().isArray()) {
                        o = new Object[]{o};
                    }
                    rv.add(this.projection.newInstance((Object[])o));
                    continue;
                }
                rv.add(null);
            }
            return rv;
        }
        return query.getResultList();
    }

    @Nullable
    private Object getSingleResult(Query query) {
        if (this.projection != null) {
            Object[] result = query.getSingleResult();
            if (result != null) {
                if (!result.getClass().isArray()) {
                    result = new Object[]{result};
                }
                return this.projection.newInstance(result);
            }
            return null;
        }
        return query.getSingleResult();
    }

    public CloseableIterator<T> iterate() {
        try {
            Query query = this.createQuery();
            CloseableIterator closeableIterator = this.queryHandler.iterate(query, this.projection);
            return closeableIterator;
        }
        finally {
            this.reset();
        }
    }

    public List<T> fetch() {
        try {
            Query query = this.createQuery();
            List<?> list = this.getResultList(query);
            return list;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResults<T> fetchResults() {
        try {
            Query countQuery = this.createQuery(null, true);
            long total = (Long)countQuery.getSingleResult();
            if (total > 0L) {
                QueryModifiers modifiers = this.getMetadata().getModifiers();
                Query query = this.createQuery(modifiers, false);
                List<?> list = this.getResultList(query);
                QueryResults queryResults = new QueryResults(list, modifiers, total);
                return queryResults;
            }
            QueryResults queryResults = QueryResults.emptyResults();
            return queryResults;
        }
        finally {
            this.reset();
        }
    }

    protected void logQuery(String queryString, Map<Object, String> parameters) {
        if (logger.isDebugEnabled()) {
            String normalizedQuery = queryString.replace('\n', ' ');
            MDC.put((String)"querydsl.query", (String)normalizedQuery);
            MDC.put((String)"querydsl.parameters", (String)String.valueOf(parameters));
            logger.debug(normalizedQuery);
        }
    }

    protected void cleanupMDC() {
        MDC.remove((String)"querydsl.query");
        MDC.remove((String)"querydsl.parameters");
    }

    @Override
    protected void reset() {
        this.cleanupMDC();
    }

    @Nullable
    public T fetchOne() throws NonUniqueResultException {
        try {
            Query query = this.createQuery(this.getMetadata().getModifiers(), false);
            Object object = this.getSingleResult(query);
            return (T)object;
        }
        catch (NoResultException e) {
            logger.trace(e.getMessage(), (Throwable)e);
            T t = null;
            return t;
        }
        catch (javax.persistence.NonUniqueResultException e) {
            throw new NonUniqueResultException((Exception)((Object)e));
        }
        finally {
            this.reset();
        }
    }

    public Q setLockMode(LockModeType lockMode) {
        this.lockMode = lockMode;
        return (Q)this;
    }

    public Q setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        return (Q)this;
    }

    public Q setHint(String name, Object value) {
        this.hints.put((Object)name, value);
        return (Q)this;
    }

    @Override
    protected JPQLSerializer createSerializer() {
        return new JPQLSerializer(this.getTemplates(), this.entityManager);
    }

    protected void clone(Q query) {
        this.projection = ((AbstractJPAQuery)query).projection;
        this.flushMode = ((AbstractJPAQuery)query).flushMode;
        this.hints.putAll(((AbstractJPAQuery)query).hints);
        this.lockMode = ((AbstractJPAQuery)query).lockMode;
    }

    public abstract Q clone(EntityManager var1);

    public abstract Q clone(EntityManager var1, JPQLTemplates var2);

    @Override
    public Q clone() {
        return this.clone(this.entityManager, this.getTemplates());
    }
}

