/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class PathBuilderFactory {
    private final Map<Class<?>, PathBuilder<?>> paths = new ConcurrentHashMap();
    private final String suffix;

    public PathBuilderFactory() {
        this("");
    }

    public PathBuilderFactory(String suffix) {
        this.suffix = suffix;
    }

    public <T> PathBuilder<T> create(Class<T> type) {
        PathBuilder<Object> rv = this.paths.get(type);
        if (rv == null) {
            rv = new PathBuilder<T>(type, this.variableName(type));
            this.paths.put(type, rv);
        }
        return rv;
    }

    private String variableName(Class<?> type) {
        return StringUtils.uncapitalize(type.getSimpleName()) + this.suffix;
    }
}

