/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Coalesce;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.LiteralExpression;
import com.querydsl.core.types.dsl.NumberExpression;

public abstract class EnumExpression<T extends Enum<T>>
extends LiteralExpression<T> {
    private static final long serialVersionUID = 8819222316513862829L;
    private volatile transient NumberExpression<Integer> ordinal;

    public EnumExpression(Expression<T> mixin) {
        super(mixin);
    }

    @Override
    public EnumExpression<T> as(Path<T> alias) {
        return Expressions.enumOperation(this.getType(), Ops.ALIAS, this.mixin, alias);
    }

    @Override
    public EnumExpression<T> as(String alias) {
        return this.as(ExpressionUtils.path(this.getType(), alias));
    }

    public NumberExpression<Integer> ordinal() {
        if (this.ordinal == null) {
            this.ordinal = Expressions.numberOperation(Integer.class, Ops.ORDINAL, this.mixin);
        }
        return this.ordinal;
    }

    @Override
    public EnumExpression<T> nullif(Expression<T> other) {
        return Expressions.enumOperation(this.getType(), Ops.NULLIF, this.mixin, other);
    }

    @Override
    public EnumExpression<T> nullif(T other) {
        return this.nullif((Expression)ConstantImpl.create(other));
    }

    @Override
    public EnumExpression<T> coalesce(Expression<T> expr) {
        Coalesce<Expression<T>> coalesce = new Coalesce<Expression<T>>(this.getType(), this.mixin);
        coalesce.add(expr);
        return coalesce.asEnum();
    }

    @Override
    public EnumExpression<T> coalesce(Expression<?> ... exprs) {
        Coalesce coalesce = new Coalesce((Class<Expression<?>>)this.getType(), (Expression<Expression<?>>)this.mixin);
        for (Expression<?> expr : exprs) {
            coalesce.add(expr);
        }
        return coalesce.asEnum();
    }

    @Override
    public EnumExpression<T> coalesce(T arg) {
        Coalesce<T> coalesce = new Coalesce<T>(this.getType(), this.mixin);
        coalesce.add(arg);
        return coalesce.asEnum();
    }

    @Override
    public EnumExpression<T> coalesce(T ... args) {
        Coalesce<T> coalesce = new Coalesce<T>(this.getType(), this.mixin);
        for (T arg : args) {
            coalesce.add(arg);
        }
        return coalesce.asEnum();
    }
}

