/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen.utils;

import com.querydsl.codegen.utils.LocationAndKind;
import com.querydsl.codegen.utils.MemClassLoader;
import com.querydsl.codegen.utils.MemFileSystemRegistry;
import com.querydsl.codegen.utils.MemJavaFileObject;
import com.querydsl.codegen.utils.MemSourceFileObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class MemFileManager
extends ForwardingJavaFileManager<JavaFileManager> {
    private final ClassLoader classLoader;
    private final Map<LocationAndKind, Map<String, JavaFileObject>> ramFileSystem = new HashMap<LocationAndKind, Map<String, JavaFileObject>>();
    private final String urlPrefix;

    public MemFileManager(ClassLoader parent, StandardJavaFileManager sjfm) {
        super(sjfm);
        HashMap classLoaderContent = new HashMap();
        this.ramFileSystem.put(new LocationAndKind(StandardLocation.CLASS_OUTPUT, JavaFileObject.Kind.CLASS), classLoaderContent);
        this.classLoader = new MemClassLoader(parent, this.ramFileSystem);
        this.urlPrefix = MemFileSystemRegistry.DEFAULT.getUrlPrefix(this);
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return this.classLoader;
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        JavaFileObject jfo;
        String name = null;
        name = "".equals(packageName) ? relativeName : packageName.replace('.', '/') + "/" + relativeName;
        LocationAndKind key = new LocationAndKind(location, JavaFileObject.Kind.OTHER);
        if (this.ramFileSystem.containsKey(key) && (jfo = this.ramFileSystem.get(key).get(name)) != null) {
            return jfo;
        }
        jfo = new MemJavaFileObject(this.urlPrefix, name, JavaFileObject.Kind.OTHER);
        this.register(key, jfo);
        return jfo;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String name, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        JavaFileObject javaFileObject = null;
        LocationAndKind key = new LocationAndKind(location, kind);
        if (this.ramFileSystem.containsKey(key) && (javaFileObject = this.ramFileSystem.get(key).get(name)) != null) {
            return javaFileObject;
        }
        javaFileObject = kind == JavaFileObject.Kind.SOURCE ? new MemSourceFileObject(name) : new MemJavaFileObject(this.urlPrefix, name, kind);
        this.register(key, javaFileObject);
        return javaFileObject;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location loc, JavaFileObject javaFileObject) {
        String result = loc == StandardLocation.CLASS_PATH && javaFileObject instanceof MemJavaFileObject ? javaFileObject.getName() : super.inferBinaryName(loc, javaFileObject);
        return result;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return a.equals(b);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String pkg, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        ArrayList<JavaFileObject> result = new ArrayList<JavaFileObject>();
        for (JavaFileObject f : super.list(location, pkg, kinds, recurse)) {
            result.add(f);
        }
        if (location == StandardLocation.CLASS_PATH) {
            location = StandardLocation.CLASS_OUTPUT;
        }
        for (JavaFileObject.Kind kind : kinds) {
            LocationAndKind key = new LocationAndKind(location, kind);
            if (!this.ramFileSystem.containsKey(key)) continue;
            Map<String, JavaFileObject> locatedFiles = this.ramFileSystem.get(key);
            for (Map.Entry<String, JavaFileObject> entry : locatedFiles.entrySet()) {
                JavaFileObject candidate;
                String name = entry.getKey();
                String packageName = "";
                if (name.indexOf(46) > -1) {
                    packageName = name.substring(0, name.lastIndexOf(46));
                }
                if (!(recurse ? packageName.startsWith(pkg) : packageName.equals(pkg)) || !kinds.contains((Object)(candidate = entry.getValue()).getKind())) continue;
                result.add(candidate);
            }
        }
        return result;
    }

    private void register(LocationAndKind key, JavaFileObject javaFileObject) {
        if (!this.ramFileSystem.containsKey(key)) {
            this.ramFileSystem.put(key, new HashMap());
        }
        this.ramFileSystem.get(key).put(javaFileObject.getName(), javaFileObject);
    }
}

