/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.processing;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.storage.Configuration;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;
import com.qiniu.util.StringUtils;

public final class OperationManager {
    private final Client client;
    private final Auth auth;
    private final Configuration configuration;

    public OperationManager(Auth auth, Configuration c) {
        this.auth = auth;
        this.configuration = c.clone();
        this.client = new Client(this.configuration.dns, this.configuration.dnsHostFirst, this.configuration.proxy, this.configuration.connectTimeout, this.configuration.responseTimeout, this.configuration.writeTimeout);
    }

    public String pfop(String bucket, String key, String fops) throws QiniuException {
        return this.pfop(bucket, key, fops, null);
    }

    public String pfop(String bucket, String key, String fops, StringMap params) throws QiniuException {
        params = params == null ? new StringMap() : params;
        params.put("bucket", bucket).put("key", key).put("fops", fops);
        byte[] data = StringUtils.utf8Bytes(params.formString());
        String url = this.configuration.zone.apiHost(this.auth.accessKey, bucket) + "/pfop/";
        StringMap headers = this.auth.authorization(url, data, "application/x-www-form-urlencoded");
        Response response = this.client.post(url, data, headers, "application/x-www-form-urlencoded");
        PfopStatus status = response.jsonToObject(PfopStatus.class);
        if (status != null) {
            return status.persistentId;
        }
        return null;
    }

    private class PfopStatus {
        public String persistentId;

        private PfopStatus() {
        }
    }
}

