/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.common;

import com.qiniu.common.Constants;
import com.qiniu.common.QiniuException;
import com.qiniu.common.Zone;
import com.qiniu.http.Client;
import com.qiniu.http.Response;
import com.qiniu.util.Json;
import com.qiniu.util.UrlSafeBase64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class AutoZone
extends Zone {
    static AutoZone instance = new AutoZone();
    private final String ucServer;
    private Map<ZoneIndex, ZoneInfo> zones = new ConcurrentHashMap<ZoneIndex, ZoneInfo>();
    private Client client;

    AutoZone() {
        this("https://uc.qbox.me");
    }

    AutoZone(String ucServer) {
        this.ucServer = ucServer;
        this.client = new Client();
    }

    private UCRet getZoneJson(ZoneIndex index) throws QiniuException {
        String address = this.ucServer + "/v1/query?ak=" + index.accessKey + "&bucket=" + index.bucket;
        Response r = this.client.get(address);
        return r.jsonToObject(UCRet.class);
    }

    ZoneInfo zoneInfo(String ak, String bucket) throws QiniuException {
        ZoneIndex index = new ZoneIndex(ak, bucket);
        ZoneInfo info = this.zones.get(index);
        if (info == null) {
            UCRet ret = this.getZoneJson(index);
            try {
                info = ZoneInfo.buildFromUcRet(ret);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (info != null) {
                this.zones.put(index, info);
            }
        }
        return info;
    }

    ZoneInfo queryByToken(String token) {
        try {
            String[] strings = token.split(":");
            String ak = strings[0];
            String policy = new String(UrlSafeBase64.decode(strings[2]), Constants.UTF_8);
            String bkt = Json.decode(policy).get("scope").toString().split(":")[0];
            return this.zoneInfo(ak, bkt);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String upHost(String token) {
        ZoneInfo info = this.queryByToken(token);
        if (info == null) {
            return "";
        }
        return info.upHost;
    }

    @Override
    public String upHostBackup(String token) {
        ZoneInfo info = this.queryByToken(token);
        if (info == null) {
            return "";
        }
        return info.upBackup;
    }

    @Override
    public String upIpBackup(String token) {
        ZoneInfo info = this.queryByToken(token);
        if (info == null) {
            return "";
        }
        return info.upIp;
    }

    @Override
    public String upHostHttps(String token) {
        ZoneInfo info = this.queryByToken(token);
        if (info == null) {
            return "";
        }
        return info.upHttps;
    }

    private class UCRet {
        Map<String, List<String>> http;
        Map<String, List<String>> https;

        private UCRet() {
        }
    }

    private static class ZoneIndex {
        private final String accessKey;
        private final String bucket;

        ZoneIndex(String accessKey, String bucket) {
            this.accessKey = accessKey;
            this.bucket = bucket;
        }

        public int hashCode() {
            return this.accessKey.hashCode() * 37 + this.bucket.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof ZoneIndex && ((ZoneIndex)obj).accessKey.equals(this.accessKey) && ((ZoneIndex)obj).bucket.equals(this.bucket);
        }
    }

    static class ZoneInfo {
        final String ioHost;
        final String upHost;
        final String upIp;
        final String upBackup;
        final String upHttps;

        private ZoneInfo(String ioHost, String upHost, String upIp, String upBackup, String upHttps) {
            this.ioHost = ioHost;
            this.upHost = upHost;
            this.upIp = upIp;
            this.upBackup = upBackup;
            this.upHttps = upHttps;
        }

        static ZoneInfo buildFromUcRet(UCRet ret) {
            String ioHost = ret.http.get("io").get(0);
            List<String> up = ret.http.get("up");
            String upHost = up.get(0);
            String upBackup = up.get(1);
            String upIp = up.get(2).split(" ")[2].split("//")[1];
            String upHttps = ret.https.get("up").get(0);
            return new ZoneInfo(ioHost, upHost, upIp, upBackup, upHttps);
        }
    }
}

