/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.storage;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Client;
import com.qiniu.http.MethodType;
import com.qiniu.storage.ApiUpload;
import com.qiniu.storage.ApiUtils;
import com.qiniu.storage.UploadToken;

public class ApiUploadV2InitUpload
extends ApiUpload {
    public ApiUploadV2InitUpload(Client client) {
        super(client);
    }

    public Response request(Request request) throws QiniuException {
        return new Response(this.requestByClient(request));
    }

    public static class Response
    extends ApiUpload.Response {
        protected Response(com.qiniu.http.Response response) throws QiniuException {
            super(response);
        }

        public String getUploadId() {
            return this.getStringValueFromDataMap("uploadId");
        }

        public Long getExpireAt() {
            return this.getLongValueFromDataMap("expireAt");
        }
    }

    public static class Request
    extends ApiUpload.Request {
        private String key;

        public Request(String urlPrefix, String token) {
            super(urlPrefix);
            this.setToken(token);
            this.setMethod(MethodType.POST);
        }

        public Request setKey(String key) {
            this.key = key;
            return this;
        }

        @Override
        protected void buildPath() throws QiniuException {
            UploadToken token = this.getUploadToken();
            if (token == null || !token.isValid()) {
                ApiUtils.throwInvalidRequestParamException("token");
            }
            String bucket = this.getUploadToken().getBucket();
            this.addPathSegment("buckets");
            this.addPathSegment(bucket);
            this.addPathSegment("objects");
            this.addPathSegment(ApiUtils.resumeV2EncodeKey(this.key));
            this.addPathSegment("uploads");
            super.buildPath();
        }
    }
}

