/*
 * Decompiled with CFR 0.152.
 */
package qiniu.happydns.local;

import java.io.IOException;
import qiniu.happydns.Domain;
import qiniu.happydns.IResolver;
import qiniu.happydns.Record;
import qiniu.happydns.local.DnshijackingException;
import qiniu.happydns.local.Resolver;

public final class HijackingDetectWrapper
implements IResolver {
    private final Resolver resolver;

    public HijackingDetectWrapper(Resolver r) {
        this.resolver = r;
    }

    @Override
    public Record[] resolve(Domain domain) throws IOException {
        Record[] records = this.resolver.resolve(domain);
        if (domain.hasCname) {
            boolean cname = false;
            Record[] recordArray = records;
            int n = recordArray.length;
            for (int i = 0; i < n; ++i) {
                Record r = recordArray[i];
                if (!r.isCname()) continue;
                cname = true;
                break;
            }
            if (!cname) {
                throw new DnshijackingException(domain.domain, this.resolver.address.getHostAddress());
            }
        }
        if (domain.maxTtl != 0) {
            for (Record r : records) {
                if (r.isCname() || r.ttl <= domain.maxTtl) continue;
                throw new DnshijackingException(domain.domain, this.resolver.address.getHostAddress(), r.ttl);
            }
        }
        return records;
    }
}

