/*
 * Decompiled with CFR 0.152.
 */
package qiniu.happydns;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import qiniu.happydns.Domain;
import qiniu.happydns.IResolver;
import qiniu.happydns.Network;
import qiniu.happydns.Record;
import qiniu.happydns.http.DomainNotOwn;
import qiniu.happydns.http.IHosts;
import qiniu.happydns.local.Hosts;
import qiniu.happydns.util.IP;
import qiniu.happydns.util.LruCache;

public final class DnsClient {
    public final IHosts hosts;
    private final IResolver[] resolvers;
    private final LruCache<String, Record[]> cache;
    private volatile int index = 0;

    public DnsClient(IResolver[] resolvers) {
        this(resolvers, new Hosts());
    }

    public DnsClient(IResolver[] resolvers, IHosts hosts) {
        this.resolvers = (IResolver[])resolvers.clone();
        this.cache = new LruCache(128);
        this.hosts = hosts;
    }

    private static Record[] trimCname(Record[] records) {
        ArrayList<Record> a = new ArrayList<Record>(records.length);
        for (Record r : records) {
            if (r == null || r.type != 1) continue;
            a.add(r);
        }
        return a.toArray(new Record[a.size()]);
    }

    private static void rotate(Record[] records) {
        if (records != null && records.length > 1) {
            Record first = records[0];
            System.arraycopy(records, 1, records, 0, records.length - 1);
            records[records.length - 1] = first;
        }
    }

    private static String[] records2Ip(Record[] records) {
        if (records == null || records.length == 0) {
            return null;
        }
        ArrayList<String> a = new ArrayList<String>(records.length);
        for (Record r : records) {
            a.add(r.value);
        }
        if (a.size() == 0) {
            return null;
        }
        return a.toArray(new String[a.size()]);
    }

    public String[] query(String domain) throws IOException {
        return this.query(new Domain(domain));
    }

    public String[] query(Domain domain) throws IOException {
        if (domain == null) {
            throw new IOException("null domain");
        }
        if (domain.domain == null || domain.domain.trim().length() == 0) {
            throw new IOException("empty domain " + domain.domain);
        }
        if (IP.isValid(domain.domain)) {
            return new String[]{domain.domain};
        }
        String[] r = this.queryInternal(domain);
        if (r == null || r.length <= 1) {
            return r;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private String[] queryInternal(Domain domain) throws IOException {
        String[] ret;
        Record[] records = null;
        if (domain.hostsFirst && (ret = this.hosts.query(domain.domain)) != null && ret.length != 0) {
            return ret;
        }
        ret = this.cache;
        // MONITORENTER : this.cache
        if (Network.isNetworkChanged()) {
            this.cache.clear();
            IResolver[] iResolverArray = this.resolvers;
            // MONITORENTER : this.resolvers
            this.index = 0;
            // MONITOREXIT : iResolverArray
        } else {
            records = (Record[])this.cache.get(domain.domain);
            if (records != null && records.length != 0) {
                if (!records[0].isExpired()) {
                    DnsClient.rotate(records);
                    // MONITOREXIT : ret
                    return DnsClient.records2Ip(records);
                }
                records = null;
            }
        }
        // MONITOREXIT : ret
        IOException lastE = null;
        int firstOk = this.index;
        for (int i = 0; i < this.resolvers.length; ++i) {
            int pos = (firstOk + i) % this.resolvers.length;
            String ip = Network.getIp();
            try {
                records = this.resolvers[pos].resolve(domain);
            }
            catch (DomainNotOwn e) {
                continue;
            }
            catch (IOException e) {
                lastE = e;
                e.printStackTrace();
            }
            String ip2 = Network.getIp();
            if (records != null && records.length != 0 || !ip.equals(ip2)) break;
            IResolver[] iResolverArray = this.resolvers;
            // MONITORENTER : this.resolvers
            if (this.index == firstOk) {
                ++this.index;
                if (this.index == this.resolvers.length) {
                    this.index = 0;
                }
            }
            // MONITOREXIT : iResolverArray
        }
        if (records == null || records.length == 0) {
            String[] rs;
            if (!domain.hostsFirst && (rs = this.hosts.query(domain.domain)) != null && rs.length != 0) {
                return rs;
            }
            if (lastE == null) throw new UnknownHostException(domain.domain);
            throw lastE;
        }
        if ((records = DnsClient.trimCname(records)).length == 0) {
            throw new UnknownHostException("no A records");
        }
        LruCache<String, Record[]> lruCache = this.cache;
        // MONITORENTER : lruCache
        this.cache.put(domain.domain, records);
        // MONITOREXIT : lruCache
        return DnsClient.records2Ip(records);
    }

    public InetAddress[] queryInetAddress(Domain domain) throws IOException {
        String[] ips = this.query(domain);
        InetAddress[] addresses = new InetAddress[ips.length];
        for (int i = 0; i < ips.length; ++i) {
            addresses[i] = InetAddress.getByName(ips[i]);
        }
        return addresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        LruCache<String, Record[]> lruCache = this.cache;
        synchronized (lruCache) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNetworkChange() {
        this.clearCache();
        IResolver[] iResolverArray = this.resolvers;
        synchronized (this.resolvers) {
            this.index = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

