/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.endpoint;

import com.qcloud.cos.endpoint.EndpointBuilder;
import com.qcloud.cos.internal.BucketNameUtils;
import com.qcloud.cos.region.Region;

public class CIPicRegionEndpointBuilder
implements EndpointBuilder {
    private Region region;

    public CIPicRegionEndpointBuilder(Region region) {
        this.region = region;
    }

    @Override
    public String buildGeneralApiEndpoint(String bucketName) {
        if (this.region == null) {
            throw new IllegalArgumentException("region is null");
        }
        BucketNameUtils.validateBucketName(bucketName);
        return String.format("%s.pic.%s.myqcloud.com", bucketName, Region.formatCIRegion(this.region));
    }

    @Override
    public String buildGetServiceApiEndpoint() {
        return "service.pic.myqcloud.com";
    }
}

