/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.request;

import com.qcloud.cos.common_utils.CommonParamCheckUtils;
import com.qcloud.cos.exception.ParamException;
import com.qcloud.cos.meta.FileAuthority;
import com.qcloud.cos.request.AbstractBaseRequest;
import java.util.HashMap;
import java.util.Map;

public class UpdateFileRequest
extends AbstractBaseRequest {
    private int updatFlag = 0;
    private String bizAttr = "";
    private FileAuthority authority = FileAuthority.INVALID;
    private String cacheControl = "";
    private String contentType = "";
    private String contentDisposition = "";
    private String contentLanguage = "";
    private String contentEncoding = "";
    private Map<String, String> customHeaders = new HashMap<String, String>();
    private Map<String, String> xCosMetaHeaders = new HashMap<String, String>();

    public UpdateFileRequest(String bucketName, String cosPath) {
        super(bucketName, cosPath);
    }

    public int getUpdateFlag() {
        return this.updatFlag;
    }

    public String getBizAttr() {
        return this.bizAttr;
    }

    public void setBizAttr(String bizAttr) {
        this.bizAttr = bizAttr;
        this.updatFlag |= 1;
    }

    public FileAuthority getAuthority() {
        return this.authority;
    }

    public void setAuthority(FileAuthority authority) {
        this.authority = authority;
        this.updatFlag |= 0x80;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        this.updatFlag |= 0x40;
        this.customHeaders.put("Cache-Control", cacheControl);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
        this.updatFlag |= 0x40;
        this.customHeaders.put("Content-Type", contentType);
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        this.updatFlag |= 0x40;
        this.customHeaders.put("Content-Disposition", contentDisposition);
    }

    public void setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        this.updatFlag |= 0x40;
        this.customHeaders.put("Content-Language", contentLanguage);
    }

    public void setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        this.updatFlag |= 0x40;
        this.customHeaders.put("Content-Encoding", contentEncoding);
    }

    public void setXCosMeta(String key, String value) {
        this.xCosMetaHeaders.put(key, value);
        this.customHeaders.put(key, value);
        this.updatFlag |= 0x40;
    }

    @Override
    public void check_param() throws ParamException {
        super.check_param();
        CommonParamCheckUtils.AssertLegalCosFilePath(this.getCosPath());
        CommonParamCheckUtils.AssertLegalUpdateFlag(this.updatFlag);
        CommonParamCheckUtils.AssertNotNull("biz_attr", this.bizAttr);
        CommonParamCheckUtils.AssertNotNull("authority", (Object)this.authority);
        CommonParamCheckUtils.AssertNotNull("cacheControl", this.cacheControl);
        CommonParamCheckUtils.AssertNotNull("contentType", this.contentType);
        CommonParamCheckUtils.AssertNotNull("contentDisposition", this.contentDisposition);
        CommonParamCheckUtils.AssertNotNull("contentLanguage", this.contentLanguage);
        CommonParamCheckUtils.AssertNotNull("contentEncoding", this.contentEncoding);
        CommonParamCheckUtils.AssertLegalXCosMeta(this.xCosMetaHeaders);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(", biz_attr:").append(this.getMemberStringValue(this.bizAttr));
        sb.append(", authority:").append((Object)this.authority);
        sb.append(", cacheControl:").append(this.getMemberStringValue(this.cacheControl));
        sb.append(", contentType:").append(this.getMemberStringValue(this.contentType));
        sb.append(", contentDisposition:").append(this.getMemberStringValue(this.contentDisposition));
        sb.append(", contentLanguage:").append(this.getMemberStringValue(this.contentLanguage));
        sb.append(", contentEncoding:").append(this.getMemberStringValue(this.contentEncoding));
        for (String key : this.xCosMetaHeaders.keySet()) {
            sb.append(", x_cos_meta_key:").append(this.getMemberStringValue(key));
            sb.append(", x_cos_meta_value:").append(this.getMemberStringValue(this.xCosMetaHeaders.get(key)));
        }
        sb.append(", authority:");
        if (this.authority == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.authority);
        }
        return sb.toString();
    }
}

