/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.meta;

import com.qcloud.cos.common_utils.CommonFileUtils;
import com.qcloud.cos.exception.UnknownException;
import com.qcloud.cos.http.AbstractCosHttpClient;
import com.qcloud.cos.http.HttpContentType;
import com.qcloud.cos.http.HttpMethod;
import com.qcloud.cos.http.HttpRequest;
import com.qcloud.cos.meta.SlicePart;
import com.qcloud.cos.meta.UploadSliceFileContext;
import com.qcloud.cos.sign.Credentials;
import com.qcloud.cos.sign.Sign;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceFileDataTask
implements Callable<JSONObject> {
    private static final Logger LOG = LoggerFactory.getLogger(SliceFileDataTask.class);
    private int TaskId;
    private int sliceIndex;
    private UploadSliceFileContext context;
    private AbstractCosHttpClient httpClient;
    private Credentials cred;
    private String url;
    private long signExpired;

    public SliceFileDataTask(int taskId, int sliceIndex, UploadSliceFileContext context, AbstractCosHttpClient httpClient, Credentials cred, String url, long signExpired) {
        this.TaskId = taskId;
        this.sliceIndex = sliceIndex;
        this.context = context;
        this.httpClient = httpClient;
        this.cred = cred;
        this.url = url;
        this.signExpired = signExpired;
    }

    @Override
    public JSONObject call() throws Exception {
        try {
            HttpRequest httpRequest = new HttpRequest();
            SlicePart slicePart = this.context.sliceParts.get(this.sliceIndex);
            httpRequest.addParam("op", "upload_slice_data");
            if (this.context.isEnableShaDigest()) {
                httpRequest.addParam("sha", this.context.getEntireFileSha());
            }
            httpRequest.addParam("session", this.context.getSessionId());
            httpRequest.addParam("offset", String.valueOf(slicePart.getOffset()));
            String sliceContent = "";
            sliceContent = this.context.isUploadFromBuffer() ? new String(this.context.getContentBuffer(), new Long(slicePart.getOffset()).intValue(), slicePart.getSliceSize(), Charset.forName("ISO-8859-1")) : CommonFileUtils.getFileContent(this.context.getLocalPath(), slicePart.getOffset(), slicePart.getSliceSize());
            httpRequest.addParam("fileContent", sliceContent);
            long signExpired = System.currentTimeMillis() / 1000L + this.signExpired;
            String sign = Sign.getPeriodEffectiveSign(this.context.getBucketName(), this.context.getCosPath(), this.cred, signExpired);
            httpRequest.addHeader("Authorization", sign);
            httpRequest.setUrl(this.url);
            httpRequest.setMethod(HttpMethod.POST);
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            String resultStr = this.httpClient.sendHttpRequest(httpRequest);
            LOG.debug("sliceFileDataTask: " + this.toString() + ", result: " + resultStr);
            JSONObject resultJson = new JSONObject(resultStr);
            return resultJson;
        }
        catch (Exception e) {
            String errMsg = "taskInfo:" + this.toString() + ", Exception:" + e.toString();
            LOG.error(errMsg);
            throw new UnknownException(errMsg);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TaskId:").append(this.TaskId).append(", SliceIndex:").append(this.sliceIndex).append(", localPath:").append(this.context.getLocalPath()).append(", uploadUrl:").append(this.url);
        return sb.toString();
    }
}

