/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.http;

import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.exception.AbstractCosException;
import com.qcloud.cos.exception.ParamException;
import com.qcloud.cos.exception.ServerException;
import com.qcloud.cos.exception.UnknownException;
import com.qcloud.cos.http.AbstractCosHttpClient;
import com.qcloud.cos.http.HttpContentType;
import com.qcloud.cos.http.HttpRequest;
import com.qcloud.cos.meta.COSObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCosHttpClient
extends AbstractCosHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCosHttpClient.class);

    public DefaultCosHttpClient(ClientConfig config) {
        super(config);
    }

    private String getExceptionMsg(HttpRequest httpRequest, String exceptionStr) {
        String errMsg = "HttpRequest:" + httpRequest.toString() + "\nException:" + exceptionStr;
        LOG.error(errMsg);
        return errMsg;
    }

    @Override
    protected String sendGetRequest(HttpRequest httpRequest) throws AbstractCosException {
        String url = httpRequest.getUrl();
        HttpGet httpGet = null;
        String responseStr = "";
        int retry = 0;
        int maxRetryCount = this.config.getMaxFailedRetry();
        while (retry < maxRetryCount) {
            String errMsg;
            try {
                URIBuilder urlBuilder = new URIBuilder(url);
                for (String paramKey : httpRequest.getParams().keySet()) {
                    urlBuilder.addParameter(paramKey, httpRequest.getParams().get(paramKey));
                }
                httpGet = new HttpGet(urlBuilder.build());
            }
            catch (URISyntaxException e) {
                String errMsg2 = "Invalid url:" + url;
                LOG.error(errMsg2);
                throw new ParamException(errMsg2);
            }
            httpGet.setConfig(this.requestConfig);
            this.setHeaders((HttpMessage)httpGet, httpRequest.getHeaders());
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.httpClient.execute((HttpUriRequest)httpGet);
                int http_statuscode = httpResponse.getStatusLine().getStatusCode();
                if (http_statuscode >= 500 && http_statuscode <= 599) {
                    errMsg = String.format("http status code is %d, response body: %s", http_statuscode, this.getResponseString(httpResponse));
                    throw new IOException(errMsg);
                }
                responseStr = this.getResponseString(httpResponse);
                new JSONObject(responseStr);
                errMsg = responseStr;
                return errMsg;
            }
            catch (IOException | ParseException e) {
                httpGet.abort();
                if (++retry != maxRetryCount) continue;
                errMsg = this.getExceptionMsg(httpRequest, e.toString());
                throw new ServerException(errMsg);
            }
            catch (JSONException e) {
                errMsg = String.format("server response is not json, httpRequest: %s, httpResponse: %s, responseStr: %s", httpRequest.toString(), httpResponse.toString(), responseStr);
                throw new ServerException(errMsg);
            }
            finally {
                httpGet.releaseConnection();
            }
        }
        return responseStr;
    }

    @Override
    protected String sendPostRequest(HttpRequest httpRequest) throws AbstractCosException {
        String url = httpRequest.getUrl();
        String responseStr = "";
        int retry = 0;
        int maxRetryCount = this.config.getMaxFailedRetry();
        while (retry < maxRetryCount) {
            HttpPost httpPost = new HttpPost(url);
            httpPost.setConfig(this.requestConfig);
            Map<String, String> params = httpRequest.getParams();
            this.setHeaders((HttpMessage)httpPost, httpRequest.getHeaders());
            if (httpRequest.getContentType() == HttpContentType.APPLICATION_JSON) {
                this.setJsonEntity(httpPost, params);
            } else if (httpRequest.getContentType() == HttpContentType.MULTIPART_FORM_DATA) {
                try {
                    this.setMultiPartEntity(httpPost, params);
                }
                catch (Exception e) {
                    throw new UnknownException(e.toString());
                }
            }
            HttpResponse httpResponse = null;
            try {
                httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
                int http_statuscode = httpResponse.getStatusLine().getStatusCode();
                if (http_statuscode >= 500 && http_statuscode <= 599) {
                    String errMsg = String.format("http status code is %d, response body: %s", http_statuscode, this.getResponseString(httpResponse));
                    throw new IOException(errMsg);
                }
                responseStr = this.getResponseString(httpResponse);
                new JSONObject(responseStr);
                String errMsg = responseStr;
                return errMsg;
            }
            catch (IOException | ParseException e) {
                httpPost.abort();
                if (++retry != maxRetryCount) continue;
                String errMsg = this.getExceptionMsg(httpRequest, e.toString());
                throw new ServerException(errMsg);
            }
            catch (JSONException e) {
                String errMsg = String.format("server response is not json, httpRequest: %s, httpResponse: %s, responseStr: %s", httpRequest.toString(), httpResponse.toString(), responseStr);
                throw new ServerException(errMsg);
            }
            finally {
                httpPost.releaseConnection();
            }
        }
        return responseStr;
    }

    @Override
    public InputStream getFileInputStream(HttpRequest httpRequest) throws AbstractCosException {
        String url = httpRequest.getUrl();
        int retry = 0;
        int maxRetryCount = this.config.getMaxFailedRetry();
        while (retry < maxRetryCount) {
            String errMsg;
            HttpGet httpGet = null;
            try {
                URIBuilder urlBuilder = new URIBuilder(url);
                for (String paramKey : httpRequest.getParams().keySet()) {
                    urlBuilder.addParameter(paramKey, httpRequest.getParams().get(paramKey));
                }
                httpGet = new HttpGet(urlBuilder.build());
            }
            catch (URISyntaxException e) {
                errMsg = "Invalid url:" + url;
                LOG.error(errMsg);
                throw new ParamException(errMsg);
            }
            httpGet.setConfig(this.requestConfig);
            this.setHeaders((HttpMessage)httpGet, httpRequest.getHeaders());
            try {
                HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)httpGet);
                int http_statuscode = httpResponse.getStatusLine().getStatusCode();
                if (http_statuscode >= 500 && http_statuscode <= 599) {
                    String errMsg2 = String.format("http status code is %d, response body: %s", http_statuscode, this.getResponseString(httpResponse));
                    throw new IOException(errMsg2);
                }
                if (http_statuscode != 200 && http_statuscode != 206) {
                    String responseStr = this.getResponseString(httpResponse);
                    String errMsg3 = String.format("getFileinputstream failed, httpRequest: %s, httpResponse: %s, responseStr: %s", httpRequest.toString(), httpResponse.toString(), responseStr);
                    httpGet.releaseConnection();
                    throw new ServerException(errMsg3);
                }
                HttpEntity entity = httpResponse.getEntity();
                COSObjectInputStream cosObjectInputStream = new COSObjectInputStream(entity.getContent(), (HttpRequestBase)httpGet);
                return cosObjectInputStream;
            }
            catch (IOException | ParseException e) {
                httpGet.abort();
                httpGet.releaseConnection();
                if (++retry != maxRetryCount) continue;
                errMsg = this.getExceptionMsg(httpRequest, e.toString());
                throw new ServerException(errMsg);
            }
        }
        return null;
    }

    private String getResponseString(HttpResponse httpResponse) throws ParseException, IOException {
        String httpResponseStr = null;
        HttpEntity httpEntity = httpResponse.getEntity();
        if (httpEntity != null) {
            httpResponseStr = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
        }
        if (httpResponseStr == null) {
            return "";
        }
        return httpResponseStr;
    }

    private void setJsonEntity(HttpPost httpPost, Map<String, String> params) {
        ContentType utf8TextPlain = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
        String postJsonStr = new JSONObject(params).toString();
        StringEntity stringEntity = new StringEntity(postJsonStr, utf8TextPlain);
        httpPost.setEntity((HttpEntity)stringEntity);
    }

    private void setMultiPartEntity(HttpPost httpPost, Map<String, String> params) throws Exception {
        ContentType utf8TextPlain = ContentType.create((String)"text/plain", (Charset)Consts.UTF_8);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        for (String paramKey : params.keySet()) {
            if (paramKey.equals("fileContent")) {
                entityBuilder.addBinaryBody("fileContent", params.get("fileContent").getBytes(Charset.forName("ISO-8859-1")));
                continue;
            }
            entityBuilder.addTextBody(paramKey, params.get(paramKey), utf8TextPlain);
        }
        httpPost.setEntity(entityBuilder.build());
    }

    private void setHeaders(HttpMessage message, Map<String, String> headers) {
        message.setHeader("Accept", "*/*");
        message.setHeader("Connection", "Keep-Alive");
        message.setHeader("User-Agent", this.config.getUserAgent());
        if (headers != null) {
            for (String headerKey : headers.keySet()) {
                message.setHeader(headerKey, headers.get(headerKey));
            }
        }
    }
}

