/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.common_utils.CommonFileUtils;
import com.qcloud.cos.meta.FileAuthority;
import com.qcloud.cos.meta.InsertOnly;
import com.qcloud.cos.request.CreateFolderRequest;
import com.qcloud.cos.request.DelFileRequest;
import com.qcloud.cos.request.DelFolderRequest;
import com.qcloud.cos.request.GetFileLocalRequest;
import com.qcloud.cos.request.ListFolderRequest;
import com.qcloud.cos.request.MoveFileRequest;
import com.qcloud.cos.request.StatFileRequest;
import com.qcloud.cos.request.StatFolderRequest;
import com.qcloud.cos.request.UpdateFileRequest;
import com.qcloud.cos.request.UpdateFolderRequest;
import com.qcloud.cos.request.UploadFileRequest;
import com.qcloud.cos.sign.Credentials;
import java.nio.charset.Charset;

public class Demo {
    public static void main(String[] args) throws Exception {
        long appId = 1000000L;
        String secretId = "xxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String secretKey = "xxxxxxxxxxxxxxxxxxxxxxxxxx";
        String bucketName = "xxxxxxxxx";
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setRegion("gz");
        Credentials cred = new Credentials(appId, secretId, secretKey);
        COSClient cosClient = new COSClient(clientConfig, cred);
        String cosFilePath = "/sample_file.txt";
        String localFilePath1 = "src/test/resources/bigfile.txt";
        UploadFileRequest uploadFileRequest = new UploadFileRequest(bucketName, cosFilePath, localFilePath1);
        uploadFileRequest.setEnableShaDigest(false);
        String uploadFileRet = cosClient.uploadFile(uploadFileRequest);
        System.out.println("upload file ret:" + uploadFileRet);
        String localPathDown = "src/test/resources/local_file_down.txt";
        GetFileLocalRequest getFileLocalRequest = new GetFileLocalRequest(bucketName, cosFilePath, localPathDown);
        getFileLocalRequest.setUseCDN(false);
        getFileLocalRequest.setReferer("*.myweb.cn");
        String getFileResult = cosClient.getFileLocal(getFileLocalRequest);
        System.out.println("getFileResult:" + getFileResult);
        String localFilePath2 = "src/test/resources/local_file_2.txt";
        byte[] contentBuffer = CommonFileUtils.getFileContent(localFilePath2).getBytes(Charset.forName("ISO-8859-1"));
        UploadFileRequest overWriteFileRequest = new UploadFileRequest(bucketName, cosFilePath, contentBuffer);
        overWriteFileRequest.setInsertOnly(InsertOnly.OVER_WRITE);
        String overWriteFileRet = cosClient.uploadFile(overWriteFileRequest);
        System.out.println("overwrite file ret:" + overWriteFileRet);
        StatFileRequest statFileRequest = new StatFileRequest(bucketName, cosFilePath);
        String statFileRet = cosClient.statFile(statFileRequest);
        System.out.println("stat file ret:" + statFileRet);
        UpdateFileRequest updateFileRequest = new UpdateFileRequest(bucketName, cosFilePath);
        updateFileRequest.setBizAttr("\u6d4b\u8bd5\u76ee\u5f55");
        updateFileRequest.setAuthority(FileAuthority.WPRIVATE);
        updateFileRequest.setCacheControl("no cache");
        updateFileRequest.setContentDisposition("cos_sample.txt");
        updateFileRequest.setContentLanguage("english");
        updateFileRequest.setContentType("application/json");
        updateFileRequest.setXCosMeta("x-cos-meta-xxx", "xxx");
        updateFileRequest.setXCosMeta("x-cos-meta-yyy", "yyy");
        updateFileRequest.setContentEncoding("gzip");
        String updateFileRet = cosClient.updateFile(updateFileRequest);
        System.out.println("update file ret:" + updateFileRet);
        statFileRet = cosClient.statFile(statFileRequest);
        System.out.println("stat file ret:" + statFileRet);
        String dstFilePath = cosFilePath + ".bak";
        MoveFileRequest moveRequest = new MoveFileRequest(bucketName, cosFilePath, dstFilePath);
        String moveFileRet = cosClient.moveFile(moveRequest);
        System.out.println("first move file ret:" + moveFileRet);
        moveRequest = new MoveFileRequest(bucketName, dstFilePath, cosFilePath);
        moveFileRet = cosClient.moveFile(moveRequest);
        System.out.println("second move file ret:" + moveFileRet);
        DelFileRequest delFileRequest = new DelFileRequest(bucketName, cosFilePath);
        String delFileRet = cosClient.delFile(delFileRequest);
        System.out.println("del file ret:" + delFileRet);
        String cosFolderPath = "/xxsample_folder/";
        CreateFolderRequest createFolderRequest = new CreateFolderRequest(bucketName, cosFolderPath);
        String createFolderRet = cosClient.createFolder(createFolderRequest);
        System.out.println("create folder ret:" + createFolderRet);
        UpdateFolderRequest updateFolderRequest = new UpdateFolderRequest(bucketName, cosFolderPath);
        updateFolderRequest.setBizAttr("\u8fd9\u662f\u4e00\u4e2a\u6d4b\u8bd5\u76ee\u5f55");
        String updateFolderRet = cosClient.updateFolder(updateFolderRequest);
        System.out.println("update folder ret:" + updateFolderRet);
        StatFolderRequest statFolderRequest = new StatFolderRequest(bucketName, cosFolderPath);
        String statFolderRet = cosClient.statFolder(statFolderRequest);
        System.out.println("stat folder ret:" + statFolderRet);
        ListFolderRequest listFolderRequest = new ListFolderRequest(bucketName, cosFolderPath);
        String listFolderRet = cosClient.listFolder(listFolderRequest);
        System.out.println("list folder ret:" + listFolderRet);
        DelFolderRequest delFolderRequest = new DelFolderRequest(bucketName, cosFolderPath);
        String delFolderRet = cosClient.delFolder(delFolderRequest);
        System.out.println("del folder ret:" + delFolderRet);
        cosClient.shutdown();
        System.out.println("shutdown!");
    }
}

