/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.auth;

import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.utils.StringUtils;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.auth.AbstractCOSCredentialProvider;

public class SessionCredentialProvider
extends AbstractCOSCredentialProvider
implements COSCredentialsProvider {
    private String appId;

    public SessionCredentialProvider(@Nullable URI uri, Configuration conf) {
        super(uri, conf);
        if (null != conf) {
            this.appId = conf.get("fs.cosn.userinfo.appid");
        }
    }

    public COSCredentials getCredentials() {
        if (null == super.getUri()) {
            return null;
        }
        String authority = super.getUri().getAuthority();
        if (null == authority) {
            return null;
        }
        int authoritySplitIndex = authority.indexOf(64);
        if (authoritySplitIndex < 0) {
            return null;
        }
        String credential = authority.substring(0, authoritySplitIndex);
        int credentialSplitIndex = credential.indexOf(58);
        if (credentialSplitIndex < 0) {
            return null;
        }
        String secretId = credential.substring(0, credentialSplitIndex);
        String secretKey = credential.substring(credentialSplitIndex + 1);
        if (!StringUtils.isNullOrEmpty((String)secretId) && !StringUtils.isNullOrEmpty((String)secretKey)) {
            if (null != this.appId) {
                return new BasicCOSCredentials(this.appId, secretId, secretKey);
            }
            return new BasicCOSCredentials(secretId, secretKey);
        }
        return null;
    }

    public void refresh() {
    }
}

