/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.qcloud.chdfs.permission.RangerAccessType;
import com.qcloud.cos.model.HeadBucketResult;
import com.qcloud.cos.utils.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.CosNCopyFileContext;
import org.apache.hadoop.fs.CosNCopyFileTask;
import org.apache.hadoop.fs.CosNDeleteFileContext;
import org.apache.hadoop.fs.CosNDeleteFileTask;
import org.apache.hadoop.fs.CosNFSDataOutputStream;
import org.apache.hadoop.fs.CosNFSInputStream;
import org.apache.hadoop.fs.CosNFileStatus;
import org.apache.hadoop.fs.CosNPartialListing;
import org.apache.hadoop.fs.CosNResultInfo;
import org.apache.hadoop.fs.CosNUtils;
import org.apache.hadoop.fs.CosNativeFileSystemStore;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileMetadata;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.NativeFileSystemStore;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathIOException;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.auth.RangerCredentialsProvider;
import org.apache.hadoop.fs.cosn.BufferPool;
import org.apache.hadoop.fs.cosn.CRC32CCheckSum;
import org.apache.hadoop.fs.cosn.CRC64Checksum;
import org.apache.hadoop.fs.cosn.ranger.client.RangerQcloudObjectStorageClient;
import org.apache.hadoop.fs.cosn.ranger.security.authorization.AccessType;
import org.apache.hadoop.fs.cosn.ranger.security.authorization.PermissionRequest;
import org.apache.hadoop.fs.cosn.ranger.security.authorization.PermissionResponse;
import org.apache.hadoop.fs.cosn.ranger.security.authorization.ServiceType;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.io.retry.RetryProxy;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class CosFileSystem
extends FileSystem {
    static final Logger LOG = LoggerFactory.getLogger(CosFileSystem.class);
    static final String SCHEME = "cosn";
    static final String PATH_DELIMITER = "/";
    static final Charset METADATA_ENCODING = StandardCharsets.UTF_8;
    static final int MAX_XATTR_SIZE = 1024;
    private URI uri;
    private String bucket;
    private boolean isMergeBucket;
    private boolean checkMergeBucket;
    private int mergeBucketMaxListNum;
    private int normalBucketMaxListNum;
    private NativeFileSystemStore store;
    private Path workingDir;
    private String owner = "Unknown";
    private String group = "Unknown";
    private ExecutorService boundedIOThreadPool;
    private ExecutorService boundedCopyThreadPool;
    private UserGroupInformation currentUser;
    private boolean enableRangerPluginPermissionCheck = false;
    public static RangerQcloudObjectStorageClient rangerQcloudObjectStorageStorageClient = null;
    private String formatBucket;

    public CosFileSystem() {
    }

    public CosFileSystem(NativeFileSystemStore store) {
        this.store = store;
    }

    public String getScheme() {
        return SCHEME;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.currentUser = UserGroupInformation.getCurrentUser();
        this.initRangerClientImpl(conf);
        this.bucket = uri.getHost();
        this.formatBucket = CosNUtils.formatBucket(uri.getHost(), conf);
        if (this.store == null) {
            this.store = CosFileSystem.createDefaultStore(conf);
        }
        this.store.initialize(uri, conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = new Path("/user", System.getProperty("user.name")).makeQualified(this.uri, this.getWorkingDirectory());
        this.owner = this.getOwnerId();
        this.group = this.getGroupId();
        LOG.debug("uri: {}, bucket: {}, working dir: {}, owner: {}, group: {}.\nconfiguration: {}.", new Object[]{uri, this.bucket, this.workingDir, this.owner, this.group, conf});
        BufferPool.getInstance().initialize(this.getConf());
        this.isMergeBucket = false;
        this.checkMergeBucket = this.getConf().getBoolean("fs.cosn.check.merge.bucket", true);
        if (this.checkMergeBucket) {
            HeadBucketResult headBucketResult = this.store.headBucket(this.bucket);
            int mergeBucketMaxListNum = this.getConf().getInt("fs.cosn.merge.bucket.max.list.num", 5000);
            if (headBucketResult.isMergeBucket()) {
                this.isMergeBucket = true;
                this.mergeBucketMaxListNum = mergeBucketMaxListNum;
                this.store.setMergeBucket(true);
            }
        }
        LOG.info("cos file system bucket is merged {}", (Object)this.isMergeBucket);
        this.normalBucketMaxListNum = this.getConf().getInt("fs.cosn.normal.bucket.max.list.num", 999);
        int uploadThreadPoolSize = this.getConf().getInt("fs.cosn.upload_thread_pool", 10);
        int readAheadPoolSize = this.getConf().getInt("fs.cosn.read.ahead.queue.size", 8);
        Preconditions.checkArgument((uploadThreadPoolSize > 0 ? 1 : 0) != 0, (Object)String.format("The uploadThreadPoolSize[%d] should be positive.", uploadThreadPoolSize));
        Preconditions.checkArgument((readAheadPoolSize > 0 ? 1 : 0) != 0, (Object)String.format("The readAheadQueueSize[%d] should be positive.", readAheadPoolSize));
        int ioThreadPoolSize = uploadThreadPoolSize + readAheadPoolSize;
        int ioMaxTaskSize = Math.max(uploadThreadPoolSize + readAheadPoolSize, Runtime.getRuntime().availableProcessors() * 2 + 1);
        long threadKeepAlive = this.getConf().getLong("fs.cosn.threads.keep_alive_time", 60L);
        Preconditions.checkArgument((threadKeepAlive > 0L ? 1 : 0) != 0, (Object)String.format("The threadKeepAlive [%d] should be positive.", threadKeepAlive));
        this.boundedIOThreadPool = new ThreadPoolExecutor(ioThreadPoolSize, ioMaxTaskSize, threadKeepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(ioThreadPoolSize), new ThreadFactoryBuilder().setNameFormat("cos-transfer-shared-%d").setDaemon(true).build(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    try {
                        executor.getQueue().put(r);
                    }
                    catch (InterruptedException e) {
                        LOG.error("put a io task into the download thread pool occurs an exception.", (Throwable)e);
                        throw new RejectedExecutionException("Putting the io task failed due to the interruption", e);
                    }
                } else {
                    LOG.error("The bounded io thread pool has been shutdown.");
                    throw new RejectedExecutionException("The bounded io thread pool has been shutdown");
                }
            }
        });
        int copyThreadPoolSize = this.getConf().getInt("fs.cosn.copy_thread_pool", 3);
        Preconditions.checkArgument((copyThreadPoolSize > 0 ? 1 : 0) != 0, (Object)String.format("The copyThreadPoolSize[%d] should be positive.", copyThreadPoolSize));
        int maxCopyTaskSize = Math.max(copyThreadPoolSize, Runtime.getRuntime().availableProcessors() * 2 + 1);
        this.boundedCopyThreadPool = new ThreadPoolExecutor(copyThreadPoolSize, maxCopyTaskSize, threadKeepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(copyThreadPoolSize), new ThreadFactoryBuilder().setNameFormat("cos-copy-%d").setDaemon(true).build(), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                if (!executor.isShutdown()) {
                    try {
                        executor.getQueue().put(r);
                    }
                    catch (InterruptedException e) {
                        LOG.error("put a copy task into the download thread pool occurs an exception.", (Throwable)e);
                    }
                }
            }
        });
    }

    private static NativeFileSystemStore createDefaultStore(Configuration conf) {
        CosNativeFileSystemStore store = new CosNativeFileSystemStore();
        RetryPolicy basePolicy = RetryPolicies.retryUpToMaximumCountWithFixedSleep((int)conf.getInt("fs.cosn.maxRetries", 200), (long)conf.getLong("fs.cosn.retry.interval.seconds", 3L), (TimeUnit)TimeUnit.SECONDS);
        HashMap<Class<IOException>, RetryPolicy> exceptionToPolicyMap = new HashMap<Class<IOException>, RetryPolicy>();
        exceptionToPolicyMap.put(IOException.class, basePolicy);
        RetryPolicy methodPolicy = RetryPolicies.retryByException((RetryPolicy)RetryPolicies.TRY_ONCE_THEN_FAIL, exceptionToPolicyMap);
        HashMap methodNameToPolicyMap = new HashMap();
        return (NativeFileSystemStore)RetryProxy.create(NativeFileSystemStore.class, (Object)store, methodNameToPolicyMap);
    }

    private String getOwnerId() {
        return System.getProperty("user.name");
    }

    private String getGroupId() {
        return System.getProperty("user.name");
    }

    private String getOwnerInfo(boolean getOwnerId) {
        String ownerInfoId = "";
        try {
            int c;
            String userName = System.getProperty("user.name");
            String command = "id -u " + userName;
            if (!getOwnerId) {
                command = "id -g " + userName;
            }
            Process child = Runtime.getRuntime().exec(command);
            child.waitFor();
            InputStream in = child.getInputStream();
            StringBuilder strBuffer = new StringBuilder();
            while ((c = in.read()) != -1) {
                strBuffer.append((char)c);
            }
            in.close();
            ownerInfoId = strBuffer.toString();
        }
        catch (InterruptedException e) {
            LOG.error("getOwnerInfo occur a exception", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("getOwnerInfo occur a exception", (Throwable)e);
        }
        return ownerInfoId;
    }

    private static String pathToKey(Path path) {
        if (path.toUri().getScheme() != null && path.toUri().getPath().isEmpty()) {
            return "";
        }
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String ret = path.toUri().getPath();
        if (ret.endsWith(PATH_DELIMITER) && ret.indexOf(PATH_DELIMITER) != ret.length() - 1) {
            ret = ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    private static Path keyToPath(String key) {
        if (!key.startsWith(PATH_DELIMITER)) {
            return new Path(PATH_DELIMITER + key);
        }
        return new Path(key);
    }

    private Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    public Path getHomeDirectory() {
        String homePrefix = this.getConf().get("dfs.user.home.dir.prefix");
        if (null != homePrefix) {
            return this.makeQualified(new Path(homePrefix + PATH_DELIMITER + System.getProperty("user.name")));
        }
        return super.getHomeDirectory();
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) {
        throw new UnsupportedOperationException("Not supported currently");
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        this.checkPermission(f, RangerAccessType.WRITE);
        if (this.exists(f) && !overwrite) {
            throw new FileAlreadyExistsException("File already exists: " + f);
        }
        LOG.debug("Creating a new file [{}] in COS.", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        long uploadPartSize = this.getConf().getLong("fs.cosn.upload.part.size", 0x800000L);
        boolean uploadChecksEnabled = this.getConf().getBoolean("fs.cosn.upload.checks.enable", true);
        return new FSDataOutputStream((OutputStream)new CosNFSDataOutputStream(this.getConf(), this.store, key, uploadPartSize, this.boundedIOThreadPool, uploadChecksEnabled), this.statistics);
    }

    private boolean rejectRootDirectoryDelete(boolean isEmptyDir, boolean recursive) throws PathIOException {
        if (isEmptyDir) {
            return true;
        }
        if (recursive) {
            return false;
        }
        throw new PathIOException(this.bucket, "Can not delete root path");
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        FileStatus status;
        LOG.debug("Ready to delete path: {}. recursive: {}.", (Object)f, (Object)recursive);
        this.checkPermission(f, RangerAccessType.DELETE);
        try {
            status = this.getFileStatus(f);
        }
        catch (FileNotFoundException e) {
            LOG.debug("Delete called for '{}', but the file does not exist and returning the false.", (Object)f);
            return false;
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        if (key.compareToIgnoreCase(PATH_DELIMITER) == 0) {
            FileStatus[] fileStatuses = this.listStatus(f);
            return this.rejectRootDirectoryDelete(fileStatuses.length == 0, recursive);
        }
        if (status.isDirectory()) {
            if (!key.endsWith(PATH_DELIMITER)) {
                key = key + PATH_DELIMITER;
            }
            if (!recursive && this.listStatus(f).length > 0) {
                throw new IOException("Can not delete " + f + " as is a not empty directory and recurse option is false");
            }
            if (!this.isMergeBucket) {
                this.internalRecursiveDelete(key);
            } else {
                this.internalAutoRecursiveDelete(key);
            }
        } else {
            LOG.debug("Delete the cos key [{}].", (Object)key);
            this.store.delete(key);
        }
        if (!this.isMergeBucket) {
            this.createParentDirectoryIfNecessary(f);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRecursiveDelete(String key) throws IOException {
        CosNPartialListing listing;
        CosNDeleteFileContext deleteFileContext = new CosNDeleteFileContext();
        int deleteToFinishes = 0;
        String priorLastKey = null;
        block7: do {
            listing = this.store.list(key, this.normalBucketMaxListNum, priorLastKey, true);
            for (FileMetadata file : listing.getFiles()) {
                this.boundedCopyThreadPool.execute(new CosNDeleteFileTask(this.store, file.getKey(), deleteFileContext));
                ++deleteToFinishes;
                if (!deleteFileContext.isDeleteSuccess()) break;
            }
            for (FileMetadata commonPrefix : listing.getCommonPrefixes()) {
                this.boundedCopyThreadPool.execute(new CosNDeleteFileTask(this.store, commonPrefix.getKey(), deleteFileContext));
                ++deleteToFinishes;
                if (!deleteFileContext.isDeleteSuccess()) continue block7;
            }
        } while ((priorLastKey = listing.getPriorLastKey()) != null);
        deleteFileContext.lock();
        try {
            deleteFileContext.awaitAllFinish(deleteToFinishes);
        }
        catch (InterruptedException e) {
            LOG.warn("interrupted when wait delete to finish");
        }
        finally {
            deleteFileContext.unlock();
        }
        if (!deleteFileContext.isDeleteSuccess() && deleteFileContext.hasException()) {
            throw deleteFileContext.getIOException();
        }
        try {
            LOG.debug("Delete the cos key [{}].", (Object)key);
            this.store.delete(key);
        }
        catch (Exception e) {
            LOG.error("Delete the key failed.");
        }
    }

    private void internalAutoRecursiveDelete(String key) throws IOException {
        LOG.debug("Delete the cos key auto recursive [{}].", (Object)key);
        this.store.deleteRecursive(key);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        LOG.debug("Get file status: {}.", (Object)f);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        if (key.length() == 0 || key.equals(PATH_DELIMITER)) {
            return this.newDirectory(absolutePath);
        }
        CosNResultInfo headInfo = new CosNResultInfo();
        FileMetadata meta = this.store.retrieveMetadata(key, headInfo);
        if (meta != null) {
            if (meta.isFile()) {
                LOG.debug("Retrieve the cos key [{}] to find that it is a file.", (Object)key);
                return this.newFile(meta, absolutePath);
            }
            LOG.debug("Retrieve the cos key [{}] to find that it is a directory.", (Object)key);
            return this.newDirectory(meta, absolutePath);
        }
        if (this.isMergeBucket) {
            throw new FileNotFoundException("No such file or directory in merge bucket'" + absolutePath + "'");
        }
        if (!key.endsWith(PATH_DELIMITER)) {
            key = key + PATH_DELIMITER;
        }
        int maxKeys = this.getConf().getInt("fs.cosn.filestatus.list_max_keys", 2);
        LOG.debug("List the cos key [{}] to judge whether it is a directory or not. max keys [{}]", (Object)key, (Object)maxKeys);
        CosNResultInfo listInfo = new CosNResultInfo();
        CosNPartialListing listing = this.store.list(key, maxKeys, listInfo);
        if (listing.getFiles().length > 0 || listing.getCommonPrefixes().length > 0) {
            LOG.debug("List the cos key [{}] to find that it is a directory.", (Object)key);
            return this.newDirectory(absolutePath);
        }
        if (listInfo.isKeySameToPrefix()) {
            LOG.info("List the cos key [{}] same to prefix, head-id:[{}], list-id:[{}], list-type:[{}], thread-id:[{}], thread-name:[{}]", new Object[]{key, headInfo.getRequestID(), listInfo.getRequestID(), listInfo.isKeySameToPrefix(), Thread.currentThread().getId(), Thread.currentThread().getName()});
        }
        LOG.debug("Can not find the cos key [{}] on COS.", (Object)key);
        throw new FileNotFoundException("No such file or directory '" + absolutePath + "'");
    }

    public URI getUri() {
        return this.uri;
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        CosNPartialListing listing;
        FileMetadata meta;
        LOG.debug("list status:" + f);
        this.checkPermission(f, RangerAccessType.LIST);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        int listMaxLength = this.normalBucketMaxListNum;
        if (this.checkMergeBucket && this.isMergeBucket) {
            listMaxLength = this.mergeBucketMaxListNum;
        }
        if (key.length() > 0 && (meta = this.store.retrieveMetadata(key)) != null && meta.isFile()) {
            return new FileStatus[]{this.newFile(meta, absolutePath)};
        }
        if (!key.endsWith(PATH_DELIMITER)) {
            key = key + PATH_DELIMITER;
        }
        if (this.isMergeBucket) {
            try {
                this.getFileStatus(f);
            }
            catch (FileNotFoundException e) {
                throw new FileNotFoundException("No such file or directory:" + f);
            }
        }
        URI pathUri = absolutePath.toUri();
        TreeSet<FileStatus> status = new TreeSet<FileStatus>();
        String priorLastKey = null;
        do {
            listing = this.store.list(key, listMaxLength, priorLastKey, false);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                Path subPath = CosFileSystem.keyToPath(fileMetadata.getKey());
                if (fileMetadata.getKey().equals(key)) {
                    LOG.debug("This is just the directory we have been asked to list. cos key: {}.", (Object)fileMetadata.getKey());
                    continue;
                }
                status.add(this.newFile(fileMetadata, subPath));
            }
            for (FileMetadata commonPrefix : listing.getCommonPrefixes()) {
                Path subpath = CosFileSystem.keyToPath(commonPrefix.getKey());
                String relativePath = pathUri.relativize(subpath.toUri()).getPath();
                status.add(this.newDirectory(commonPrefix, new Path(absolutePath, relativePath)));
            }
        } while ((priorLastKey = listing.getPriorLastKey()) != null);
        return status.toArray(new FileStatus[status.size()]);
    }

    private FileStatus newFile(FileMetadata meta, Path path) {
        return new CosNFileStatus(meta.getLength(), false, 1, this.getDefaultBlockSize(), meta.getLastModified(), 0L, null, this.owner, this.group, path.makeQualified(this.getUri(), this.getWorkingDirectory()), meta.getETag(), meta.getCrc64ecm(), meta.getVersionId());
    }

    private FileStatus newDirectory(Path path) {
        return new CosNFileStatus(0L, true, 1, 0L, 0L, 0L, null, this.owner, this.group, path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private FileStatus newDirectory(FileMetadata meta, Path path) {
        if (meta == null) {
            return this.newDirectory(path);
        }
        return new CosNFileStatus(0L, true, 1, 0L, meta.getLastModified(), 0L, null, this.owner, this.group, path.makeQualified(this.getUri(), this.getWorkingDirectory()), meta.getETag(), meta.getCrc64ecm(), meta.getVersionId());
    }

    private void validatePath(Path path) throws IOException {
        Path parent = path.getParent();
        while (true) {
            try {
                FileStatus fileStatus = this.getFileStatus(parent);
                if (!fileStatus.isDirectory()) {
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s', it is a file.", parent));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if ((parent = parent.getParent()) != null) continue;
            }
            break;
        }
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        LOG.debug("mkdirs path: {}.", (Object)f);
        this.checkPermission(f, RangerAccessType.WRITE);
        try {
            FileStatus fileStatus = this.getFileStatus(f);
            if (fileStatus.isDirectory()) {
                return true;
            }
            throw new FileAlreadyExistsException("Path is a file: " + f);
        }
        catch (FileNotFoundException e) {
            this.validatePath(f);
            boolean result = this.isMergeBucket ? this.mkDirAutoRecursively(f, permission) : this.mkDirRecursively(f, permission);
            return result;
        }
    }

    public boolean mkDirRecursively(Path f, FsPermission permission) throws IOException {
        Path path;
        LOG.debug("Make the directory recursively. Path: {}, FsPermission: {}.", (Object)f, (Object)permission);
        Path absolutePath = this.makeAbsolute(f);
        ArrayList<Path> paths = new ArrayList<Path>();
        do {
            paths.add(absolutePath);
        } while ((absolutePath = absolutePath.getParent()) != null);
        Iterator iterator = paths.iterator();
        while (iterator.hasNext() && !(path = (Path)iterator.next()).isRoot()) {
            try {
                FileStatus fileStatus = this.getFileStatus(path);
                if (fileStatus.isFile()) {
                    throw new FileAlreadyExistsException(String.format("Can't make directory for path '%s' since it is a file.", f));
                }
                if (!fileStatus.isDirectory()) continue;
                if (fileStatus.getModificationTime() <= 0L) {
                    throw new FileNotFoundException("Dir '" + path + "' doesn't exist in COS");
                }
                break;
            }
            catch (FileNotFoundException e) {
                LOG.debug("Make the directory [{}] on COS.", (Object)path);
                String folderPath = CosFileSystem.pathToKey(this.makeAbsolute(path));
                if (!folderPath.endsWith(PATH_DELIMITER)) {
                    folderPath = folderPath + PATH_DELIMITER;
                }
                this.store.storeEmptyFile(folderPath);
            }
        }
        return true;
    }

    public boolean mkDirAutoRecursively(Path f, FsPermission permission) throws IOException {
        LOG.debug("Make the directory recursively auto. Path: {}, FsPermission: {}.", (Object)f, (Object)permission);
        String folderPath = CosFileSystem.pathToKey(this.makeAbsolute(f));
        if (!folderPath.endsWith(PATH_DELIMITER)) {
            folderPath = folderPath + PATH_DELIMITER;
        }
        this.store.storeEmptyFile(folderPath);
        return true;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        this.checkPermission(f, RangerAccessType.READ);
        LOG.debug("Open file [{}] to read, buffer [{}]", (Object)f, (Object)bufferSize);
        FileStatus fileStatus = this.getFileStatus(f);
        if (fileStatus.isDirectory()) {
            throw new FileNotFoundException("'" + f + "' is a directory");
        }
        LOG.info("Opening '" + f + "' for reading");
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        return new FSDataInputStream((InputStream)new BufferedFSInputStream((FSInputStream)new CosNFSInputStream(this.getConf(), this.store, this.statistics, key, fileStatus.getLen(), this.boundedIOThreadPool), bufferSize));
    }

    public boolean rename(Path src, Path dst) throws IOException {
        FileStatus srcFileStatus;
        block13: {
            Path dstParentPath;
            LOG.debug("Rename the source path [{}] to the dest path [{}].", (Object)src, (Object)dst);
            this.checkPermission(src, RangerAccessType.DELETE);
            this.checkPermission(dst, RangerAccessType.WRITE);
            if (src.isRoot()) {
                LOG.debug("Cannot rename the root directory of a filesystem.");
                return false;
            }
            try {
                srcFileStatus = this.getFileStatus(src);
            }
            catch (FileNotFoundException e) {
                LOG.debug("The source path [{}] is not exist.", (Object)src);
                return false;
            }
            if (src.equals((Object)dst)) {
                LOG.debug("The source path and the dest path refer to the same file or directory: {}", (Object)dst);
                throw new IOException("the source path and dest path refer to the same file or directory");
            }
            for (dstParentPath = dst.getParent(); null != dstParentPath && !src.equals((Object)dstParentPath); dstParentPath = dstParentPath.getParent()) {
            }
            if (null != dstParentPath) {
                LOG.debug("It is not allowed to rename a parent directory:{} to its subdirectory:{}.", (Object)src, (Object)dst);
                throw new IOException(String.format("It is not allowed to rename a parent directory:%s to its subdirectory:%s", src, dst));
            }
            FileStatus dstFileStatus = null;
            try {
                FileStatus[] statuses;
                dstFileStatus = this.getFileStatus(dst);
                if (dstFileStatus.isFile()) {
                    LOG.debug("File: {} already exists.", (Object)dstFileStatus.getPath());
                    return false;
                }
                dst = new Path(dst, src.getName());
                try {
                    statuses = this.listStatus(dst);
                }
                catch (FileNotFoundException e) {
                    statuses = null;
                }
                if (null != statuses && statuses.length > 0) {
                    LOG.debug("Cannot rename {} to {}, file already exists.", (Object)src, (Object)dst);
                    return false;
                }
            }
            catch (FileNotFoundException e) {
                Path tempDstParentPath = dst.getParent();
                FileStatus dstParentStatus = this.getFileStatus(tempDstParentPath);
                if (dstParentStatus.isDirectory()) break block13;
                throw new IOException(String.format("Cannot rename %s to %s, %s is a file", src, dst, dst.getParent()));
            }
        }
        if (!this.isMergeBucket) {
            return this.internalCopyAndDelete(src, dst, srcFileStatus.isDirectory());
        }
        return this.internalRename(src, dst);
    }

    private boolean internalCopyAndDelete(Path srcPath, Path dstPath, boolean isDir) throws IOException {
        boolean result = false;
        result = isDir ? this.copyDirectory(srcPath, dstPath) : this.copyFile(srcPath, dstPath);
        if (!result) {
            return false;
        }
        return this.delete(srcPath, true);
    }

    private boolean internalRename(Path srcPath, Path dstPath) throws IOException {
        String srcKey = CosFileSystem.pathToKey(srcPath);
        String dstKey = CosFileSystem.pathToKey(dstPath);
        this.store.rename(srcKey, dstKey);
        return true;
    }

    private boolean copyFile(Path srcPath, Path dstPath) throws IOException {
        String srcKey = CosFileSystem.pathToKey(srcPath);
        String dstKey = CosFileSystem.pathToKey(dstPath);
        this.store.copy(srcKey, dstKey);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyDirectory(Path srcPath, Path dstPath) throws IOException {
        CosNPartialListing objectList;
        String dstKey;
        String srcKey = CosFileSystem.pathToKey(srcPath);
        if (!srcKey.endsWith(PATH_DELIMITER)) {
            srcKey = srcKey + PATH_DELIMITER;
        }
        if (!(dstKey = CosFileSystem.pathToKey(dstPath)).endsWith(PATH_DELIMITER)) {
            dstKey = dstKey + PATH_DELIMITER;
        }
        if (dstKey.startsWith(srcKey)) {
            throw new IOException("can not copy a directory to a subdirectory of self");
        }
        if (this.store.retrieveMetadata(srcKey) == null) {
            this.store.storeEmptyFile(srcKey);
        } else {
            this.store.copy(srcKey, dstKey);
        }
        CosNCopyFileContext copyFileContext = new CosNCopyFileContext();
        int copiesToFinishes = 0;
        String priorLastKey = null;
        block5: do {
            objectList = this.store.list(srcKey, this.normalBucketMaxListNum, priorLastKey, true);
            for (FileMetadata file : objectList.getFiles()) {
                this.boundedCopyThreadPool.execute(new CosNCopyFileTask(this.store, file.getKey(), dstKey.concat(file.getKey().substring(srcKey.length())), copyFileContext));
                ++copiesToFinishes;
                if (!copyFileContext.isCopySuccess()) continue block5;
            }
        } while (null != (priorLastKey = objectList.getPriorLastKey()));
        copyFileContext.lock();
        try {
            copyFileContext.awaitAllFinish(copiesToFinishes);
        }
        catch (InterruptedException e) {
            LOG.warn("interrupted when wait copies to finish");
        }
        finally {
            copyFileContext.unlock();
        }
        return copyFileContext.isCopySuccess();
    }

    private void createParentDirectoryIfNecessary(Path path) throws IOException {
        String parentKey;
        Path parent = path.getParent();
        if (!(null == parent || parent.isRoot() || StringUtils.isNullOrEmpty((String)(parentKey = CosFileSystem.pathToKey(parent))) || this.exists(parent))) {
            LOG.debug("Create a parent directory [{}] for the path [{}].", (Object)parent, (Object)path);
            if (!parentKey.endsWith(PATH_DELIMITER)) {
                parentKey = parentKey + PATH_DELIMITER;
            }
            this.store.storeEmptyFile(parentKey);
        }
    }

    public long getDefaultBlockSize() {
        return this.getConf().getLong("fs.cosn.block.size", 0x8000000L);
    }

    public void setWorkingDirectory(Path newDir) {
        this.workingDir = newDir;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initRangerClientImpl(Configuration conf) throws IOException {
        Class<?>[] cosClasses = CosNUtils.loadCosProviderClasses(conf, "fs.cosn.credentials.provider", new Class[0]);
        if (cosClasses.length == 0) {
            this.enableRangerPluginPermissionCheck = false;
            return;
        }
        for (Class<?> credClass : cosClasses) {
            if (!credClass.getName().contains(RangerCredentialsProvider.class.getName())) continue;
            this.enableRangerPluginPermissionCheck = true;
            break;
        }
        if (!this.enableRangerPluginPermissionCheck) {
            return;
        }
        Class rangerClientImplClass = conf.getClass("fs.cosn.ranger.plugin.client.impl", null);
        if (rangerClientImplClass == null) {
            try {
                rangerClientImplClass = conf.getClassByName("org.apache.hadoop.fs.cosn.ranger.client.RangerQcloudObjectStorageClientImpl");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (rangerQcloudObjectStorageStorageClient != null) return;
        Class<CosFileSystem> clazz = CosFileSystem.class;
        synchronized (CosFileSystem.class) {
            if (rangerQcloudObjectStorageStorageClient != null) return;
            try {
                RangerQcloudObjectStorageClient tmpClient = (RangerQcloudObjectStorageClient)rangerClientImplClass.newInstance();
                tmpClient.init(conf);
                rangerQcloudObjectStorageStorageClient = tmpClient;
            }
            catch (Exception e) {
                LOG.error(String.format("init %s failed", "fs.cosn.ranger.plugin.client.impl"), (Throwable)e);
                throw new IOException(String.format("init %s failed", "fs.cosn.ranger.plugin.client.impl"), e);
            }
            return;
        }
    }

    public String getCanonicalServiceName() {
        if (rangerQcloudObjectStorageStorageClient != null) {
            return rangerQcloudObjectStorageStorageClient.getCanonicalServiceName();
        }
        return null;
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        Preconditions.checkArgument((length >= 0L ? 1 : 0) != 0);
        LOG.debug("call the checksum for the path: {}.", (Object)f);
        this.checkPermission(f, RangerAccessType.READ);
        if (this.getConf().getBoolean("fs.cosn.crc64.checksum.enabled", false)) {
            Path absolutePath = this.makeAbsolute(f);
            String key = CosFileSystem.pathToKey(absolutePath);
            FileMetadata fileMetadata = this.store.retrieveMetadata(key);
            if (null == fileMetadata) {
                throw new FileNotFoundException("File or directory doesn't exist: " + f);
            }
            String crc64ecm = fileMetadata.getCrc64ecm();
            return crc64ecm != null ? new CRC64Checksum(crc64ecm) : super.getFileChecksum(f, length);
        }
        if (this.getConf().getBoolean("fs.cosn.crc32c.checksum.enabled", false)) {
            Path absolutePath = this.makeAbsolute(f);
            String key = CosFileSystem.pathToKey(absolutePath);
            FileMetadata fileMetadata = this.store.retrieveMetadata(key);
            if (null == fileMetadata) {
                throw new FileNotFoundException("File or directory doesn't exist: " + f);
            }
            String crc32cm = fileMetadata.getCrc32cm();
            return crc32cm != null ? new CRC32CCheckSum(crc32cm) : super.getFileChecksum(f, length);
        }
        return super.getFileChecksum(f, length);
    }

    public void setXAttr(Path f, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        LOG.debug("set XAttr: {}.", (Object)f);
        this.checkPermission(f, RangerAccessType.WRITE);
        if (name.getBytes(METADATA_ENCODING).length + value.length > 1024) {
            throw new HadoopIllegalArgumentException(String.format("The maximum combined size of the name and value of an extended attribute in bytes should be less than or equal to %d", 1024));
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        boolean xAttrExists = null != fileMetadata.getUserAttributes() && fileMetadata.getUserAttributes().containsKey(name);
        XAttrSetFlag.validate((String)name, (boolean)xAttrExists, flag);
        if (fileMetadata.isFile()) {
            this.store.storeFileAttribute(key, name, value);
        } else {
            this.store.storeDirAttribute(key, name, value);
        }
    }

    public byte[] getXAttr(Path f, String name) throws IOException {
        LOG.debug("get XAttr: {}.", (Object)f);
        this.checkPermission(f, RangerAccessType.READ);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        if (null != fileMetadata.getUserAttributes()) {
            return fileMetadata.getUserAttributes().get(name);
        }
        return null;
    }

    public Map<String, byte[]> getXAttrs(Path f, List<String> names) throws IOException {
        LOG.debug("get XAttrs: {}.", (Object)f);
        this.checkPermission(f, RangerAccessType.READ);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        HashMap<String, byte[]> attrs = null;
        if (null != fileMetadata.getUserAttributes()) {
            attrs = new HashMap<String, byte[]>();
            for (String name : names) {
                if (!fileMetadata.getUserAttributes().containsKey(name)) continue;
                attrs.put(name, fileMetadata.getUserAttributes().get(name));
            }
        }
        return attrs;
    }

    public Map<String, byte[]> getXAttrs(Path f) throws IOException {
        LOG.debug("get XAttrs: {}.", (Object)f);
        this.checkPermission(f, RangerAccessType.READ);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        return fileMetadata.getUserAttributes();
    }

    public void removeXAttr(Path f, String name) throws IOException {
        boolean xAttrExists;
        LOG.debug("remove XAttr: {}.", (Object)f);
        this.checkPermission(f, RangerAccessType.WRITE);
        Path absolutPath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutPath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        boolean bl = xAttrExists = null != fileMetadata.getUserAttributes() && fileMetadata.getUserAttributes().containsKey(name);
        if (xAttrExists) {
            if (fileMetadata.isFile()) {
                this.store.removeFileAttribute(key, name);
            } else {
                this.store.removeDirAttribute(key, name);
            }
        }
    }

    public List<String> listXAttrs(Path f) throws IOException {
        LOG.debug("list XAttrs: {}.", (Object)f);
        this.checkPermission(f, RangerAccessType.READ);
        Path absolutePath = this.makeAbsolute(f);
        String key = CosFileSystem.pathToKey(absolutePath);
        FileMetadata fileMetadata = this.store.retrieveMetadata(key);
        if (null == fileMetadata) {
            throw new FileNotFoundException("File or directory doesn't exist: " + f);
        }
        return new ArrayList<String>(fileMetadata.getUserAttributes().keySet());
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        LOG.info("getDelegationToken, renewer: {}, stack: {}", (Object)renewer, (Object)Arrays.toString(Thread.currentThread().getStackTrace()).replace(',', '\n'));
        if (rangerQcloudObjectStorageStorageClient != null) {
            return rangerQcloudObjectStorageStorageClient.getDelegationToken(renewer);
        }
        return super.getDelegationToken(renewer);
    }

    private void checkPermission(Path f, RangerAccessType rangerAccessType) throws IOException {
        if (!this.enableRangerPluginPermissionCheck) {
            return;
        }
        AccessType accessType = null;
        switch (rangerAccessType) {
            case LIST: {
                accessType = AccessType.LIST;
                break;
            }
            case WRITE: {
                accessType = AccessType.WRITE;
                break;
            }
            case READ: {
                accessType = AccessType.READ;
                break;
            }
            case DELETE: {
                accessType = AccessType.DELETE;
                break;
            }
            default: {
                throw new IOException(String.format("unknown access type %s", rangerAccessType.toString()));
            }
        }
        Path absolutePath = this.makeAbsolute(f);
        String allowKey = CosFileSystem.pathToKey(absolutePath);
        if (allowKey.startsWith(PATH_DELIMITER)) {
            allowKey = allowKey.substring(1);
        }
        PermissionRequest permissionReq = new PermissionRequest(ServiceType.COS, accessType, this.formatBucket, allowKey, "", "");
        boolean allowed = false;
        PermissionResponse permission = rangerQcloudObjectStorageStorageClient.checkPermission(permissionReq);
        if (permission != null) {
            allowed = permission.isAllowed();
        }
        if (!allowed) {
            throw new IOException(String.format("Permission denied, [key: %s], [user: %s], [operation: %s]", allowKey, this.currentUser.getShortUserName(), rangerAccessType.name()));
        }
    }

    public void close() throws IOException {
        LOG.info("begin to close cos file system");
        try {
            super.close();
        }
        finally {
            this.store.close();
            this.boundedIOThreadPool.shutdown();
            this.boundedCopyThreadPool.shutdown();
            BufferPool.getInstance().close();
        }
    }

    public NativeFileSystemStore getStore() {
        return this.store;
    }
}

