/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.cos.util;

import com.tencent.cloud.cos.util.Sign;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.net.ssl.HttpsURLConnection;

public class Request {
    protected static String requestUrl = "";
    protected static String rawResponse = "";
    protected static int connectTimeout = 5000;
    protected static int readTimeout = 90000;

    public static String getRequestUrl() {
        return requestUrl;
    }

    public static String getRawResponse() {
        return rawResponse;
    }

    public static String generateUrl(TreeMap<String, Object> params, String secretId, String secretKey, String requestMethod, String requestHost, String requestPath) {
        if (!params.containsKey("SecretId")) {
            params.put("SecretId", secretId);
        }
        if (!params.containsKey("Nonce")) {
            params.put("Nonce", new Random().nextInt(Integer.MAX_VALUE));
        }
        if (!params.containsKey("Timestamp")) {
            params.put("Timestamp", System.currentTimeMillis() / 1000L);
        }
        String plainText = Sign.makeSignPlainText(params, requestMethod, requestHost, requestPath);
        String signatureMethod = "HmacSHA1";
        if (params.containsKey("SignatureMethod") && params.get("SignatureMethod").toString().equals("HmacSHA256")) {
            signatureMethod = "HmacSHA256";
        }
        try {
            params.put("Signature", Sign.sign(plainText, secretKey, signatureMethod));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        StringBuilder url = new StringBuilder("https://");
        url.append(requestHost).append(requestPath).append("?");
        if (requestMethod.equals("GET")) {
            for (String k : params.keySet()) {
                try {
                    url.append(k.replace("_", ".")).append("=").append(URLEncoder.encode(params.get(k).toString(), "utf-8")).append("&");
                }
                catch (UnsupportedEncodingException e) {
                    return "https://" + requestHost + requestPath;
                }
            }
        }
        return url.toString().substring(0, url.length() - 1);
    }

    public static String send(TreeMap<String, Object> params, String secretId, String secretKey, String requestMethod, String requestHost, String stsHost, String requestPath) {
        if (!params.containsKey("SecretId")) {
            params.put("SecretId", secretId);
        }
        if (!params.containsKey("Nonce")) {
            params.put("Nonce", new Random().nextInt(Integer.MAX_VALUE));
        }
        if (!params.containsKey("Timestamp")) {
            params.put("Timestamp", System.currentTimeMillis() / 1000L);
        }
        params.remove("Signature");
        String plainText = Sign.makeSignPlainText(params, requestMethod, stsHost, requestPath);
        String signatureMethod = "HmacSHA1";
        if (params.containsKey("SignatureMethod") && params.get("SignatureMethod").toString().equals("HmacSHA256")) {
            signatureMethod = "HmacSHA256";
        }
        try {
            params.put("Signature", Sign.sign(plainText, secretKey, signatureMethod));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        String url = "https://" + requestHost + requestPath;
        return Request.sendRequest(url, params, requestMethod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendRequest(String url, Map<String, Object> requestParams, String requestMethod) {
        String result = "";
        BufferedReader in = null;
        String paramStr = "";
        for (String key : requestParams.keySet()) {
            if (!paramStr.isEmpty()) {
                paramStr = paramStr + '&';
            }
            try {
                paramStr = paramStr + key + '=' + URLEncoder.encode(requestParams.get(key).toString(), "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                result = "{\"code\":-2300,\"location\":\"com.qcloud.Common.Request:129\",\"message\":\"api sdk throw exception! " + e.toString().replace("\"", "\\\"") + "\"}";
            }
        }
        try {
            String line;
            if (requestMethod.equals("GET")) {
                url = url.indexOf(63) > 0 ? url + '&' + paramStr : url + '?' + paramStr;
            }
            requestUrl = url;
            URL realUrl = new URL(url);
            URLConnection connection = null;
            if (url.toLowerCase().startsWith("https")) {
                HttpsURLConnection httpsConn = (HttpsURLConnection)realUrl.openConnection();
                connection = httpsConn;
            } else {
                connection = realUrl.openConnection();
            }
            connection.setRequestProperty("accept", "*/*");
            connection.setRequestProperty("connection", "Keep-Alive");
            connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
            connection.setConnectTimeout(connectTimeout);
            connection.setReadTimeout(readTimeout);
            if (requestMethod.equals("POST")) {
                ((HttpURLConnection)connection).setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                ((OutputStream)out).write(paramStr.getBytes());
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
            }
            connection.connect();
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line;
            }
        }
        catch (Exception e) {
            result = "{\"code\":-2700,\"location\":\"com.qcloud.Common.Request:225\",\"message\":\"api sdk throw exception! " + e.toString().replace("\"", "\\\"") + "\"}";
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                result = "{\"code\":-2800,\"location\":\"com.qcloud.Common.Request:234\",\"message\":\"api sdk throw exception! " + e2.toString().replace("\"", "\\\"") + "\"}";
            }
        }
        rawResponse = result;
        return result;
    }
}

