/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class TokenUtil {
    private static final Map<String, Integer> TOKEN_NAME_TO_VALUE = TokenUtil.nameToValueMapFromPublicIntFields(TokenTypes.class);
    private static final String[] TOKEN_VALUE_TO_NAME = TokenUtil.valueToNameArrayFromNameToValueMap(TOKEN_NAME_TO_VALUE);
    private static final int[] TOKEN_IDS = TOKEN_NAME_TO_VALUE.values().stream().mapToInt(Integer::intValue).toArray();
    private static final String TOKEN_ID_EXCEPTION_FORMAT = "unknown TokenTypes id '%s'";
    private static final String TOKEN_NAME_EXCEPTION_FORMAT = "unknown TokenTypes value '%s'";

    private TokenUtil() {
    }

    public static int getIntFromField(Field field, Object object) {
        try {
            return field.getInt(object);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public static Map<String, Integer> nameToValueMapFromPublicIntFields(Class<?> cls) {
        Map<String, Integer> map = Arrays.stream(cls.getDeclaredFields()).filter(fld -> Modifier.isPublic(fld.getModifiers()) && fld.getType() == Integer.TYPE).collect(Collectors.toMap(Field::getName, fld -> TokenUtil.getIntFromField(fld, fld.getName())));
        return Collections.unmodifiableMap(map);
    }

    public static String[] valueToNameArrayFromNameToValueMap(Map<String, Integer> map) {
        String[] valueToNameArray = CommonUtil.EMPTY_STRING_ARRAY;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            int value = entry.getValue();
            if (value < 0) continue;
            if (value >= valueToNameArray.length) {
                String[] temp = new String[value + 1];
                System.arraycopy(valueToNameArray, 0, temp, 0, valueToNameArray.length);
                valueToNameArray = temp;
            }
            valueToNameArray[value] = entry.getKey();
        }
        return valueToNameArray;
    }

    public static int getTokenTypesTotalNumber() {
        return TOKEN_IDS.length;
    }

    public static int[] getAllTokenIds() {
        int[] safeCopy = new int[TOKEN_IDS.length];
        System.arraycopy(TOKEN_IDS, 0, safeCopy, 0, TOKEN_IDS.length);
        return safeCopy;
    }

    public static String getTokenName(int id) {
        if (id > TOKEN_VALUE_TO_NAME.length - 1) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, TOKEN_ID_EXCEPTION_FORMAT, id));
        }
        String name = TOKEN_VALUE_TO_NAME[id];
        if (name == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, TOKEN_ID_EXCEPTION_FORMAT, id));
        }
        return name;
    }

    public static int getTokenId(String name) {
        Integer id = TOKEN_NAME_TO_VALUE.get(name);
        if (id == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, TOKEN_NAME_EXCEPTION_FORMAT, name));
        }
        return id;
    }

    public static String getShortDescription(String name) {
        if (!TOKEN_NAME_TO_VALUE.containsKey(name)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, TOKEN_NAME_EXCEPTION_FORMAT, name));
        }
        String tokenTypes = "com.puppycrawl.tools.checkstyle.api.tokentypes";
        ResourceBundle bundle = ResourceBundle.getBundle("com.puppycrawl.tools.checkstyle.api.tokentypes", Locale.ROOT);
        return bundle.getString(name);
    }

    public static boolean isCommentType(int type) {
        return type == 144 || type == 145 || type == 182 || type == 183;
    }

    public static boolean isCommentType(String type) {
        return TokenUtil.isCommentType(TokenUtil.getTokenId(type));
    }

    public static Optional<DetailAST> findFirstTokenByPredicate(DetailAST root, Predicate<DetailAST> predicate) {
        Optional<DetailAST> result = Optional.empty();
        for (DetailAST ast = root.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            if (!predicate.test(ast)) continue;
            result = Optional.of(ast);
            break;
        }
        return result;
    }

    public static void forEachChild(DetailAST root, int type, Consumer<DetailAST> action) {
        for (DetailAST ast = root.getFirstChild(); ast != null; ast = ast.getNextSibling()) {
            if (ast.getType() != type) continue;
            action.accept(ast);
        }
    }

    public static boolean areOnSameLine(DetailAST ast1, DetailAST ast2) {
        return ast1.getLineNo() == ast2.getLineNo();
    }

    public static boolean isTypeDeclaration(int type) {
        return type == 14 || type == 15 || type == 157 || type == 154 || type == 199;
    }

    public static boolean isOfType(int type, int ... types) {
        return Arrays.stream(types).anyMatch(tokenType -> tokenType == type);
    }

    public static boolean isOfType(DetailAST ast, int ... types) {
        return ast != null && TokenUtil.isOfType(ast.getType(), types);
    }
}

