/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.ArrayInitHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.CaseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.CatchHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ClassDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.DoWhileHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ElseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.FinallyHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ForHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IfHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ImportHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndexHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.LabelHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MemberDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodCallHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.NewHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.ObjectBlockHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.PackageDefHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SlistHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.StaticInitHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SwitchHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.SynchronizedHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.TryHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.WhileHandler;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HandlerFactory {
    private static final Log LOG = LogFactory.getLog(HandlerFactory.class);
    private final Map<Integer, Constructor<?>> typeHandlers = Maps.newHashMap();
    private final Map<DetailAST, ExpressionHandler> createdHandlers = Maps.newHashMap();

    public HandlerFactory() {
        this.register(33, CaseHandler.class);
        this.register(89, SwitchHandler.class);
        this.register(7, SlistHandler.class);
        this.register(16, PackageDefHandler.class);
        this.register(92, ElseHandler.class);
        this.register(83, IfHandler.class);
        this.register(95, TryHandler.class);
        this.register(96, CatchHandler.class);
        this.register(97, FinallyHandler.class);
        this.register(85, DoWhileHandler.class);
        this.register(84, WhileHandler.class);
        this.register(91, ForHandler.class);
        this.register(9, MethodDefHandler.class);
        this.register(8, MethodDefHandler.class);
        this.register(14, ClassDefHandler.class);
        this.register(154, ClassDefHandler.class);
        this.register(6, ObjectBlockHandler.class);
        this.register(15, ClassDefHandler.class);
        this.register(30, ImportHandler.class);
        this.register(29, ArrayInitHandler.class);
        this.register(27, MethodCallHandler.class);
        this.register(43, MethodCallHandler.class);
        this.register(22, LabelHandler.class);
        this.register(12, StaticInitHandler.class);
        this.register(11, SlistHandler.class);
        this.register(10, MemberDefHandler.class);
        this.register(136, NewHandler.class);
        this.register(24, IndexHandler.class);
        this.register(67, SynchronizedHandler.class);
    }

    private void register(int type, Class<?> handlerClass) {
        try {
            Constructor<?> ctor = handlerClass.getConstructor(IndentationCheck.class, DetailAST.class, ExpressionHandler.class);
            this.typeHandlers.put(type, ctor);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String message = "couldn't find ctor for " + handlerClass;
            LOG.debug((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
    }

    public boolean isHandledType(int type) {
        Set<Integer> typeSet = this.typeHandlers.keySet();
        return typeSet.contains(type);
    }

    public int[] getHandledTypes() {
        Set<Integer> typeSet = this.typeHandlers.keySet();
        int[] types = new int[typeSet.size()];
        int index = 0;
        for (Integer val : typeSet) {
            types[index++] = val;
        }
        return types;
    }

    public ExpressionHandler getHandler(IndentationCheck indentCheck, DetailAST ast, ExpressionHandler parent) {
        ExpressionHandler handler = this.createdHandlers.get((Object)ast);
        if (handler != null) {
            return handler;
        }
        if (ast.getType() == 27) {
            return this.createMethodCallHandler(indentCheck, ast, parent);
        }
        ExpressionHandler expHandler = null;
        try {
            Constructor<?> handlerCtor = this.typeHandlers.get(ast.getType());
            if (handlerCtor != null) {
                expHandler = (ExpressionHandler)handlerCtor.newInstance(new Object[]{indentCheck, ast, parent});
            }
        }
        catch (InstantiationException | InvocationTargetException e) {
            String message = "couldn't instantiate constructor for " + (Object)((Object)ast);
            LOG.debug((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        catch (IllegalAccessException e) {
            String message = "couldn't access constructor for " + (Object)((Object)ast);
            LOG.debug((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        if (expHandler == null) {
            throw new RuntimeException("no handler for type " + ast.getType());
        }
        return expHandler;
    }

    ExpressionHandler createMethodCallHandler(IndentationCheck indentCheck, DetailAST ast, ExpressionHandler parent) {
        DetailAST astNode;
        ExpressionHandler theParent = parent;
        for (astNode = ast.getFirstChild(); astNode != null && astNode.getType() == 59; astNode = astNode.getFirstChild()) {
        }
        if (astNode != null && this.isHandledType(astNode.getType())) {
            theParent = this.getHandler(indentCheck, astNode, theParent);
            this.createdHandlers.put(astNode, theParent);
        }
        return new MethodCallHandler(indentCheck, ast, theParent);
    }

    void clearCreatedHandlers() {
        this.createdHandlers.clear();
    }
}

