/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Lists;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;

public class AvoidStarImportCheck
extends Check {
    public static final String MSG_KEY = "import.avoidStar";
    private final List<String> excludes = Lists.newArrayList();
    private boolean allowClassImports;
    private boolean allowStaticMemberImports;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{30, 152};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{30, 152};
    }

    public void setExcludes(String ... excludesParam) {
        this.excludes.clear();
        for (String exclude : excludesParam) {
            this.excludes.add(exclude.endsWith(".*") ? exclude : exclude + ".*");
        }
    }

    public void setAllowClassImports(boolean allow) {
        this.allowClassImports = allow;
    }

    public void setAllowStaticMemberImports(boolean allow) {
        this.allowStaticMemberImports = allow;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!this.allowClassImports && 30 == ast.getType()) {
            DetailAST startingDot = ast.getFirstChild();
            this.logsStarredImportViolation(startingDot);
        } else if (!this.allowStaticMemberImports && 152 == ast.getType()) {
            DetailAST startingDot = ast.getFirstChild().getNextSibling();
            this.logsStarredImportViolation(startingDot);
        }
    }

    private void logsStarredImportViolation(DetailAST startingDot) {
        FullIdent name = FullIdent.createFullIdent(startingDot);
        if (this.isStaredImport(name) && !this.excludes.contains(name.getText())) {
            this.log(startingDot.getLineNo(), MSG_KEY, name.getText());
        }
    }

    private boolean isStaredImport(FullIdent importIdent) {
        return null != importIdent && importIdent.getText().endsWith(".*");
    }
}

