/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Locale;
import org.apache.commons.beanutils.ConversionException;

public final class AnnotationUseStyleCheck
extends Check {
    public static final String MSG_KEY_ANNOTATION_INCORRECT_STYLE = "annotation.incorrect.style";
    public static final String MSG_KEY_ANNOTATION_PARENS_MISSING = "annotation.parens.missing";
    public static final String MSG_KEY_ANNOTATION_PARENS_PRESENT = "annotation.parens.present";
    public static final String MSG_KEY_ANNOTATION_TRAILING_COMMA_MISSING = "annotation.trailing.comma.missing";
    public static final String MSG_KEY_ANNOTATION_TRAILING_COMMA_PRESENT = "annotation.trailing.comma.present";
    private static final String ANNOTATION_ELEMENT_SINGLE_NAME = "value";
    private ElementStyle style = ElementStyle.COMPACT_NO_ARRAY;
    private TrailingArrayComma comma = TrailingArrayComma.NEVER;
    private ClosingParens parens = ClosingParens.NEVER;

    public void setElementStyle(String style) {
        this.style = this.getOption(ElementStyle.class, style);
    }

    public void setTrailingArrayComma(String comma) {
        this.comma = this.getOption(TrailingArrayComma.class, comma);
    }

    public void setClosingParens(String parens) {
        this.parens = this.getOption(ClosingParens.class, parens);
    }

    private <T extends Enum<T>> T getOption(Class<T> enuclass, String string) {
        try {
            return Enum.valueOf(enuclass, string.trim().toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + string, (Throwable)iae);
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{159};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.checkStyleType(ast);
        this.checkCheckClosingParens(ast);
        this.checkTrailingComma(ast);
    }

    private void checkStyleType(DetailAST annotation) {
        if (ElementStyle.IGNORE == this.style || this.style == null) {
            return;
        }
        if (ElementStyle.COMPACT_NO_ARRAY == this.style) {
            this.checkCompactNoArrayStyle(annotation);
        } else if (ElementStyle.COMPACT == this.style) {
            this.checkCompactStyle(annotation);
        } else if (ElementStyle.EXPANDED == this.style) {
            this.checkExpandedStyle(annotation);
        }
    }

    private void checkExpandedStyle(DetailAST annotation) {
        int valuePairCount = annotation.getChildCount(160);
        if (valuePairCount == 0 && annotation.branchContains(28)) {
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyle.EXPANDED});
        }
    }

    private void checkCompactStyle(DetailAST annotation) {
        int valuePairCount = annotation.getChildCount(160);
        DetailAST valuePair = annotation.findFirstToken(160);
        if (valuePairCount == 1 && ANNOTATION_ELEMENT_SINGLE_NAME.equals(valuePair.getFirstChild().getText())) {
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyle.COMPACT});
        }
    }

    private void checkCompactNoArrayStyle(DetailAST annotation) {
        DetailAST nestedArrayInit;
        DetailAST arrayInit = annotation.findFirstToken(162);
        int valuePairCount = annotation.getChildCount(160);
        DetailAST valuePair = annotation.findFirstToken(160);
        if (arrayInit != null && arrayInit.getChildCount(28) == 1) {
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyle.COMPACT_NO_ARRAY});
        } else if (valuePairCount == 1 && (nestedArrayInit = valuePair.findFirstToken(162)) != null && ANNOTATION_ELEMENT_SINGLE_NAME.equals(valuePair.getFirstChild().getText()) && nestedArrayInit.getChildCount(28) == 1) {
            this.log(annotation.getLineNo(), MSG_KEY_ANNOTATION_INCORRECT_STYLE, new Object[]{ElementStyle.COMPACT_NO_ARRAY});
        }
    }

    private void checkTrailingComma(DetailAST annotation) {
        if (TrailingArrayComma.IGNORE == this.comma || this.comma == null) {
            return;
        }
        for (DetailAST child = annotation.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST arrayInit = null;
            if (child.getType() == 160) {
                arrayInit = child.findFirstToken(162);
            } else if (child.getType() == 162) {
                arrayInit = child;
            }
            if (arrayInit == null) continue;
            this.logCommaViolation(arrayInit);
        }
    }

    private void logCommaViolation(DetailAST ast) {
        DetailAST rCurly = ast.findFirstToken(73);
        DetailAST comma = rCurly.getPreviousSibling();
        if (TrailingArrayComma.ALWAYS == this.comma && (comma == null || comma.getType() != 74)) {
            this.log(rCurly.getLineNo(), rCurly.getColumnNo(), MSG_KEY_ANNOTATION_TRAILING_COMMA_MISSING, new Object[0]);
        } else if (TrailingArrayComma.NEVER == this.comma && comma != null && comma.getType() == 74) {
            this.log(comma.getLineNo(), comma.getColumnNo(), MSG_KEY_ANNOTATION_TRAILING_COMMA_PRESENT, new Object[0]);
        }
    }

    private void checkCheckClosingParens(DetailAST ast) {
        boolean parenExists;
        if (ClosingParens.IGNORE == this.parens || this.parens == null) {
            return;
        }
        DetailAST paren = ast.getLastChild();
        boolean bl = parenExists = paren.getType() == 77;
        if (ClosingParens.ALWAYS == this.parens && !parenExists) {
            this.log(ast.getLineNo(), MSG_KEY_ANNOTATION_PARENS_MISSING, new Object[0]);
        } else if (ClosingParens.NEVER == this.parens && !ast.branchContains(28) && !ast.branchContains(160) && !ast.branchContains(162) && parenExists) {
            this.log(ast.getLineNo(), MSG_KEY_ANNOTATION_PARENS_PRESENT, new Object[0]);
        }
    }

    public static enum ClosingParens {
        ALWAYS,
        NEVER,
        IGNORE;

    }

    public static enum TrailingArrayComma {
        ALWAYS,
        NEVER,
        IGNORE;

    }

    public static enum ElementStyle {
        EXPANDED,
        COMPACT,
        COMPACT_NO_ARRAY,
        IGNORE;

    }
}

