/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.captcha.utils;

import com.pig4cloud.captcha.utils.FileUtil;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FontsUtil {
    public static Font getFont(String fontName, int style, float size) {
        Font font = null;
        String path = System.getProperty("java.io.tmpdir");
        File tempFontFile = new File(path + File.separator + fontName);
        if (!tempFontFile.exists()) {
            FontsUtil.copyTempFontFile(fontName, tempFontFile);
        }
        if (tempFontFile.exists()) {
            try {
                font = Font.createFont(0, tempFontFile).deriveFont(style, size);
            }
            catch (FontFormatException | IOException e) {
                e.printStackTrace();
                tempFontFile.delete();
            }
        }
        return font;
    }

    private static synchronized void copyTempFontFile(String fontName, File tempFontFile) {
        try (InputStream is = FontsUtil.class.getResourceAsStream("/" + fontName);){
            FileUtil.copyToFile(is, tempFontFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

