/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.captcha.base;

import com.googlecode.aviator.AviatorEvaluator;
import com.pig4cloud.captcha.base.Captcha;
import com.pig4cloud.captcha.engine.Symbol;
import java.util.ArrayList;

public abstract class ArithmeticCaptchaAbstract
extends Captcha {
    private String arithmeticString;
    protected static int difficulty = 10;
    protected static int algorithmSign = 4;

    public ArithmeticCaptchaAbstract() {
        this.setLen(2);
    }

    @Override
    protected char[] alphas() {
        ArrayList<String> arithmeticList = new ArrayList<String>(this.len + this.len - 1);
        Symbol lastSymbol = null;
        int divAmount = 0;
        for (int i = 0; i < this.len; ++i) {
            int number = ArithmeticCaptchaAbstract.num(difficulty);
            if (lastSymbol == Symbol.DIV) {
                number = (number = (int)Math.sqrt(number)) == 0 ? 1 : number;
                arithmeticList.set(2 * (i - 1), String.valueOf(number * ArithmeticCaptchaAbstract.num((int)Math.sqrt(difficulty))));
            }
            if (lastSymbol == Symbol.SUB) {
                String firstNum = (String)arithmeticList.get(0);
                number = ArithmeticCaptchaAbstract.num(Integer.parseInt(firstNum) + 1);
            }
            arithmeticList.add(String.valueOf(number));
            if (i >= this.len - 1) continue;
            int type = divAmount == 1 ? ArithmeticCaptchaAbstract.num(1, algorithmSign - 1) : ArithmeticCaptchaAbstract.num(1, algorithmSign);
            if (type == 1) {
                lastSymbol = Symbol.ADD;
                arithmeticList.add(lastSymbol.getValue());
                continue;
            }
            if (type == 2) {
                lastSymbol = Symbol.SUB;
                arithmeticList.add(lastSymbol.getValue());
                continue;
            }
            if (type == 3) {
                lastSymbol = Symbol.MUL;
                arithmeticList.add(lastSymbol.getValue());
                continue;
            }
            if (type != 4) continue;
            lastSymbol = Symbol.DIV;
            arithmeticList.add(lastSymbol.getValue());
            ++divAmount;
        }
        this.arithmeticString = String.join((CharSequence)"", arithmeticList);
        this.chars = String.valueOf(AviatorEvaluator.execute((String)this.arithmeticString.replace("x", "*").replace("\u00f7", "/")));
        this.arithmeticString = this.arithmeticString + "=?";
        return this.chars.toCharArray();
    }

    public String getArithmeticString() {
        this.checkAlpha();
        return this.arithmeticString;
    }

    public void setArithmeticString(String arithmeticString) {
        this.arithmeticString = arithmeticString;
    }

    public void setDifficulty(int difficulty) {
        if (difficulty <= 0) {
            difficulty = 10;
        }
        ArithmeticCaptchaAbstract.difficulty = difficulty;
    }

    public void supportAlgorithmSign(int algorithmSign) {
        if (algorithmSign < 2) {
            algorithmSign = 2;
        }
        if (algorithmSign > 5) {
            algorithmSign = 5;
        }
        ArithmeticCaptchaAbstract.algorithmSign = algorithmSign;
    }
}

