/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.web;

import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.cluster.ServerStatus;
import com.alibaba.nacos.naming.cluster.ServerStatusManager;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class TrafficReviseFilter
implements Filter {
    @Autowired
    private ServerStatusManager serverStatusManager;
    @Autowired
    private SwitchDomain switchDomain;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String urlString = req.getRequestURI() + "?" + req.getQueryString();
        Map<String, Integer> limitedUrlMap = this.switchDomain.getLimitedUrlMap();
        if (limitedUrlMap != null && limitedUrlMap.size() > 0) {
            for (Map.Entry<String, Integer> entry : limitedUrlMap.entrySet()) {
                String limitedUrl = entry.getKey();
                if (!StringUtils.startsWith((CharSequence)urlString, (CharSequence)limitedUrl)) continue;
                resp.setStatus(entry.getValue().intValue());
                return;
            }
        }
        if (this.serverStatusManager.getServerStatus() == ServerStatus.UP) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        String agent = WebUtils.getUserAgent((HttpServletRequest)req);
        if (StringUtils.startsWith((CharSequence)agent, (CharSequence)"Nacos-Server")) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (this.serverStatusManager.getServerStatus() == ServerStatus.WRITE_ONLY && !"GET".equals(req.getMethod())) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        if (this.serverStatusManager.getServerStatus() == ServerStatus.READ_ONLY && "GET".equals(req.getMethod())) {
            filterChain.doFilter((ServletRequest)req, (ServletResponse)resp);
            return;
        }
        resp.getWriter().write("server is " + this.serverStatusManager.getServerStatus().name() + " now, please try again later!");
        resp.setStatus(503);
    }
}

