/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.misc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.selector.SelectorType;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.alibaba.nacos.naming.selector.LabelSelector;
import com.alibaba.nacos.naming.selector.NoneSelector;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class UtilsAndCommons {
    public static final String NACOS_SERVER_CONTEXT = "/nacos";
    public static final String NACOS_SERVER_VERSION = "/v1";
    public static final String DEFAULT_NACOS_NAMING_CONTEXT = "/v1/ns";
    public static final String NACOS_NAMING_CONTEXT = "/v1/ns";
    public static final String NACOS_NAMING_CATALOG_CONTEXT = "/catalog";
    public static final String NACOS_NAMING_INSTANCE_CONTEXT = "/instance";
    public static final String NACOS_NAMING_SERVICE_CONTEXT = "/service";
    public static final String NACOS_NAMING_CLUSTER_CONTEXT = "/cluster";
    public static final String NACOS_NAMING_HEALTH_CONTEXT = "/health";
    public static final String NACOS_NAMING_RAFT_CONTEXT = "/raft";
    public static final String NACOS_NAMING_PARTITION_CONTEXT = "/distro";
    public static final String NACOS_NAMING_OPERATOR_CONTEXT = "/operator";
    public static final String NACOS_SERVER_HEADER = "Nacos-Server";
    public static final String NACOS_VERSION = VersionUtils.version;
    public static final String SUPER_TOKEN = "xy";
    public static final String DOMAINS_DATA_ID_PRE = "com.alibaba.nacos.naming.domains.meta.";
    public static final String IPADDRESS_DATA_ID_PRE = "com.alibaba.nacos.naming.iplist.";
    public static final String SWITCH_DOMAIN_NAME = "00-00---000-NACOS_SWITCH_DOMAIN-000---00-00";
    public static final String CIDR_REGEX = "[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}/[0-9]+";
    public static final String UNKNOWN_SITE = "unknown";
    public static final String DEFAULT_CLUSTER_NAME = "DEFAULT";
    public static final String LOCALHOST_SITE = "unknown";
    public static final int RAFT_PUBLISH_TIMEOUT = 5000;
    public static final String SERVER_VERSION = "Nacos-Server:" + NACOS_VERSION;
    public static final String SELF_SERVICE_CLUSTER_ENV = "naming_self_service_cluster_ips";
    public static final String CACHE_KEY_SPLITER = "@@@@";
    public static final int MAX_PUBLISH_WAIT_TIME_MILLIS = 5000;
    public static final String VERSION_STRING_SYNTAX = "[0-9]+\\.[0-9]+\\.[0-9]+";
    public static final String API_UPDATE_SWITCH = "/api/updateSwitch";
    public static final String API_SET_ALL_WEIGHTS = "/api/setWeight4AllIPs";
    public static final String API_DOM = "/api/dom";
    public static final String NAMESPACE_SERVICE_CONNECTOR = "##";
    public static final String UPDATE_INSTANCE_ACTION_ADD = "add";
    public static final String UPDATE_INSTANCE_ACTION_REMOVE = "remove";
    public static final String UPDATE_INSTANCE_METADATA_ACTION_UPDATE = "update";
    public static final String UPDATE_INSTANCE_METADATA_ACTION_REMOVE = "remove";
    public static final String EPHEMERAL = "ephemeral";
    public static final String PERSIST = "persist";
    public static final String DATA_BASE_DIR = EnvUtil.getNacosHome() + File.separator + "data" + File.separator + "naming";
    public static final String RAFT_CACHE_FILE_PREFIX = "com.alibaba.nacos.naming";
    public static final String NUMBER_PATTERN = "^\\d+$";

    public static Map<String, String> parseMetadata(String metadata) throws NacosException {
        Map<String, String> metadataMap;
        block5: {
            metadataMap = new HashMap<String, String>(16);
            if (StringUtils.isBlank((CharSequence)metadata)) {
                return metadataMap;
            }
            try {
                metadataMap = (Map)JacksonUtils.toObj((String)metadata, (TypeReference)new TypeReference<Map<String, String>>(){});
            }
            catch (Exception e) {
                String[] datas = metadata.split(",");
                if (datas.length <= 0) break block5;
                for (String data : datas) {
                    String[] kv = data.split("=");
                    if (kv.length != 2) {
                        throw new NacosException(400, "metadata format incorrect:" + metadata);
                    }
                    metadataMap.put(kv[0], kv[1]);
                }
            }
        }
        return metadataMap;
    }

    public static String assembleFullServiceName(String namespaceId, String serviceName) {
        return namespaceId + NAMESPACE_SERVICE_CONNECTOR + serviceName;
    }

    public static int shakeUp(String string, int upperLimit) {
        if (upperLimit < 1) {
            throw new IllegalArgumentException("upper limit must be greater than 0");
        }
        if (string == null) {
            return 0;
        }
        return (string.hashCode() & Integer.MAX_VALUE) % upperLimit;
    }

    static {
        JacksonUtils.registerSubtype(NoneSelector.class, (String)SelectorType.none.name());
        JacksonUtils.registerSubtype(LabelSelector.class, (String)SelectorType.label.name());
    }
}

