/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck;

import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.naming.core.Cluster;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.healthcheck.HealthCheckTask;
import com.alibaba.nacos.naming.misc.GlobalExecutor;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NetUtils;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.alibaba.nacos.naming.push.PushService;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HealthCheckCommon {
    @Autowired
    private DistroMapper distroMapper;
    @Autowired
    private SwitchDomain switchDomain;
    @Autowired
    private ServerMemberManager memberManager;
    @Autowired
    private PushService pushService;
    private static LinkedBlockingDeque<HealthCheckResult> healthCheckResults = new LinkedBlockingDeque(131072);

    public void init() {
        GlobalExecutor.scheduleNamingHealthCheck(() -> {
            List<Object> list = Arrays.asList(healthCheckResults.toArray());
            healthCheckResults.clear();
            Collection sameSiteServers = this.memberManager.allMembers();
            if (sameSiteServers == null || sameSiteServers.size() <= 0) {
                return;
            }
            for (Member server : sameSiteServers) {
                RestResult<String> httpResult;
                if (server.getAddress().equals(NetUtils.localServer())) continue;
                HashMap<String, String> params = new HashMap<String, String>(10);
                params.put("result", JacksonUtils.toJson(list));
                if (Loggers.SRV_LOG.isDebugEnabled()) {
                    Loggers.SRV_LOG.debug("[HEALTH-SYNC] server: {}, healthCheckResults: {}", (Object)server, (Object)JacksonUtils.toJson(list));
                }
                if ((httpResult = HttpClient.httpPost("http://" + server.getAddress() + EnvUtil.getContextPath() + "/v1/ns" + "/api/healthCheckResult", null, params)).ok()) continue;
                Loggers.EVT_LOG.warn("[HEALTH-CHECK-SYNC] failed to send result to {}, result: {}", (Object)server, (Object)JacksonUtils.toJson(list));
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    public void reEvaluateCheckRT(long checkRT, HealthCheckTask task, SwitchDomain.HealthParams params) {
        task.setCheckRtLast(checkRT);
        if (checkRT > task.getCheckRtWorst()) {
            task.setCheckRtWorst(checkRT);
        }
        if (checkRT < task.getCheckRtBest()) {
            task.setCheckRtBest(checkRT);
        }
        if ((checkRT = (long)(params.getFactor() * (float)task.getCheckRtNormalized() + (1.0f - params.getFactor()) * (float)checkRT)) > (long)params.getMax()) {
            checkRT = params.getMax();
        }
        if (checkRT < (long)params.getMin()) {
            checkRT = params.getMin();
        }
        task.setCheckRtNormalized(checkRT);
    }

    public void checkOK(Instance ip, HealthCheckTask task, String msg) {
        Cluster cluster = task.getCluster();
        try {
            if (!ip.isHealthy() || !ip.isMockValid()) {
                if (ip.getOkCount().incrementAndGet() >= this.switchDomain.getCheckTimes()) {
                    if (this.distroMapper.responsible(cluster, ip)) {
                        ip.setHealthy(true);
                        ip.setMockValid(true);
                        Service service = cluster.getService();
                        service.setLastModifiedMillis(System.currentTimeMillis());
                        this.pushService.serviceChanged(service);
                        this.addResult(new HealthCheckResult(service.getName(), ip));
                        Loggers.EVT_LOG.info("serviceName: {} {POS} {IP-ENABLED} valid: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                    } else if (!ip.isMockValid()) {
                        ip.setMockValid(true);
                        Loggers.EVT_LOG.info("serviceName: {} {PROBE} {IP-ENABLED} valid: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                    }
                } else {
                    Loggers.EVT_LOG.info("serviceName: {} {OTHER} {IP-ENABLED} pre-valid: {}:{}@{} in {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), ip.getOkCount(), msg});
                }
            }
        }
        catch (Throwable t) {
            Loggers.SRV_LOG.error("[CHECK-OK] error when close check task.", t);
        }
        ip.getFailCount().set(0);
        ip.setBeingChecked(false);
    }

    public void checkFail(Instance ip, HealthCheckTask task, String msg) {
        Cluster cluster = task.getCluster();
        try {
            if (ip.isHealthy() || ip.isMockValid()) {
                if (ip.getFailCount().incrementAndGet() >= this.switchDomain.getCheckTimes()) {
                    if (this.distroMapper.responsible(cluster, ip)) {
                        ip.setHealthy(false);
                        ip.setMockValid(false);
                        Service service = cluster.getService();
                        service.setLastModifiedMillis(System.currentTimeMillis());
                        this.addResult(new HealthCheckResult(service.getName(), ip));
                        this.pushService.serviceChanged(service);
                        Loggers.EVT_LOG.info("serviceName: {} {POS} {IP-DISABLED} invalid: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                    } else {
                        Loggers.EVT_LOG.info("serviceName: {} {PROBE} {IP-DISABLED} invalid: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                    }
                } else {
                    Loggers.EVT_LOG.info("serviceName: {} {OTHER} {IP-DISABLED} pre-invalid: {}:{}@{} in {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), ip.getFailCount(), msg});
                }
            }
        }
        catch (Throwable t) {
            Loggers.SRV_LOG.error("[CHECK-FAIL] error when close check task.", t);
        }
        ip.getOkCount().set(0);
        ip.setBeingChecked(false);
    }

    public void checkFailNow(Instance ip, HealthCheckTask task, String msg) {
        Cluster cluster = task.getCluster();
        try {
            if (ip.isHealthy() || ip.isMockValid()) {
                if (this.distroMapper.responsible(cluster, ip)) {
                    ip.setHealthy(false);
                    ip.setMockValid(false);
                    Service service = cluster.getService();
                    service.setLastModifiedMillis(System.currentTimeMillis());
                    this.pushService.serviceChanged(service);
                    this.addResult(new HealthCheckResult(service.getName(), ip));
                    Loggers.EVT_LOG.info("serviceName: {} {POS} {IP-DISABLED} invalid-now: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                } else if (ip.isMockValid()) {
                    ip.setMockValid(false);
                    Loggers.EVT_LOG.info("serviceName: {} {PROBE} {IP-DISABLED} invalid-now: {}:{}@{}, region: {}, msg: {}", new Object[]{cluster.getService().getName(), ip.getIp(), ip.getPort(), cluster.getName(), "unknown", msg});
                }
            }
        }
        catch (Throwable t) {
            Loggers.SRV_LOG.error("[CHECK-FAIL-NOW] error when close check task.", t);
        }
        ip.getOkCount().set(0);
        ip.setBeingChecked(false);
    }

    private void addResult(HealthCheckResult result) {
        if (!this.switchDomain.getIncrementalList().contains(result.getServiceName())) {
            return;
        }
        if (!healthCheckResults.offer(result)) {
            Loggers.EVT_LOG.warn("[HEALTH-CHECK-SYNC] failed to add check result to queue, queue size: {}", (Object)healthCheckResults.size());
        }
    }

    static class HealthCheckResult {
        private String serviceName;
        private Instance instance;

        public HealthCheckResult(String serviceName, Instance instance) {
            this.serviceName = serviceName;
            this.instance = instance;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public void setInstance(Instance instance) {
            this.instance = instance;
        }
    }
}

