/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.pojo.Record;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Instances
implements Record {
    private static final long serialVersionUID = 5500823673993740145L;
    private List<Instance> instanceList = new ArrayList<Instance>();

    public List<Instance> getInstanceList() {
        return this.instanceList;
    }

    public void setInstanceList(List<Instance> instanceList) {
        this.instanceList = instanceList;
    }

    public String toString() {
        try {
            return JacksonUtils.toJson((Object)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Instances toJSON failed", e);
        }
    }

    @Override
    @JsonIgnore
    public String getChecksum() {
        return this.recalculateChecksum();
    }

    private String recalculateChecksum() {
        StringBuilder sb = new StringBuilder();
        Collections.sort(this.instanceList);
        for (Instance ip : this.instanceList) {
            String string = ip.getIp() + ":" + ip.getPort() + "_" + ip.getWeight() + "_" + ip.isHealthy() + "_" + ip.isEnabled() + "_" + ip.getClusterName() + "_" + this.convertMap2String(ip.getMetadata());
            sb.append(string);
            sb.append(",");
        }
        return MD5Utils.md5Hex((String)sb.toString(), (String)"UTF-8");
    }

    public String convertMap2String(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(key);
            sb.append(":");
            sb.append(map.get(key));
            sb.append(",");
        }
        return sb.toString();
    }
}

