/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.naming.pojo.healthcheck.AbstractHealthChecker;
import com.alibaba.nacos.api.naming.pojo.healthcheck.HealthCheckType;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.core.Instance;
import com.alibaba.nacos.naming.core.Service;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.push.PushService;
import com.alibaba.nacos.naming.web.CanDistro;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="namingHealthController")
@RequestMapping(value={"/v1/ns/health"})
public class HealthController {
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private PushService pushService;

    @RequestMapping(value={"/server"})
    public ObjectNode server() {
        ObjectNode result = JacksonUtils.createEmptyJsonNode();
        result.put("msg", "Hello! I am Nacos-Naming and healthy! total services: raft " + this.serviceManager.getServiceCount() + ", local port:" + EnvUtil.getPort());
        return result;
    }

    @CanDistro
    @PutMapping(value={"", "/instance"})
    @Secured(action=ActionTypes.WRITE)
    public String update(HttpServletRequest request) {
        String healthyString = WebUtils.optional((HttpServletRequest)request, (String)"healthy", (String)"");
        if (StringUtils.isBlank((CharSequence)healthyString)) {
            healthyString = WebUtils.optional((HttpServletRequest)request, (String)"valid", (String)"");
        }
        if (StringUtils.isBlank((CharSequence)healthyString)) {
            throw new IllegalArgumentException("Param 'healthy' is required.");
        }
        boolean valid = BooleanUtils.toBoolean((String)healthyString);
        String serviceName = WebUtils.required((HttpServletRequest)request, (String)"serviceName");
        String namespaceId = WebUtils.optional((HttpServletRequest)request, (String)"namespaceId", (String)"public");
        String clusterName = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"DEFAULT");
        String ip = WebUtils.required((HttpServletRequest)request, (String)"ip");
        int port = Integer.parseInt(WebUtils.required((HttpServletRequest)request, (String)"port"));
        Service service = this.serviceManager.getService(namespaceId, serviceName);
        if (HealthCheckType.NONE.name().equals(service.getClusterMap().get(clusterName).getHealthChecker().getType())) {
            for (Instance instance : service.allIPs(Lists.newArrayList((Object[])new String[]{clusterName}))) {
                if (!instance.getIp().equals(ip) || instance.getPort() != port) continue;
                instance.setHealthy(valid);
                Loggers.EVT_LOG.info((valid ? "[IP-ENABLED]" : "[IP-DISABLED]") + " ips: " + instance.getIp() + ":" + instance.getPort() + "@" + instance.getClusterName() + ", service: " + serviceName + ", msg: update thought HealthController api");
                this.pushService.serviceChanged(service);
                break;
            }
        } else {
            throw new IllegalArgumentException("health check is still working, service: " + serviceName);
        }
        return "ok";
    }

    @GetMapping(value={"checkers"})
    public ResponseEntity checkers() {
        List classes = HealthCheckType.getLoadedHealthCheckerClasses();
        HashMap<String, AbstractHealthChecker> checkerMap = new HashMap<String, AbstractHealthChecker>(8);
        for (Class clazz : classes) {
            try {
                AbstractHealthChecker checker = (AbstractHealthChecker)clazz.newInstance();
                checkerMap.put(checker.getType(), checker);
            }
            catch (IllegalAccessException | InstantiationException e) {
                Loggers.EVT_LOG.error("checkers error ", (Throwable)e);
            }
        }
        return ResponseEntity.ok(checkerMap);
    }
}

