/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.controllers;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.distributed.distro.DistroProtocol;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.DistroHttpData;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.combined.DistroHttpCombinedKey;
import com.alibaba.nacos.naming.core.Instances;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.SwitchDomain;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/ns/distro"})
public class DistroController {
    @Autowired
    private DistroProtocol distroProtocol;
    @Autowired
    private ServiceManager serviceManager;
    @Autowired
    private SwitchDomain switchDomain;

    @PutMapping(value={"/datum"})
    public ResponseEntity onSyncDatum(@RequestBody Map<String, Datum<Instances>> dataMap) throws Exception {
        if (dataMap.isEmpty()) {
            Loggers.DISTRO.error("[onSync] receive empty entity!");
            throw new NacosException(400, "receive empty entity!");
        }
        for (Map.Entry<String, Datum<Instances>> entry : dataMap.entrySet()) {
            String serviceName;
            if (!KeyBuilder.matchEphemeralInstanceListKey(entry.getKey())) continue;
            String namespaceId = KeyBuilder.getNamespace(entry.getKey());
            if (!this.serviceManager.containService(namespaceId, serviceName = KeyBuilder.getServiceName(entry.getKey())) && this.switchDomain.isDefaultInstanceEphemeral()) {
                this.serviceManager.createEmptyService(namespaceId, serviceName, true);
            }
            DistroHttpData distroHttpData = new DistroHttpData(this.createDistroKey(entry.getKey()), entry.getValue());
            this.distroProtocol.onReceive((DistroData)distroHttpData);
        }
        return ResponseEntity.ok((Object)"ok");
    }

    @PutMapping(value={"/checksum"})
    public ResponseEntity syncChecksum(@RequestParam String source, @RequestBody Map<String, String> dataMap) {
        DistroHttpData distroHttpData = new DistroHttpData(this.createDistroKey(source), dataMap);
        this.distroProtocol.onVerify((DistroData)distroHttpData);
        return ResponseEntity.ok((Object)"ok");
    }

    @GetMapping(value={"/datum"})
    public ResponseEntity get(@RequestBody String body) throws Exception {
        JsonNode bodyNode = JacksonUtils.toObj((String)body);
        String keys = bodyNode.get("keys").asText();
        String keySplitter = ",";
        DistroHttpCombinedKey distroKey = new DistroHttpCombinedKey("com.alibaba.nacos.naming.iplist.", "");
        for (String key : keys.split(keySplitter)) {
            distroKey.getActualResourceTypes().add(key);
        }
        DistroData distroData = this.distroProtocol.onQuery((DistroKey)distroKey);
        return ResponseEntity.ok((Object)distroData.getContent());
    }

    @GetMapping(value={"/datums"})
    public ResponseEntity getAllDatums() {
        DistroData distroData = this.distroProtocol.onSnapshot("com.alibaba.nacos.naming.iplist.");
        return ResponseEntity.ok((Object)distroData.getContent());
    }

    private DistroKey createDistroKey(String resourceKey) {
        return new DistroKey(resourceKey, "com.alibaba.nacos.naming.iplist.");
    }
}

