/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.ephemeral.distro.component;

import com.alibaba.nacos.core.distributed.distro.component.DistroDataStorage;
import com.alibaba.nacos.core.distributed.distro.entity.DistroData;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;
import com.alibaba.nacos.naming.cluster.transport.Serializer;
import com.alibaba.nacos.naming.consistency.Datum;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.DataStore;
import com.alibaba.nacos.naming.consistency.ephemeral.distro.combined.DistroHttpCombinedKey;
import com.alibaba.nacos.naming.core.DistroMapper;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.HashMap;
import java.util.Map;

public class DistroDataStorageImpl
implements DistroDataStorage {
    private final DataStore dataStore;
    private final DistroMapper distroMapper;

    public DistroDataStorageImpl(DataStore dataStore, DistroMapper distroMapper) {
        this.dataStore = dataStore;
        this.distroMapper = distroMapper;
    }

    public DistroData getDistroData(DistroKey distroKey) {
        Map<Object, Object> result = new HashMap(1);
        if (distroKey instanceof DistroHttpCombinedKey) {
            result = this.dataStore.batchGet(((DistroHttpCombinedKey)distroKey).getActualResourceTypes());
        } else {
            Datum datum = this.dataStore.get(distroKey.getResourceKey());
            result.put(distroKey.getResourceKey(), datum);
        }
        byte[] dataContent = ((Serializer)ApplicationUtils.getBean(Serializer.class)).serialize(result);
        return new DistroData(distroKey, dataContent);
    }

    public DistroData getDatumSnapshot() {
        Map<String, Datum> result = this.dataStore.getDataMap();
        byte[] dataContent = ((Serializer)ApplicationUtils.getBean(Serializer.class)).serialize(result);
        DistroKey distroKey = new DistroKey("snapshot", "com.alibaba.nacos.naming.iplist.");
        return new DistroData(distroKey, dataContent);
    }

    public DistroData getVerifyData() {
        HashMap<String, String> keyChecksums = new HashMap<String, String>(64);
        for (String key : this.dataStore.keys()) {
            Datum datum;
            if (!this.distroMapper.responsible(KeyBuilder.getServiceName(key)) || (datum = this.dataStore.get(key)) == null) continue;
            keyChecksums.put(key, datum.value.getChecksum());
        }
        if (keyChecksums.isEmpty()) {
            return null;
        }
        DistroKey distroKey = new DistroKey("checksum", "com.alibaba.nacos.naming.iplist.");
        return new DistroData(distroKey, ((Serializer)ApplicationUtils.getBean(Serializer.class)).serialize(keyChecksums));
    }
}

